/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;

public class PBRefreshAction
implements IElementMultiAction {
    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_REFRESH);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Refresh", (String)"Refresh", (String)"Refresh Dictionary Explorer", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IProjectNature nature = null;
                try {
                    nature = eclipseProject.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                    if (nature != null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    ProjectBrowserPlugin.tracer.error("get nature");
                }
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                boolean enable = false;
                if (metaClass != null) {
                    enable = metaClass.equals("Model");
                }
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        if (i < elements.length) {
            return elements[i] instanceof Entity;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            DataSourceManager dataSourceManager;
            String projectName = elements[i].getModel().getUniqueName().getName();
            if (projectName != null && projectName.length() > 0 && (dataSourceManager = DataSourceManager.getDataSourceManager((String)projectName)) != null) {
                dataSourceManager.refresh();
            }
            ++i;
        }
    }
}

