/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.CopyDbTableWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.CopySimpleTypeWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.CopyStructureWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryDevelopmentObjectEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelObject;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.sap.ide.metamodel.general.clipboard.PasteProcess;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.IncompleteRefactoringInfoException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PBPasteAction
implements IElementSingleAction {
    private static final String TYPE_SIMPLE = "DtSimpleType";
    private static final String TYPE_TABLE = "DtDbTable";
    private static final String TYPE_STRUCTURE = "DtStructure";

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DDIC_PASTE);
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)"ddic:Paste", (String)"Paste", (String)"Paste", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            UniqueName uniqueName = element.getUniqueName();
            boolean enable = false;
            if (uniqueName.getDomain().equals("Dictionaries")) {
                enable = true;
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            String projectName = element.getModel().getUniqueName().getName();
            if (projectName != null && projectName.length() > 0) {
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (eclipseProject != null) {
                    Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
                    MetamodelClipboard clipboard = Metamodel.getClipboard();
                    return clipboard.isPasteAllowed((MetamodelObject)DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot());
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void run(Element element) {
        IProject eclipseProject;
        if (element == null) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName != null && projectName.length() > 0 && (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && element instanceof Entity) {
            Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
            MetamodelClipboard clipboard = Metamodel.getClipboard();
            String name = projectName;
            PasteProcess lProcess = clipboard.initiatePaste((MetamodelObject)MetamodelServices.getDictionaryRoot((String)projectName));
            ClipboardObject[] lObjects = lProcess.getClipboardContent();
            int i = 0;
            while (i < lObjects.length) {
                WizardDialog wizardDialog;
                CopySimpleTypeWizard wiz;
                ClipboardObject lObject = lObjects[i];
                if (lObject.getType() == DtDictionaryDevelopmentObjectEnum.DTSIMPLETYPE) {
                    if (lObject.requiresRefactoring()) {
                        wiz = new CopySimpleTypeWizard(DataSourceManager.getDataSourceManager((String)name), lObject);
                        wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wiz);
                        if (wizardDialog.open() == 1) {
                            lObject.setExcluded(true);
                        }
                    }
                } else if (lObject.getType() == DtDictionaryDevelopmentObjectEnum.DTGENERALSTRUCTURE) {
                    if (lObject.requiresRefactoring()) {
                        wiz = new CopyStructureWizard(DataSourceManager.getDataSourceManager((String)name), lObject);
                        wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wiz);
                        if (wizardDialog.open() == 1) {
                            lObject.setExcluded(true);
                        }
                    }
                } else if (lObject.getType() == DtDictionaryDevelopmentObjectEnum.DTDBTABLE) {
                    wiz = new CopyDbTableWizard(DataSourceManager.getDataSourceManager((String)name), lObject, true);
                    wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wiz);
                    if (wizardDialog.open() == 1) {
                        lObject.setExcluded(true);
                    }
                } else if (lObject.getType() == DtDictionaryDevelopmentObjectEnum.DTDBVIEW) {
                    wiz = new CopyDbTableWizard(DataSourceManager.getDataSourceManager((String)name), lObject, false);
                    wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wiz);
                    if (wizardDialog.open() == 1) {
                        lObject.setExcluded(true);
                    }
                }
                ++i;
            }
            try {
                DevelopmentObject[] objs = lProcess.execute();
                int i2 = 0;
                while (i2 < objs.length) {
                    if (objs[i2] instanceof DtSimpleType) {
                        DtSimpleType stype = (DtSimpleType)objs[i2];
                        stype.setTypeName(stype.getName());
                    }
                    ++i2;
                }
                MetamodelManager.saveAllMetaData((String)projectName);
            }
            catch (CreateException e) {
                ProjectBrowserPlugin.tracer.error("paste:", (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Could not paste object");
            }
            catch (IncompleteRefactoringInfoException e2) {
                ProjectBrowserPlugin.tracer.error("paste:", (Throwable)e2);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Could not paste object");
            }
        }
    }
}

