/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableAction;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableInput;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PBEditDbTableAction
implements IElementSingleAction {
    private String text = "";
    private EditDbTableAction mEditDbTableAction = null;

    public PBEditDbTableAction() {
        this.mEditDbTableAction = new EditDbTableAction();
    }

    public PBEditDbTableAction(String text) {
        this.text = text;
    }

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_UITABLE);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Edit", (String)"Edit", (String)"Edit", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            String metaClass = entity.getPropertyValue("$metaclass");
            boolean enable = false;
            if (metaClass != null) {
                enable = metaClass.equals("DDDbTable");
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            String projectName;
            DtDbTable dtDbTable;
            return element.getUniqueName().getSubDomain() != "DbTable" || (dtDbTable = (DtDbTable)DataSourceManager.getDataSourceManager((String)(projectName = element.getModel().getUniqueName().getName())).getDevelopmentObject(element.getUniqueName())).getPredefinedAction() != "DROP";
        }
        return false;
    }

    public void run(Element element) {
        IWorkbenchWindow dwindow;
        IWorkbenchPage page;
        if (element == null) {
            return;
        }
        if (element instanceof Entity && (page = (dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            String projectName = element.getModel().getUniqueName().getName();
            DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
            DtDbTable table = (DtDbTable)manager.getDevelopmentObject(element.getUniqueName());
            IEditorReference[] ref = page.getEditorReferences();
            int j = 0;
            while (j < ref.length) {
                IEditorInput input = ref[j].getEditor(false).getEditorInput();
                if (input instanceof EditDbTableInput) {
                    if (((EditDbTableInput)input).dictDbTable == table) {
                        try {
                            ((TableEditor)page.openEditor(input, "com.sap.dictionary.tools.tableeditor.TableEditor")).setTableEditorPage(0);
                            return;
                        }
                        catch (PartInitException e) {
                            ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
                        }
                    }
                } else if (input instanceof IFileEditorInput) {
                    DtDictionaryRoot lDictRoot;
                    IFile file = ((IFileEditorInput)input).getFile();
                    String lFileName = file.getFullPath().removeFileExtension().lastSegment();
                    IProject project = file.getProject();
                    String lProjectName = project.getName();
                    if (ServicesEclipse.projectHasDictionaryNature((String)lProjectName) && (lDictRoot = MetamodelServices.getDictionaryRoot((String)lProjectName)).hasTable("", lFileName)) {
                        try {
                            DtDbTable ltable = lDictRoot.getTable("", lFileName);
                            if (ltable == table) {
                                try {
                                    IEditorPart editorPart = page.openEditor(input, "com.sap.dictionary.tools.tableeditor.TableEditor");
                                    if (editorPart instanceof TableEditor) {
                                        ((TableEditor)editorPart).setTableEditorPage(0);
                                    }
                                    return;
                                }
                                catch (PartInitException e) {
                                    ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
                                }
                            }
                        }
                        catch (LoadException e) {
                            ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
                        }
                    }
                }
                ++j;
            }
            try {
                ((TableEditor)page.openEditor((IEditorInput)new EditDbTableInput(MetamodelServices.getMetamodel((String)projectName), MetamodelServices.getDictionaryRoot((String)projectName), table), "com.sap.dictionary.tools.tableeditor.TableEditor", true)).setTableEditorPage(0);
            }
            catch (PartInitException e) {
                ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
            }
        }
    }
}

