/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableInput;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PBEditDbIndexAction
implements IElementSingleAction {
    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_INDEXNOTUNIQUE);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Edit Index", (String)"Edit Index", (String)"Edit Index", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            Entity entity = (Entity)element;
            String metaClass = entity.getPropertyValue("$metaclass");
            boolean enable = false;
            if (metaClass != null) {
                enable = metaClass.equals("DDDbIndex");
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        return element instanceof Entity;
    }

    public void run(Element element) {
        IWorkbenchWindow dwindow;
        IWorkbenchPage page;
        if (element == null) {
            return;
        }
        if (element instanceof Entity && (page = (dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()) != null) {
            String projectName = element.getModel().getUniqueName().getName();
            DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
            DtDbIndex index = (DtDbIndex)manager.getDevelopmentObject(element.getUniqueName());
            DtDbTable table = null;
            if (index != null) {
                table = (DtDbTable)index.getParent();
            }
            IEditorReference[] ref = page.getEditorReferences();
            int j = 0;
            while (j < ref.length) {
                IEditorInput input = ref[j].getEditor(false).getEditorInput();
                if (input instanceof EditDbTableInput && ((EditDbTableInput)input).dictDbTable == table) {
                    try {
                        ((TableEditor)page.openEditor(input, "com.sap.dictionary.tools.tableeditor.TableEditor")).setIndexPage(index.getName());
                        return;
                    }
                    catch (PartInitException e) {
                        ProjectBrowserPlugin.tracer.error("couldn't open editor for table " + table.getName());
                    }
                }
                ++j;
            }
            try {
                ((TableEditor)page.openEditor((IEditorInput)new EditDbTableInput(MetamodelServices.getMetamodel((String)projectName), MetamodelServices.getDictionaryRoot((String)projectName), table), "com.sap.dictionary.tools.tableeditor.TableEditor", true)).setIndexPage(index.getName());
            }
            catch (PartInitException e) {
                ProjectBrowserPlugin.tracer.error("open editor", (Throwable)e);
            }
        }
    }
}

