/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.eclipse.sdm.SDMManager;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.services.MultilineTextDialog;
import com.tssap.dii.component.IDCProject;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class PBDeploySDMAction
implements IElementSingleAction {
    public static final String NATURE_ID_WEBDYNPRO = "com.sap.ide.webdynpro.archivebuilder.WebDynproNature";
    private File sdaFile = null;
    private IProject eclipseProject = null;
    private boolean warning = false;

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DEPLOY);
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainRuntimeCategory(), (String)"ddic:Deploy", (String)"Deploy", (String)"Deploy", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            String projectName = element.getModel().getUniqueName().getName();
            IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IProjectNature nature = null;
            try {
                nature = eclipseProject.getNature(NATURE_ID_WEBDYNPRO);
                if (nature != null) {
                    return false;
                }
            }
            catch (CoreException e) {
                ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
            }
            Entity entity = (Entity)element;
            String metaClass = entity.getPropertyValue("$metaclass");
            boolean enable = false;
            if (metaClass != null) {
                enable = metaClass.equals("Model");
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        return element instanceof Entity;
    }

    public static void openDialog(String mes, String title, ByteArrayOutputStream stream) {
        final String message = mes;
        final String tit = title;
        final ByteArrayOutputStream logStream = stream;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                new MyMultilineTextDialog(tit, message, logStream).open();
            }
        });
    }

    public void deploy(Element element) {
        block13: {
            if (element == null) {
                return;
            }
            String projectName = element.getModel().getUniqueName().getName();
            if (projectName != null && projectName.length() > 0) {
                this.eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (this.eclipseProject != null && element instanceof Entity) {
                    try {
                        String path = this.eclipseProject.getLocation().toOSString();
                        IProjectNature nature = this.eclipseProject.getNature("com.sap.ide.eclipse.component.provider.dcnature");
                        if (nature instanceof IDCProject) {
                            String buildVariant = ((IDCProject)nature).getBuildVariant();
                            if (buildVariant == null) {
                                buildVariant = "dbg";
                            }
                            String pn = ((IDCProject)nature).getDCName().replace('/', '~');
                            String sdaName = ((IDCProject)nature).getDCVendor() + "~" + pn + ".sda";
                            this.sdaFile = new File(path + "/gen/" + buildVariant + "/deploy/" + sdaName);
                        } else {
                            this.sdaFile = new File(path + "/" + projectName + ".sda");
                        }
                        if (this.sdaFile.exists()) {
                            this.warning = false;
                            try {
                                SDMManager manager = SDMManager.getInstance();
                                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.sdaFile.getAbsolutePath()));
                                manager.deployArchiveAsync(file, ProjectBrowserPlugin.tracer);
                            }
                            catch (DeploymentException e) {
                                if (e.isOnlyWarning()) {
                                    this.warning = true;
                                }
                                ProjectBrowserPlugin.tracer.error("Couldn't deploy SDA : ", (Throwable)e);
                                if (this.warning) {
                                    PBDeploySDMAction.openDialog("Could not deploy archive correctly. Reason: " + e.getMessage() + ". ", "Warning", null);
                                    break block13;
                                }
                                PBDeploySDMAction.openDialog("Could not deploy archive correctly. Reason: " + e.getMessage() + ". ", "Error", null);
                            }
                            break block13;
                        }
                        PBDeploySDMAction.openDialog("Archive file does not exist", "Error", null);
                    }
                    catch (Exception e) {
                        ProjectBrowserPlugin.tracer.error("deploy", (Throwable)e);
                        PBDeploySDMAction.openDialog("Could not deploy archive correctly. Reason: " + e.getMessage(), "Error", null);
                    }
                }
            }
        }
    }

    public void run(Element element) {
        if (element == null) {
            return;
        }
        this.deploy(element);
    }

    private static class MyMultilineTextDialog
    extends MultilineTextDialog {
        private ByteArrayOutputStream logStream;

        public MyMultilineTextDialog(String title, String message, ByteArrayOutputStream stream) {
            super(title, message);
            this.logStream = stream;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            if (this.logStream != null) {
                Button details = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
                details.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ MyMultilineTextDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        super.widgetSelected(e);
                        if (MyMultilineTextDialog.access$000(this.this$0) != null) {
                            new MultilineTextDialog("Detailed Log", MyMultilineTextDialog.access$000(this.this$0).toString()).open();
                        }
                    }
                });
            }
            super.createButtonsForButtonBar(parent);
        }

        static /* synthetic */ ByteArrayOutputStream access$000(MyMultilineTextDialog x0) {
            return x0.logStream;
        }
    }
}

