/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.MySdmListener;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.projectbrowser.actions.PBDeploySDMAction;
import com.sap.dictionary.tools.archivebuilder.ui.AsyncUIServices;
import com.sap.dictionary.tools.generation.eclipse.GenerationEclipse;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.eclipse.sdm.SDMManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.tools.archive.ArchiveBuilder;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IComponentBuildInfo;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.File;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PBDeployDbTableAction
implements IElementMultiAction {
    private String deployFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SDA>   <SoftwareType>JDDSCHEMA</SoftwareType></SDA>";
    MySdmListener mSdmListener = MySdmListener.getInstance();
    boolean ret = false;
    static /* synthetic */ Class array$Lcom$tssap$selena$model$elements$Element;

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DEPLOY);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Deploy Table", (String)"Deploy Table", (String)"Deploy Table", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                boolean enable = false;
                if (metaClass != null) {
                    enable = metaClass.equals("DDDbTable");
                }
                String projectName = entity.getModel().getUniqueName().getName();
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IProject eclipseProject = workspaceRoot.getProject(projectName);
                try {
                    if (eclipseProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                        enable = false;
                    }
                }
                catch (CoreException e) {
                    ProjectBrowserPlugin.tracer.error("get dc nature", (Throwable)e);
                }
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName;
                DtDbTable dtDbTable;
                if (elements[i].getUniqueName().getSubDomain() == "DbTable" && (dtDbTable = (DtDbTable)DataSourceManager.getDataSourceManager((String)(projectName = elements[i].getModel().getUniqueName().getName())).getDevelopmentObject(elements[i].getUniqueName())).getPredefinedAction() == "DROP") {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        Object[] arguments = new Object[]{elements};
        Class[] parameterTypes = new Class[]{array$Lcom$tssap$selena$model$elements$Element == null ? (array$Lcom$tssap$selena$model$elements$Element = PBDeployDbTableAction.class$("[Lcom.tssap.selena.model.elements.Element;")) : array$Lcom$tssap$selena$model$elements$Element};
        new AsyncUIServices().openAnimatedProgressDialog(true, (Object)this, "deployTables", arguments, parameterTypes, "Drop&Create table");
    }

    public void deployTables(Element[] elements, IProgressMonitor monitor) {
        this.ret = true;
        final IProgressMonitor fMonitor = monitor;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                fMonitor.beginTask("Deploy Table", -1);
            }
        });
        if (this.ret) {
            Vector<DtDbTable> dbTables = new Vector<DtDbTable>();
            IProject project = null;
            Vector<IProject> projects = new Vector<IProject>();
            int i = 0;
            while (i < elements.length) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
                DtDbTable table = (DtDbTable)manager.getDevelopmentObject(elements[i].getUniqueName());
                dbTables.add(table);
                projects.add(project);
                ++i;
            }
            if (dbTables.size() > 0) {
                this.buildDeploySda(dbTables, projects);
            }
        }
    }

    private void buildDeploySda(Vector dbTables, Vector projects) {
        final IArchiveDescriptor arDesc = ArchiveDescriptionManager.newArchiveDescription();
        IProjectFileSet fs = ArchiveDescriptionManager.getProjectFileSet();
        int i = 0;
        while (i < dbTables.size()) {
            DtDbTable table = (DtDbTable)dbTables.get(i);
            IProject project = (IProject)projects.get(i);
            IPath path = project.getLocation().append(GenerationEclipse.getGenerationOutputPathInfix() + "/" + "dbtables" + "/" + table.getName() + ".gdbtable");
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (!file.exists()) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Generated file for selected table not found. Please rebuild project");
                    }
                });
                return;
            }
            fs.addProjectFile(file);
            ++i;
        }
        arDesc.addFileSet((IFileSet)fs);
        IProject project = (IProject)projects.get(0);
        final IFile file = project.getFile("tmp.sda");
        arDesc.setDestPath(file);
        IComponentBuildInfo buildInfo = arDesc.getComponentBuildInfo();
        buildInfo.setDeployFileContent(this.deployFileContent);
        buildInfo.getComponent().setVendor("sap.com");
        buildInfo.getComponent().setName(project.getName());
        buildInfo.setUseComponentBuild(true);
        ArchiveBuilder.suppressMonitorDialog((boolean)true);
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    arDesc.performBuild();
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    if (file.exists()) {
                        file.setDerived(true);
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ProjectBrowserPlugin.tracer.error("creating archive", (Throwable)e);
        }
        File sdaFile = new File(file.getLocation().toOSString());
        if (sdaFile.exists()) {
            final SDMManager manager = SDMManager.getInstance();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        PBDeployDbTableAction.this.mSdmListener.setFile(file);
                        manager.deployArchiveAsync(file, ProjectBrowserPlugin.tracer);
                    }
                    catch (DeploymentException e) {
                        ProjectBrowserPlugin.tracer.error("deployment", (Throwable)e);
                        PBDeploySDMAction.openDialog("Could not deploy archive correctly. Reason: " + e.getMessage() + ". ", "Warning", null);
                    }
                }
            });
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

