/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteAction;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;

public class PBDeleteStructureAction
implements IElementMultiAction {
    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DELETE);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Delete", (String)"Delete", (String)"Delete", (Image)image);
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        if (i < elements.length) {
            return elements[i] instanceof Entity;
        }
        return true;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                if (metaClass != null && !metaClass.equals("DDStructure")) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        if (PBDeleteAction.askUserToDelete()) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof Entity) {
                    String projectName = elements[i].getModel().getUniqueName().getName();
                    if (elements[i].canDelete()) {
                        elements[i].delete();
                        if (projectName != null && projectName.length() > 0) {
                            MetamodelManager.saveAllMetaData((String)projectName);
                            IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                            try {
                                eclipseProject.refreshLocal(2, null);
                            }
                            catch (CoreException e) {
                                ProjectBrowserPlugin.tracer.error("refresh local", (Throwable)e);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }
}

