/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.TextPool;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteAction;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbViewInput;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PBDeleteDbViewAction
implements IElementMultiAction {
    private String text = "";
    private static final String TABLE_DELETED = "DROP";
    private static final String CLASS_DELETE_VIEW = "PBDeleteDbViewAction";

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DELETE);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Delete Db View", (String)"Delete Db View", (String)"Delete Db View", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                if (metaClass != null && !metaClass.equals("DDDbView")) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName;
                DtDbView dtDbView;
                if (elements[i].getUniqueName().getSubDomain() == "DbView" && (dtDbView = (DtDbView)DataSourceManager.getDataSourceManager((String)(projectName = elements[i].getModel().getUniqueName().getName())).getDevelopmentObject(elements[i].getUniqueName())).getPredefinedAction() == TABLE_DELETED) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        String projectName = null;
        DevelopmentObject developmentObject = null;
        DtDbView dtDbView = null;
        MetamodelManager metamodelManager = null;
        Metamodel metamodel = null;
        String predefinedAction = null;
        boolean markedAsDeleted = false;
        String TABLE_NOT_DELETABLE = "Db View cannot be deleted";
        if (elements == null) {
            return;
        }
        if (PBDeleteAction.askUserToDelete()) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof Entity) {
                    projectName = elements[i].getModel().getUniqueName().getName();
                    developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(elements[i].getUniqueName());
                    if (developmentObject == null) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CLASS_DELETE_VIEW, (String)"Development object is NULL");
                    } else if (!(developmentObject instanceof DtDbView)) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CLASS_DELETE_VIEW, (String)"Development object is not a table");
                    } else {
                        metamodelManager = MetamodelManager.getMetamodelManager((String)projectName);
                        if (metamodelManager != null) {
                            metamodel = metamodelManager.getMetamodel();
                        }
                        if (metamodelManager == null || metamodel == null) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CLASS_DELETE_VIEW, (String)"Could not get metamodel");
                        } else {
                            dtDbView = (DtDbView)developmentObject;
                            if (dtDbView.isReadOnly()) {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Table is read-only", (String)"Cannot delete table. Check out table for edit");
                                return;
                            }
                            if (dtDbView.getName() == null) {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Db View cannot be deleted", (String)"Table name is missing");
                            } else {
                                predefinedAction = dtDbView.getPredefinedAction();
                                if (predefinedAction != null && predefinedAction.equals(TABLE_DELETED)) {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Db View cannot be deleted", (String)TextPool.getMessage("Table & is already deleted", dtDbView.getName()));
                                } else {
                                    dtDbView.setPredefinedAction(TABLE_DELETED);
                                    MetamodelManager.saveAllMetaData((String)projectName);
                                    this.closeEditor(dtDbView);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private boolean closeEditor(DtDbView dtDbView) {
        IEditorReference[] editorReferences = null;
        IEditorPart editor = null;
        IEditorInput editorInput = null;
        Object tableName = null;
        Object fileName = null;
        boolean editorClosed = false;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            editorReferences = pages[i].getEditorReferences();
            int j = 0;
            while (j < editorReferences.length) {
                editor = editorReferences[j].getEditor(false);
                editorInput = editor.getEditorInput();
                if (editorInput instanceof EditDbViewInput && ((EditDbViewInput)editorInput).dictDbView == dtDbView) {
                    pages[i].closeEditor(editor, false);
                    editorClosed = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return editorClosed;
    }
}

