/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.TextPool;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.projectbrowser.actions.PBDeleteAction;
import com.sap.dictionary.tools.tableeditor.TableEditor;
import com.sap.dictionary.tools.tableeditor.util.TableUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableAction;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableInput;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.plugin.MetamodelCoreEclipsePlugin;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.BooleanEnum;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtPrimaryKey;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import com.sap.ide.metamodel.dictionary.datatype.FieldTypeEnum;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.ui.SelectActivityDialog;
import com.tssap.dtr.client.eclipse.ui.util.WorkspacesWithDefaultActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PBDeleteDbTableAction
implements IElementMultiAction {
    private String text = "";
    private EditDbTableAction mEditDbTableAction = null;
    private static final String TABLE_DELETED = "DROP";
    private static final String CLASS_DELETE_TABLE = "PBDeleteDbTableAction";
    private static final String COLUMN_DUMMY = "DDDUMMY";
    static /* synthetic */ Class class$com$sap$ide$metamodel$core$repository$RepositoryServices;

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DELETE);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Delete Table", (String)"Delete Table", (String)"Delete Table", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                if (metaClass != null && !metaClass.equals("DDDbTable")) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName;
                DtDbTable dtDbTable;
                if (elements[i].getUniqueName().getSubDomain() == "DbTable" && (dtDbTable = (DtDbTable)DataSourceManager.getDataSourceManager((String)(projectName = elements[i].getModel().getUniqueName().getName())).getDevelopmentObject(elements[i].getUniqueName())).getPredefinedAction() == TABLE_DELETED) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        String projectName = null;
        DevelopmentObject developmentObject = null;
        DtDbTable dtDbTable = null;
        MetamodelManager metamodelManager = null;
        Metamodel metamodel = null;
        String predefinedAction = null;
        EditDbTableAction editDbTableAction = null;
        boolean markedAsDeleted = false;
        String TABLE_NOT_DELETABLE = "Table cannot be deleted";
        if (elements == null) {
            return;
        }
        if (PBDeleteAction.askUserToDelete()) {
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof Entity) {
                    projectName = elements[i].getModel().getUniqueName().getName();
                    developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(elements[i].getUniqueName());
                    if (developmentObject == null) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CLASS_DELETE_TABLE, (String)"Development object is NULL");
                    } else if (!(developmentObject instanceof DtDbTable)) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CLASS_DELETE_TABLE, (String)"Development object is not a table");
                    } else {
                        metamodelManager = MetamodelManager.getMetamodelManager((String)projectName);
                        if (metamodelManager != null) {
                            metamodel = metamodelManager.getMetamodel();
                        }
                        if (metamodelManager == null || metamodel == null) {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)CLASS_DELETE_TABLE, (String)"Could not get metamodel");
                        } else {
                            dtDbTable = (DtDbTable)developmentObject;
                            if (dtDbTable.isReadOnly()) {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Table is read-only", (String)"Cannot delete table. Check out table for edit");
                                return;
                            }
                            if (dtDbTable.getName() == null) {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Table cannot be deleted", (String)"Table name is missing");
                            } else {
                                predefinedAction = dtDbTable.getPredefinedAction();
                                if (predefinedAction != null && predefinedAction.equals(TABLE_DELETED)) {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Table cannot be deleted", (String)TextPool.getMessage("Table & is already deleted", dtDbTable.getName()));
                                } else {
                                    this.markTableAsDeleted(metamodel, dtDbTable);
                                    if (this.closeEditor(dtDbTable)) {
                                        editDbTableAction = new EditDbTableAction();
                                        editDbTableAction.setSelectedElement(elements[i]);
                                        editDbTableAction.run((IAction)null);
                                    }
                                    MetamodelManager.saveAllMetaData((String)projectName);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private void markTableAsDeleted(Metamodel metamodel, DtDbTable dtDbTable) {
        dtDbTable.setPredefinedAction(TABLE_DELETED);
        DtStructureElement[] structureElements = dtDbTable.getStructureElements();
        int i = 0;
        while (i < structureElements.length) {
            try {
                structureElements[i].delete();
            }
            catch (DeleteException e) {
                ProjectBrowserPlugin.tracer.error("delete structure element of table", dtDbTable.getName());
            }
            ++i;
        }
        DtPrimaryKey dtPrimaryKey = dtDbTable.getPrimaryKey();
        if (dtPrimaryKey != null) {
            try {
                dtPrimaryKey.delete();
            }
            catch (DeleteException e) {
                ProjectBrowserPlugin.tracer.error("delete primary key of table " + dtDbTable.getName());
            }
        }
        try {
            DtField dtField = dtDbTable.createStructureElementAsDtField(COLUMN_DUMMY);
            dtField.setPosition(0);
            dtField.setFieldType(FieldTypeEnum.SIMPLE);
            dtField.setBuiltInType("string");
            dtField.setNotNull(BooleanEnum.FALSE);
            DatabaseEnum[] databases = TableUtil.getDatabaseEnum();
            if (databases != null) {
                String jdbcType = TableUtil.getJdbcType((String)"string", (int)0, (DatabaseEnum[])databases);
                dtField.setJdbcTypeName(jdbcType);
            }
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("create dummy column", (Throwable)e);
        }
        DtDbIndex[] dbIndices = dtDbTable.getDbIndexes();
        int i2 = 0;
        while (i2 < dbIndices.length) {
            try {
                if (!dbIndices[i2].canDelete()) {
                    String path = dbIndices[i2].getAbsolutePath();
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(path));
                    if (file.exists() && this.checkout(dbIndices[i2], file)) {
                        dbIndices[i2].delete();
                    }
                } else {
                    dbIndices[i2].delete();
                }
            }
            catch (DeleteException e) {
                ProjectBrowserPlugin.tracer.error("delete indices of table " + dtDbTable.getName());
            }
            ++i2;
        }
    }

    private boolean checkout(DtDbIndex dbIndex, IFile file) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(dbIndex.getMetamodel().getName());
        if (project == null) {
            return false;
        }
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            return false;
        }
        if (!DtrHelper.isUserLoggedOn((IProject)project) && !DtrHelper.logon((IProject)project)) {
            return false;
        }
        IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem = DtrHelper.getVfsActivityRecordedFolderItem((DAVTeamProvider)teamProvider, (IFile)file);
        if (vfsActivityRecordedFolderItem != null) {
            IVfsActivity vfsActivity = null;
            if (vfsActivity == null) {
                vfsActivity = PBDeleteDbTableAction.getActivity(vfsActivityRecordedFolderItem);
            }
            if (vfsActivity != null) {
                try {
                    vfsActivityRecordedFolderItem.checkOutForEdit(vfsActivity);
                    return true;
                }
                catch (VfsException e) {
                    ProjectBrowserPlugin.tracer.error("check out", (Throwable)e);
                }
            }
        }
        return false;
    }

    private static IVfsActivity getActivity(IVfsActivityRecordedFolderItem vfsActivityRecordedFolderItem) {
        IVfsWorkspace workspace = vfsActivityRecordedFolderItem.getWorkspace();
        if (WorkspacesWithDefaultActivity.usingDefaultActivity((IVfsWorkspace)workspace)) {
            IVfsActivity vfsActivity;
            try {
                vfsActivity = workspace.getDefaultActivity();
            }
            catch (VfsException e) {
                MetamodelCoreEclipsePlugin.internalError((Class)(class$com$sap$ide$metamodel$core$repository$RepositoryServices == null ? (class$com$sap$ide$metamodel$core$repository$RepositoryServices = PBDeleteDbTableAction.class$("com.sap.ide.metamodel.core.repository.RepositoryServices")) : class$com$sap$ide$metamodel$core$repository$RepositoryServices), (String)"getActivity", (String)"getDefaultActivity failed", (Throwable)e, (boolean)false);
                return null;
            }
            return vfsActivity;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SelectActivityDialog selectActivityDialog = new SelectActivityDialog(shell, workspace);
        int selectActivityDialogResult = selectActivityDialog.open();
        if (selectActivityDialogResult != 0) {
            return null;
        }
        IVfsActivity[] activities = selectActivityDialog.getActivitySelection();
        IVfsActivity vfsActivity = activities != null && activities.length > 0 ? activities[0] : null;
        return vfsActivity;
    }

    private void deleteTable(Metamodel metamodel, DtDbTable dtDbTable, String projectName) {
        try {
            dtDbTable.delete();
        }
        catch (DeleteException e) {
            ProjectBrowserPlugin.tracer.error("delete db table", (Throwable)e);
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Metadata API", (String)"Table could not be deleted");
            return;
        }
    }

    private boolean closeEditor(DtDbTable dtDbTable) {
        IEditorReference[] editorReferences = null;
        IEditorPart editor = null;
        IEditorInput editorInput = null;
        Object tableName = null;
        Object fileName = null;
        boolean editorClosed = false;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = window.getPages();
        int i = 0;
        while (i < pages.length) {
            editorReferences = pages[i].getEditorReferences();
            int j = 0;
            while (j < editorReferences.length) {
                editor = editorReferences[j].getEditor(false);
                if (editor instanceof TableEditor) {
                    editorInput = editor.getEditorInput();
                    if (editorInput instanceof EditDbTableInput) {
                        if (((EditDbTableInput)editorInput).dictDbTable == dtDbTable) {
                            pages[i].closeEditor(editor, false);
                            editorClosed = true;
                            break;
                        }
                    } else if (editorInput instanceof IFileEditorInput) {
                        // empty if block
                    }
                }
                ++j;
            }
            ++i;
        }
        return editorClosed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

