/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.TextPool;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class PBDeleteAction
implements IElementMultiAction {
    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DELETE);
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)"ddic:Delete", (String)"Delete", (String)"Delete ddic content", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IProjectNature nature = null;
                try {
                    if (eclipseProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                        return false;
                    }
                    nature = eclipseProject.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                    if (nature != null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
                }
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                if (metaClass != null && (metaClass.equals("DDDbTable") || metaClass.equals("DDDbIndex"))) {
                    return false;
                }
                if (metaClass != null && metaClass.equals("DDSimpleType")) {
                    return false;
                }
                entity = (Entity)elements[i];
                boolean enable = entity.canDelete();
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        if (i < elements.length) {
            return elements[i] instanceof Entity;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        Vector<IProject> selectedProjects = new Vector<IProject>();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String projectName = entity.getUniqueName().getName();
                IProject project = workspaceRoot.getProject(projectName);
                if (projectName != null && !projectName.trim().equals("") && this.projectHasTables(projectName, entity)) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Project", (String)TextPool.getMessage("Project & contains database tables and therefore cannot be deleted", projectName));
                } else {
                    selectedProjects.add(project);
                }
            }
            ++i;
        }
        if (selectedProjects.size() > 0) {
            Object[] projects = selectedProjects.toArray(new IProject[0]);
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = workbenchWindow.getShell();
            DeleteResourceAction action = new DeleteResourceAction(shell);
            StructuredSelection structuredSelection = new StructuredSelection(projects);
            action.selectionChanged((IStructuredSelection)structuredSelection);
            action.run();
        }
    }

    public static boolean askUserToDelete() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String[] buttons = new String[]{"Yes", "No"};
        MessageDialog dialog = new MessageDialog(shell, "Confirm Delete", null, "Are you sure you want to delete the selected element(s)?", 3, buttons, 0);
        return dialog.open() == 0;
    }

    private boolean projectHasTables(String projectName, Entity entity) {
        IProject project = null;
        if (!ServicesEclipse.projectHasDictionaryNature((String)projectName)) {
            return false;
        }
        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null) {
            return false;
        }
        if (!DtrHelper.isProjectUnderSourceControl((IProject)project)) {
            return false;
        }
        try {
            DtDbTable[] dtDbTables = DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot().getTables();
            return dtDbTables != null && (dtDbTables == null || dtDbTables.length != 0);
        }
        catch (LoadException e) {
            ProjectBrowserPlugin.tracer.error("get ddic tables of project" + projectName, (Throwable)e);
            return false;
        }
    }
}

