/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.designtime.DtDbTableExpanded;
import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.tools.tableeditor.util.DatabaseVendorMapping;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PBCreateStatementAction
implements IElementMultiAction {
    private String text = "";

    public PBCreateStatementAction() {
    }

    public PBCreateStatementAction(String text) {
        this.text = text;
    }

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_BUILD_ALL);
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Create DDL Script", (String)"Create DDL Script", (String)"Create DDL Script", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName = elements[i].getModel().getUniqueName().getName();
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IProjectNature nature = null;
                try {
                    nature = eclipseProject.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                    if (nature != null) {
                        return false;
                    }
                }
                catch (CoreException e) {
                    ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
                }
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                boolean enable = false;
                if (metaClass != null) {
                    enable = metaClass.equals("DDDbTable");
                }
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                String projectName;
                DtDbTable dtDbTable;
                if (elements[i].getUniqueName().getSubDomain() == "DbTable" && (dtDbTable = (DtDbTable)DataSourceManager.getDataSourceManager((String)(projectName = elements[i].getModel().getUniqueName().getName())).getDevelopmentObject(elements[i].getUniqueName())).getPredefinedAction() == "DROP") {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            DevelopmentObject object;
            IProject eclipseProject;
            String projectName = elements[i].getModel().getUniqueName().getName();
            if (projectName != null && projectName.length() > 0 && (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && elements[i] instanceof Entity && (object = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(elements[i].getUniqueName())) instanceof DtDbTable) {
                DtDbTable dbTable = (DtDbTable)object;
                String predefinedAction = dbTable.getPredefinedAction();
                if (predefinedAction != null && predefinedAction.equals("DROP")) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Could not create ddl file", (String)"Table is deleted");
                } else {
                    DbSelectDialog diag = new DbSelectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), dbTable.getName());
                    if (diag.open() == 0) {
                        if (diag.selectedIndex == 0) {
                            Enumeration enumeration = DatabaseEnum.enumerate();
                            while (enumeration.hasMoreElements()) {
                                String dbSystem = ((DatabaseEnum)enumeration.nextElement()).toString();
                                String name = dbTable.getName() + "." + dbSystem.substring(0, 3);
                                this.createDdlFile(eclipseProject, dbTable, name, dbSystem);
                            }
                        } else if (diag.selectedIndex > -1) {
                            String name = dbTable.getName() + "." + DatabaseVendorMapping.toInternal((String)diag.dbSystem).substring(0, 3);
                            this.createDdlFile(eclipseProject, dbTable, name, DatabaseVendorMapping.toInternal((String)diag.dbSystem));
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void createDdlFile(IProject eclipseProject, DtDbTable dbTable, String fname, String dbSystem) {
        DtDbTableExpanded tableExpanded = new DtDbTableExpanded((DtStructure)dbTable);
        IFolder genFolder = eclipseProject.getFolder("src/scripts");
        if (!genFolder.exists()) {
            try {
                genFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ProjectBrowserPlugin.tracer.error("create src/scripts folder", (Throwable)e);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)e.getMessage());
                return;
            }
        }
        IFile file = genFolder.getFile(fname);
        try {
            File newFile = new File(file.getLocation().toString());
            if (newFile.createNewFile()) {
                file.create((InputStream)new FileInputStream(newFile), true, null);
            }
            PrintWriter pwriter = new PrintWriter(new FileWriter(newFile));
            tableExpanded.getCreateStatement(dbSystem, pwriter);
            file.refreshLocal(2, null);
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("create ddl file", (Throwable)e);
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)("Could not create ddl file for db system " + dbSystem + ". " + e.getMessage()));
        }
    }

    private class DbSelectDialog
    extends Dialog {
        private String tablename = null;
        private Combo combo = null;
        public int selectedIndex = -1;
        public String dbSystem = "";

        public DbSelectDialog(Shell parentShell, String tablename) {
            super(parentShell);
            this.tablename = tablename;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Create DDL Script");
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(784));
            layout.numColumns = 2;
            new Label(composite, 0).setText("Select DB System:");
            this.combo = new Combo(composite, 4);
            this.combo.add("all                                            ");
            String[] vendorNames = DatabaseVendorMapping.getVendorTitles();
            int i = 0;
            while (i < vendorNames.length) {
                this.combo.add(vendorNames[i]);
                ++i;
            }
            new Label(composite, 0).setText("File name:");
            Text fname = new Text(composite, 2050);
            GridData gridData = new GridData(768);
            fname.setLayoutData((Object)gridData);
            fname.setEditable(false);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, fname){
                private final /* synthetic */ Text val$fname;
                private final /* synthetic */ DbSelectDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$fname = val$fname;
                }

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    String name = "";
                    this.this$1.selectedIndex = DbSelectDialog.access$000(this.this$1).getSelectionIndex();
                    this.this$1.dbSystem = DbSelectDialog.access$000(this.this$1).getItem(this.this$1.selectedIndex);
                    name = DbSelectDialog.access$000(this.this$1).getSelectionIndex() == 0 ? DbSelectDialog.access$100(this.this$1) + ".<db-system>" : DbSelectDialog.access$100(this.this$1) + "." + DatabaseVendorMapping.toInternal((String)this.this$1.dbSystem).substring(0, 3);
                    this.val$fname.setText(name);
                }
            });
            return composite;
        }

        static /* synthetic */ Combo access$000(DbSelectDialog x0) {
            return x0.combo;
        }

        static /* synthetic */ String access$100(DbSelectDialog x0) {
            return x0.tablename;
        }
    }
}

