/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.clipboard.MetamodelClipboard;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PBCopyAction
implements IElementMultiAction {
    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DDIC_COPY);
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainProjectCategory(), (String)"ddic:Copy", (String)"Copy", (String)"Copy", (Image)image);
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                Entity entity = (Entity)elements[i];
                String metaClass = entity.getPropertyValue("$metaclass");
                boolean enable = false;
                if (metaClass != null) {
                    boolean bl = enable = metaClass.equals("DDDbTable") || metaClass.equals("DDSimpleType") || metaClass.equals("DDStructure") || metaClass.equals("DDDbView");
                }
                if (!enable) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof Entity) {
                DtDataType dt;
                String projectName = elements[i].getModel().getUniqueName().getName();
                DevelopmentObject devObj = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(elements[i].getUniqueName());
                if (elements[i].getUniqueName().getSubDomain() == "DbTable" || elements[i].getUniqueName().getSubDomain() == "DbView") {
                    String predAct = null;
                    if (devObj instanceof DtDbTable) {
                        predAct = ((DtDbTable)devObj).getPredefinedAction();
                    }
                    if (devObj instanceof DtDbView) {
                        predAct = ((DtDbView)devObj).getPredefinedAction();
                    }
                    if (predAct != null && predAct.equals("DROP")) {
                        return false;
                    }
                }
                if (devObj instanceof DtDataType && (dt = (DtDataType)devObj).hasLogicalDictionary()) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        Vector<DevelopmentObject> objects = new Vector<DevelopmentObject>();
        String name = elements[0].getModel().getUniqueName().getName();
        int i = 0;
        while (i < elements.length) {
            DtDataType dt;
            DevelopmentObject developmentObject;
            IProject eclipseProject;
            String projectName = elements[i].getModel().getUniqueName().getName();
            if (!projectName.equals(name)) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Copy not possible", (String)"Copy only works if objects of only one project are selected.");
                return;
            }
            if (projectName != null && projectName.length() > 0 && (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && elements[i] instanceof Entity && (!((developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(elements[i].getUniqueName())) instanceof DtDataType) || !(dt = (DtDataType)developmentObject).hasLogicalDictionary() || dt.getLogicalDictionary().equals("Local Dictionary"))) {
                objects.add(developmentObject);
            }
            ++i;
        }
        DevelopmentObject[] mdos = objects.toArray(new DevelopmentObject[0]);
        if (mdos.length > 0) {
            Metamodel metamodel = MetamodelManager.getMetamodel((String)name);
            MetamodelClipboard clipboard = Metamodel.getClipboard();
            clipboard.copy(mdos);
        }
    }
}

