/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.projectbrowser.services.ServicesProjectBrowser;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.core.plugin.DtrHelper;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.MetamodelImage;
import com.sap.ide.metamodel.dictionary.repository.MMRepositoryObjectProvider;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementMultiAction;
import com.tssap.selena.model.extension.util.SelenaElementUtil;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.graphics.Image;

public class PBCheckoutAction
implements IElementMultiAction {
    private final String NAME = "Checkout";
    private final String INFO = "Checkout";
    private final String DESCRIPTION = "Checkout";
    private final Image IMAGE = SapIdeUtilImages.getSapImage((ISapImage)MetamodelImage.ICON_CHECKOUT_FROM_DTR);
    private final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Checkout", (String)"Checkout", (String)"Checkout", (Image)this.IMAGE);

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isAvailable(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        IProject theProject = null;
        int i = 0;
        while (i < elements.length) {
            Element element = elements[i];
            UniqueName modelUIN = element.getModel().getUniqueName();
            if (SelenaElementUtil.isProjectModelUniqueName((UniqueName)modelUIN)) {
                String projectName = modelUIN.getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null) {
                    return false;
                }
                if (!DtrHelper.isUserLoggedOn((IProject)project)) {
                    return false;
                }
                if (!DtrHelper.isProjectUnderSourceControl((IProject)project)) {
                    return false;
                }
                if (theProject == null) {
                    theProject = project;
                } else if (theProject != project) {
                    return false;
                }
                if (!(element.getUniqueName().getSubDomain().equals("SimpleType") || element.getUniqueName().getSubDomain().equals("Structure") || element.getUniqueName().getSubDomain().equals("Dictionary"))) {
                    return false;
                }
            }
            ++i;
        }
        return ServicesProjectBrowser.elementsBelongToValidProject(elements);
    }

    public boolean isEnabled(Element[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        MMRepositoryObjectList repositoryObjectList = this.getRepositoryObjects(elements);
        boolean enabled = RepositoryServices.containsReadonlyFiles((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
        return enabled;
    }

    public void run(Element[] elements) {
        if (elements == null) {
            return;
        }
        MMRepositoryObjectList repositoryObjectList = this.getRepositoryObjects(elements);
        RepositoryServices.checkout((MMRepositoryObject[])repositoryObjectList.getRepositoryObjects());
    }

    private MMRepositoryObjectList getRepositoryObjects(Element[] elements) {
        MMRepositoryObjectList repositoryObjectList = new MMRepositoryObjectList();
        int i = 0;
        while (i < elements.length) {
            MainDevelopmentObject mdo;
            String projectName;
            DataSourceManager dataSourceManager;
            Entity entity;
            if (elements[i] instanceof Entity && !(entity = (Entity)elements[i]).getUniqueName().getName().equals("Local Dictionary") && (dataSourceManager = DataSourceManager.getDataSourceManager((String)(projectName = entity.getModel().getUniqueName().getName()))) != null && (mdo = (MainDevelopmentObject)dataSourceManager.getDevelopmentObject(entity.getUniqueName())) != null) {
                MMRepositoryObject repositoryObject = MMRepositoryObjectProvider.getInstance().getRepositoryObject(mdo, false);
                repositoryObjectList.addRepositoryObject(repositoryObject);
            }
            ++i;
        }
        return repositoryObjectList;
    }
}

