/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.generation.eclipse.GenerationAction;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;

public class PBBuiltAction
implements IElementSingleAction {
    private String text = "";

    public PBBuiltAction() {
    }

    public PBBuiltAction(String text) {
        this.text = text;
    }

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_BUILD_ALL);
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainBuildCategory(), (String)"ddic:Rebuild Project", (String)"Rebuild Project", (String)"Rebuild Project", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            String projectName = element.getModel().getUniqueName().getName();
            IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IProjectNature nature = null;
            try {
                nature = eclipseProject.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                if (nature != null) {
                    return false;
                }
            }
            catch (CoreException e) {
                ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
            }
            boolean enable = false;
            UniqueName uniqueName = element.getUniqueName();
            if (uniqueName.getDomain().equals("model") && uniqueName.getSubDomain().equals("project")) {
                enable = true;
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        return element instanceof Entity;
    }

    public void run(Element element) {
        IProject eclipseProject;
        if (element == null) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName != null && projectName.length() > 0 && (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && element instanceof Entity) {
            GenerationAction generationAction = new GenerationAction(eclipseProject, false);
            generationAction.run((IAction)null);
        }
    }
}

