/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.archivebuilder.PopupBuild;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.metamodel.core.actions.contextmenu.ActionCategories;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;

public class PBBuildSDAAction
implements IElementSingleAction {
    private PopupBuild mBuild = new PopupBuild();

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_PAR);
        return Category.createDisplayableCategory((ICategory)ActionCategories.getMainBuildCategory(), (String)"ddic:Create Archive", (String)"Create Archive", (String)"Create Archive", (Image)image);
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            UniqueName uniqueName = element.getUniqueName();
            String projectName = element.getModel().getUniqueName().getName();
            IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IProjectNature nature = null;
            try {
                nature = eclipseProject.getNature("com.sap.ide.webdynpro.archivebuilder.WebDynproNature");
                if (nature != null) {
                    return false;
                }
            }
            catch (CoreException e) {
                ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
            }
            return uniqueName.getDomain().equals("model") && uniqueName.getSubDomain().equals("project");
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        return element instanceof Entity;
    }

    public void run(Element element) {
        IProject eclipseProject;
        if (element == null) {
            return;
        }
        String projectName = element.getModel().getUniqueName().getName();
        if (projectName != null && projectName.length() > 0 && (eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && element instanceof Entity) {
            this.mBuild.setSelectedElement(element);
            this.mBuild.run((IAction)null);
        }
    }
}

