/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.projectbrowser.actions.PBBaseAction;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.sap.ide.eclipse.component.dcmetadata.model.IPPModel;
import com.sap.ide.eclipse.component.dcmetadata.model.PublicPartFileOutputProvider;
import com.sap.ide.eclipse.component.provider.actions.dcmetadata.ModifyPublicPartAction;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.tc.complib.ComponentFactory;
import com.sap.tc.complib.provider.PPOutputProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PBAddToPublicPartAction
extends ModifyPublicPartAction {
    private Element mElement = null;

    public ICategory getCategory() {
        Image image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_REFRESH);
        if (this.mElement != null) {
            if (this.mElement.getUniqueName().getSubDomain().equals("DbTable")) {
                image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_OUTLINE_UITABLE);
            } else if (this.mElement.getUniqueName().getSubDomain().equals("SimpleType")) {
                image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_SIMPLETYPE);
            } else if (this.mElement.getUniqueName().getSubDomain().equals("Structure")) {
                image = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_STRUCTURE);
            }
        }
        return Category.createDisplayableCategory((ICategory)PBBaseAction.getMainDefaultCategory(), (String)"ddic:Add to Public Part", (String)"Add to Public Part", (String)"Add to Public Part", (Image)image);
    }

    public IProject getDCProject(Element element) {
        String projectName = element.getModel().getUniqueName().getName();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject eclipseProject = workspaceRoot.getProject(projectName);
        return eclipseProject;
    }

    public boolean isAvailable(Element element) {
        if (element == null) {
            return false;
        }
        this.mElement = element;
        if (element instanceof Entity) {
            DtDataType st;
            String projectName = element.getModel().getUniqueName().getName();
            IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                if (!eclipseProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                    return false;
                }
            }
            catch (CoreException e) {
                ProjectBrowserPlugin.tracer.error("get nature", (Throwable)e);
            }
            String metaClass = element.getPropertyValue("$metaclass");
            boolean enable = false;
            if (metaClass != null) {
                enable = metaClass.equals("DDDbTable") || metaClass.equals("DDSimpleType") || metaClass.equals("DDStructure");
            }
            projectName = element.getModel().getUniqueName().getName();
            if (element.getUniqueName().getName().equals("Local Dictionary")) {
                return false;
            }
            DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(element.getUniqueName());
            if (developmentObject instanceof DtDataType && (st = (DtDataType)developmentObject).hasLogicalDictionary() && !st.getLogicalDictionary().getName().equals("Local Dictionary")) {
                enable = false;
            }
            return enable;
        }
        return false;
    }

    public boolean isEnabled(Element element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Entity) {
            String predefAction;
            String projectName;
            DtDbTable dtDbTable;
            return element.getUniqueName().getSubDomain() != "DbTable" || (dtDbTable = (DtDbTable)DataSourceManager.getDataSourceManager((String)(projectName = element.getModel().getUniqueName().getName())).getDevelopmentObject(element.getUniqueName())) == null || (predefAction = dtDbTable.getPredefinedAction()) == null || !predefAction.equals("DROP");
        }
        return false;
    }

    public void run(Element element) {
        String objectName = "";
        String objectPackage = "";
        String projectName = element.getModel().getUniqueName().getName();
        DataSourceManager manager = DataSourceManager.getDataSourceManager((String)projectName);
        DevelopmentObject developmentObject = manager.getDevelopmentObject(element.getUniqueName());
        if (developmentObject == null) {
            return;
        }
        IProject eclipseProject = this.getDCProject(element);
        if (eclipseProject == null) {
            return;
        }
        IPPModel ppModel = this.getPPModel(eclipseProject, null);
        if (ppModel == null) {
            return;
        }
        com.sap.tc.complib.Entity entity = ComponentFactory.createEntity();
        objectName = developmentObject.getName();
        if (developmentObject.isMDO()) {
            objectPackage = ((MainDevelopmentObject)developmentObject).getPackage();
            objectPackage = objectPackage.replace('.', '/');
        }
        IPPModel.EntityType entityType = null;
        if (developmentObject instanceof DtDbTable) {
            entityType = IPPModel.EntityType.DICTIONARY_DATABASE_TABLE;
        } else if (developmentObject instanceof DtSimpleType) {
            entityType = IPPModel.EntityType.DICTIONARY_SIMPLE_TYPE;
        } else if (developmentObject instanceof DtGeneralStructure) {
            entityType = IPPModel.EntityType.DICTIONARY_STRUCTURE;
        }
        String type = entityType.toString();
        if (entityType.getSubTyps().length <= 0) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"No subtype found");
            return;
        }
        String subType = entityType.getSubTyps()[0].toString();
        entity.setName(objectName);
        entity.setCaption(objectName);
        entity.setDescription(objectName);
        entity.setPackageName(objectPackage);
        entity.setType(type);
        entity.setSubType(subType);
        ppModel.addEntity(entity);
        IFile thePPFile = this.getPPFile(eclipseProject, ppModel);
        PublicPartFileOutputProvider outPutProvider = new PublicPartFileOutputProvider(thePPFile);
        try {
            ppModel.writeModelTo((PPOutputProvider)outPutProvider);
        }
        catch (Exception e) {
            ProjectBrowserPlugin.tracer.error("write to model", (Throwable)e);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Could not write to public part model");
        }
        MetamodelManager mmManager = MetamodelManager.getMetamodelManager((String)eclipseProject.getName());
        mmManager.refreshTSModel();
    }
}

