/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.archivebuilder.DictionaryProjectWizard;
import com.sap.dictionary.tools.archivebuilder.project.DictionaryNatureAction;
import com.sap.dictionary.tools.ui.image.DictionaryImage;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.graphics.Image;

public class PBAddDictionaryNatureAction
implements IElementSingleAction {
    private String text = "";
    private final String DISPLAY_NAME = "Add Dictionary Nature";
    private final String DISPLAY_INFO = "Add Dictionary Nature";
    private final Image DISPLAY_IMAGE = SapIdeUtilImages.getSapImage((ISapImage)DictionaryImage.ICON_DICTIONARY);
    private final String DESCRIPTION = "Add Dictionary Nature to a Project";
    private final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)Category.DEFAULT, (String)"Add Dictionary Nature to a Project", (String)"Add Dictionary Nature", (String)"Add Dictionary Nature", (Image)this.DISPLAY_IMAGE);

    protected PBAddDictionaryNatureAction() {
    }

    public PBAddDictionaryNatureAction(String text) {
        this.text = text;
    }

    public ICategory getCategory() {
        return this.CATEGORY;
    }

    public boolean isAvailable(Element element) {
        Entity entity;
        String metaClass;
        return element != null && element instanceof Entity && (metaClass = (entity = (Entity)element).getPropertyValue("$metaclass")) != null && metaClass.equals("Model");
    }

    public boolean isEnabled(Element element) {
        return element instanceof Entity && element != null;
    }

    public void run(Element element) {
        if (element instanceof Entity && element != null) {
            IProject eclipseProject = null;
            String projectName = element.getModel().getUniqueName().getName();
            if (projectName != null && projectName.length() > 0) {
                eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                try {
                    if (!eclipseProject.hasNature("org.eclipse.jdt.core.javanature")) {
                        // empty if block
                    }
                    IJavaProject proj = JavaCore.create((IProject)eclipseProject);
                    DictionaryProjectWizard.addSourcePaths((IJavaProject)proj, (boolean)true);
                }
                catch (CoreException e) {
                    ProjectBrowserPlugin.tracer.error("add source paths", (Throwable)e);
                }
            }
            DictionaryNatureAction dictionaryNatureAction = new DictionaryNatureAction(eclipseProject);
            dictionaryNatureAction.run();
        }
    }
}

