/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.projectbrowser.actions;

import com.sap.dictionary.projectbrowser.ProjectBrowserPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.MetamodelIterator;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.tssap.dii.dtri.DtriActionsControlMap;
import com.tssap.dii.dtri.DtriCheckedObjects;
import com.tssap.dii.dtri.DtriRelevantObjects;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DtrPropertyProvider
implements ObjectPropertyProvider {
    Map element_ret_map = new HashMap();
    Map element_ret_enum_map = new HashMap();
    long lastTime = System.currentTimeMillis();

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        long time;
        Object ret = this.element_ret_map.get(element);
        if (ret != null && (time = System.currentTimeMillis()) - this.lastTime < 5000L) {
            this.lastTime = time;
            return ret;
        }
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            if (element.getUniqueName().getSubDomain().equals("Dictionary")) {
                String projectName = element.getModel().getUniqueName().getName();
                String logicalDdicName = element.getUniqueName().getLocation();
                if (!logicalDdicName.equals("Local Dictionary")) {
                    DtLogicalDictionary mdo = null;
                    try {
                        DtLogicalDictionary[] lodd = DataSourceManager.getDataSourceManager((String)projectName).getDictionaryRoot().getLogicalDictionaries();
                        int i = 0;
                        while (i < lodd.length) {
                            if (lodd[i].getName().equals(logicalDdicName)) {
                                mdo = lodd[i];
                                break;
                            }
                            ++i;
                        }
                        if (mdo != null) {
                            ArrayList dtrList = new ArrayList();
                            this.fillDtrList((MainDevelopmentObject)mdo, dtrList);
                            DtriCheckedObjects dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(dtrList);
                            if (dtrCheckedObjects.hasDtrRelevantObjects()) {
                                ret = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
                            }
                        }
                    }
                    catch (LoadException e) {
                        ProjectBrowserPlugin.tracer.error("get logical dictionary", (Throwable)e);
                    }
                }
            } else {
                String projectName = element.getModel().getUniqueName().getName();
                MainDevelopmentObject mdo = (MainDevelopmentObject)DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(element.getUniqueName());
                ArrayList dtrList = new ArrayList();
                if (mdo != null) {
                    this.fillDtrList(mdo, dtrList);
                    DtriCheckedObjects dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(dtrList);
                    if (mdo instanceof DtDbTable || mdo instanceof DtDbIndex || mdo instanceof DtSimpleType || mdo instanceof DtGeneralStructure) {
                        DtriActionsControlMap map = new DtriActionsControlMap(-1);
                        map.addActionControl("ACTION__FILE_CHECKOUT_AND_DELETE");
                        ret = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList(), map);
                    } else if (dtrCheckedObjects.hasDtrRelevantObjects()) {
                        ret = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
                    }
                }
            }
        }
        this.element_ret_map.put(element, ret);
        this.lastTime = System.currentTimeMillis();
        return ret;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        boolean ret = false;
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            ret = true;
        }
        return ret;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        long time;
        Object ret = this.element_ret_enum_map.get(element);
        if (ret != null && (time = System.currentTimeMillis()) - this.lastTime < 5000L) {
            this.lastTime = time;
            return (Enumeration)ret;
        }
        Vector coll = new Vector();
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            String projectName = element.getModel().getUniqueName().getName();
            MainDevelopmentObject mdo = (MainDevelopmentObject)DataSourceManager.getDataSourceManager((String)projectName).getDevelopmentObject(element.getUniqueName());
            ArrayList dtrList = new ArrayList();
            if (mdo != null) {
                this.fillDtrList(mdo, dtrList);
                DtriCheckedObjects dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(dtrList);
                if (dtrCheckedObjects.hasDtrRelevantObjects()) {
                    ret = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
                }
            }
        }
        if ((ret = Collections.enumeration(coll)) != null) {
            this.element_ret_enum_map.put(element, ret);
        }
        this.lastTime = System.currentTimeMillis();
        return (Enumeration)ret;
    }

    private void fillDtrList(MainDevelopmentObject mdo, List dtrList) {
        TextPool textPool;
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        MetamodelIterator mdoIterator = mdo.iterator();
        Object devObject = null;
        Object mainDevObject = null;
        IFile mdoFile = null;
        String masterLanguage = mdo.getMasterLanguage();
        mdoFile = myWorkspaceRoot.getFileForLocation((IPath)new Path(mdo.getAbsolutePath()));
        if (mdoFile.exists()) {
            dtrList.add(mdoFile);
        }
        if ((textPool = mdo.getTextPool()) != null) {
            IFile textfile = myWorkspaceRoot.getFileForLocation((IPath)new Path(textPool.getAbsolutePath(masterLanguage)));
            if (textfile.exists()) {
                dtrList.add(textfile);
            }
            if ((textfile = myWorkspaceRoot.getFileForLocation((IPath)new Path(textPool.getAbsolutePath("")))).exists()) {
                dtrList.add(textfile);
            }
        }
    }
}

