/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.nameMapping.MessageId;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdQName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RpcTypeMapping
implements JavaTypes {
    private final String name;
    private final RpcTypeMapping parent;
    private final String type;
    private static final Map types = new HashMap();
    private static final Logger LOG = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$JavaTypes == null ? (class$com$sap$aii$proxy$generation$core$JavaTypes = RpcTypeMapping.class$("com.sap.aii.proxy.generation.core.JavaTypes")) : class$com$sap$aii$proxy$generation$core$JavaTypes).getName());
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$JavaTypes;

    private static void add(RpcTypeMapping type) {
        types.put(type.getName(), type);
    }

    private RpcTypeMapping(String name, RpcTypeMapping parent, String type) {
        this.name = name;
        this.parent = parent;
        this.type = type;
    }

    private String getName() {
        return this.name;
    }

    String getType() {
        if (this.type != null) {
            return this.type;
        }
        return this.parent.getType();
    }

    static String getType(XsdQName name) throws ProxyGenerationException {
        return RpcTypeMapping.getType(name.getLocalName());
    }

    private static String getType(String name) throws ProxyGenerationException {
        return RpcTypeMapping.getNode(name).getType();
    }

    static String getType(XsdQName[] names) throws ProxyGenerationException {
        if (names.length == 1) {
            return RpcTypeMapping.getType(names[0]);
        }
        List[] parents = new List[names.length];
        int i = 0;
        while (i < names.length) {
            RpcTypeMapping node = RpcTypeMapping.getNode(names[i]);
            parents[i] = node.getParents();
            node.printParents();
            ++i;
        }
        String res = null;
        boolean contains = false;
        int j = parents[0].size() - 1;
        while (!contains && j >= 0) {
            res = (String)parents[0].get(j);
            LOG.info(res);
            contains = true;
            int i2 = 1;
            while (contains && i2 < parents.length) {
                contains = parents[i2].contains(res);
                LOG.info(j + "  " + i2 + "  " + contains);
                ++i2;
            }
            --j;
        }
        return RpcTypeMapping.getType(res);
    }

    private static RpcTypeMapping getNode(XsdQName name) throws ProxyGenerationException {
        return RpcTypeMapping.getNode(name.getLocalName());
    }

    private static RpcTypeMapping getNode(String name) throws ProxyGenerationException {
        RpcTypeMapping node = (RpcTypeMapping)types.get(name);
        if (node == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.UNKNOWN_XSD_TYPE, new Object[]{name});
        }
        return node;
    }

    private void printParents() {
        List p = this.getParents();
        int i = 0;
        while (i < p.size()) {
            if (i != 0) {
                System.out.print(", ");
            } else {
                System.out.print("(");
            }
            System.out.print(p.get(i));
            ++i;
        }
        System.out.println(")");
    }

    private List getParents() {
        List list = this.parent == null ? new ArrayList() : this.parent.getParents();
        list.add(this.getName());
        return list;
    }

    public static void main(String[] args) throws ProxyGenerationException {
        Set keys = types.keySet();
        String[] names = keys.toArray(new String[0]);
        int i = 0;
        while (i < names.length) {
            System.out.print(names[i] + " = " + RpcTypeMapping.getType(new XsdQName(names[i], "x")) + " parents ");
            RpcTypeMapping.getNode(new XsdQName(names[i], "x")).printParents();
            ++i;
        }
        System.out.println("***********************");
        System.out.println(RpcTypeMapping.getType(new XsdQName[]{new XsdQName("date", "x"), new XsdQName("string", "x")}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RpcTypeMapping simpleAnyType = new RpcTypeMapping("simpleAnyType", null, "java.lang.String");
        RpcTypeMapping.add(simpleAnyType);
        RpcTypeMapping string = new RpcTypeMapping("string", simpleAnyType, null);
        RpcTypeMapping.add(string);
        RpcTypeMapping nString = new RpcTypeMapping("normalizedString", string, null);
        RpcTypeMapping.add(nString);
        RpcTypeMapping token = new RpcTypeMapping("token", nString, null);
        RpcTypeMapping.add(token);
        RpcTypeMapping lang = new RpcTypeMapping("language", token, null);
        RpcTypeMapping.add(lang);
        RpcTypeMapping name = new RpcTypeMapping("Name", token, null);
        RpcTypeMapping.add(name);
        RpcTypeMapping ncName = new RpcTypeMapping("NCName", name, null);
        RpcTypeMapping.add(ncName);
        RpcTypeMapping id = new RpcTypeMapping("ID", ncName, null);
        RpcTypeMapping.add(id);
        RpcTypeMapping idRef = new RpcTypeMapping("IDREF", ncName, null);
        RpcTypeMapping.add(idRef);
        RpcTypeMapping entity = new RpcTypeMapping("ENTITY", ncName, null);
        RpcTypeMapping.add(entity);
        RpcTypeMapping nmToken = new RpcTypeMapping("NMTOKEN", token, null);
        RpcTypeMapping.add(nmToken);
        RpcTypeMapping bool = new RpcTypeMapping("boolean", simpleAnyType, "boolean");
        RpcTypeMapping.add(bool);
        RpcTypeMapping base64 = new RpcTypeMapping("base64Binary", simpleAnyType, "byte[]");
        RpcTypeMapping.add(base64);
        RpcTypeMapping hex = new RpcTypeMapping("hexBinary", simpleAnyType, "byte[]");
        RpcTypeMapping.add(hex);
        RpcTypeMapping floatT = new RpcTypeMapping("float", simpleAnyType, "float");
        RpcTypeMapping.add(floatT);
        RpcTypeMapping decimal = new RpcTypeMapping("decimal", simpleAnyType, "java.math.BigDecimal");
        RpcTypeMapping.add(decimal);
        RpcTypeMapping integer = new RpcTypeMapping("integer", decimal, "java.math.BigInteger");
        RpcTypeMapping.add(integer);
        RpcTypeMapping nonPosInteger = new RpcTypeMapping("nonPositiveInteger", integer, null);
        RpcTypeMapping.add(nonPosInteger);
        RpcTypeMapping negInteger = new RpcTypeMapping("negativeInteger", nonPosInteger, null);
        RpcTypeMapping.add(negInteger);
        RpcTypeMapping longT = new RpcTypeMapping("long", integer, "long");
        RpcTypeMapping.add(longT);
        RpcTypeMapping intT = new RpcTypeMapping("int", longT, "int");
        RpcTypeMapping.add(intT);
        RpcTypeMapping shortT = new RpcTypeMapping("short", intT, "short");
        RpcTypeMapping.add(shortT);
        RpcTypeMapping byteT = new RpcTypeMapping("byte", shortT, "byte");
        RpcTypeMapping.add(byteT);
        RpcTypeMapping nonNegInteger = new RpcTypeMapping("nonNegativeInteger", integer, null);
        RpcTypeMapping.add(nonNegInteger);
        RpcTypeMapping posInteger = new RpcTypeMapping("positiveInteger", nonNegInteger, null);
        RpcTypeMapping.add(posInteger);
        RpcTypeMapping unsignedLong = new RpcTypeMapping("unsignedLong", nonNegInteger, null);
        RpcTypeMapping.add(unsignedLong);
        RpcTypeMapping unsignedInt = new RpcTypeMapping("unsignedInt", unsignedLong, "long");
        RpcTypeMapping.add(unsignedInt);
        RpcTypeMapping unsignedShort = new RpcTypeMapping("unsignedShort", unsignedInt, "int");
        RpcTypeMapping.add(unsignedShort);
        RpcTypeMapping unsignedByte = new RpcTypeMapping("unsignedByte", unsignedShort, "short");
        RpcTypeMapping.add(unsignedByte);
        RpcTypeMapping doubleT = new RpcTypeMapping("double", simpleAnyType, "double");
        RpcTypeMapping.add(doubleT);
        RpcTypeMapping anyURI = new RpcTypeMapping("anyURI", simpleAnyType, null);
        RpcTypeMapping.add(anyURI);
        RpcTypeMapping qName = new RpcTypeMapping("QName", simpleAnyType, null);
        RpcTypeMapping.add(qName);
        RpcTypeMapping notation = new RpcTypeMapping("NOTATION", simpleAnyType, null);
        RpcTypeMapping.add(notation);
        RpcTypeMapping duration = new RpcTypeMapping("duration", simpleAnyType, null);
        RpcTypeMapping.add(duration);
        RpcTypeMapping dateTime = new RpcTypeMapping("dateTime", simpleAnyType, "java.util.Calendar");
        RpcTypeMapping.add(dateTime);
        RpcTypeMapping time = new RpcTypeMapping("time", simpleAnyType, "java.util.Calendar");
        RpcTypeMapping.add(time);
        RpcTypeMapping date = new RpcTypeMapping("date", simpleAnyType, "java.util.Calendar");
        RpcTypeMapping.add(date);
        RpcTypeMapping gMonth = new RpcTypeMapping("gMonth", simpleAnyType, null);
        RpcTypeMapping.add(gMonth);
        RpcTypeMapping gYear = new RpcTypeMapping("gYear", simpleAnyType, null);
        RpcTypeMapping.add(gYear);
        RpcTypeMapping gYearMonth = new RpcTypeMapping("gYearMonth", simpleAnyType, null);
        RpcTypeMapping.add(gYearMonth);
        RpcTypeMapping gMonthDay = new RpcTypeMapping("gMonthDay", simpleAnyType, null);
        RpcTypeMapping.add(gMonthDay);
        RpcTypeMapping gDay = new RpcTypeMapping("gDay", simpleAnyType, null);
        RpcTypeMapping.add(gDay);
        RpcTypeMapping idRefs = new RpcTypeMapping("IDREFS", idRef, "java.lang.String[]");
        RpcTypeMapping.add(idRefs);
        RpcTypeMapping entities = new RpcTypeMapping("ENTITIES", entity, "java.lang.String[]");
        RpcTypeMapping.add(entities);
        RpcTypeMapping nmTokens = new RpcTypeMapping("NMTOKENS", nmToken, "java.lang.String[]");
        RpcTypeMapping.add(nmTokens);
    }
}

