/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.proxy.generation.core.nameMapping.AbstractGlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.ElementTable;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMappingFactory;
import com.sap.aii.proxy.generation.core.nameMapping.LocalOperationMappingImpl;
import com.sap.aii.proxy.generation.core.nameMapping.NameMapping;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class RfcGlobalNameMapping
extends AbstractGlobalNameMapping
implements GlobalNameMapping,
JavaTypes,
Serializable {
    private static boolean NO_ENUM = false;
    private static final long serialVersionUID = -2547658472685L;
    private static final String RFC_NAMESPACE = "urn:sap-com:document:sap:rfc:functions";
    private static final String RFC_DATE = "date";
    private static final String RFC_TIME = "time";
    private static final String UNDER_SCORE = "_";
    private static final String T_MESSAGE = "Message";
    private static final String T_PORTTYPE = "PortType";
    private static final String T_ELEMENT = "Element";
    private static final String T_ATTRIBUTE = "Attribute";
    private static final String T_TYPE = "Type";
    private static final String T_GROUP = "Group";
    private static final String T_ATTRIBUTE_GROUP = "AttributeGroup";
    private static final String EXCEPTION = ".Exception";
    private static final String FAULT = ".Fault";
    private static int START = 0;
    private static int UPPER = 1;
    private static int LOWER = 2;
    private static int SEPERATOR = 3;
    String packageName = null;
    GlobalNameMapping.Parts parts = new GlobalNameMapping.Parts();

    RfcGlobalNameMapping(String packageName) {
        this.packageName = packageName;
    }

    private void add(XsdQName qname, int type, String suffix) {
        XsdQName name = new XsdQName(qname.getLocalName(), qname.getNamespaceUri());
        String namespace = name.getNamespaceUri();
        ElementTable kindTable = this.parts.get(type);
        if (!kindTable.containsKey(name.getLocalName())) {
            String typeName;
            String localName = name.getLocalName();
            if (type == 6 && localName.endsWith(EXCEPTION)) {
                localName = localName.substring(0, localName.length() - EXCEPTION.length()) + FAULT;
            }
            if (kindTable.containsJavaName(typeName = type == 7 ? RfcGlobalNameMapping.getPortTypeName(localName, suffix) : this.getClassName(localName, suffix))) {
                typeName = this.getUniqueName(kindTable, typeName);
            }
            ElementImpl el = new ElementImpl((GlobalNameMapping)this, typeName, this.getPackageName(name), name, type);
            if (type == 7) {
                el.setLocalMapping(new LocalOperationMappingImpl(this, el));
            }
            kindTable.put(name.getLocalName(), el);
        }
    }

    static String getPortTypeName(String name, String suffix) {
        StringBuffer javaName = new StringBuffer();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            javaName.append(Character.toUpperCase(name.charAt(0)));
        } else {
            javaName.append(UNDER_SCORE);
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                javaName.append(name.charAt(i));
            } else {
                javaName.append(UNDER_SCORE);
            }
            ++i;
        }
        return javaName.append(suffix).toString();
    }

    private ElementTable getTypes(String namespace) {
        return this.parts.types;
    }

    private String getUniqueName(ElementTable table, String name) {
        String javaName = this.getName(name);
        if (!table.containsJavaName(javaName)) {
            return javaName;
        }
        int i = 1;
        while (table.containsJavaName(javaName + i)) {
            ++i;
        }
        return javaName + i;
    }

    private String getClassName(String name, String suffix) {
        return RfcGlobalNameMapping.getJavaName(name, suffix, true);
    }

    static String getJavaName(String name, String suffix, boolean isClass) {
        int last = START;
        StringBuffer javaName = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char letter = name.charAt(i);
            if (last == START) {
                if (i == 0 && Character.isJavaIdentifierStart(letter) || i != 0 && Character.isJavaIdentifierPart(letter)) {
                    if (isClass) {
                        javaName.append(Character.toUpperCase(letter));
                    } else {
                        javaName.append(Character.toLowerCase(letter));
                    }
                    last = RfcGlobalNameMapping.getLastType(letter);
                } else {
                    javaName.append(UNDER_SCORE);
                    last = SEPERATOR;
                    last = START;
                }
            } else if (Character.isJavaIdentifierPart(letter)) {
                if (last == LOWER && Character.isUpperCase(letter) || last == SEPERATOR) {
                    javaName.append(Character.toUpperCase(letter));
                } else {
                    javaName.append(Character.toLowerCase(letter));
                }
                last = RfcGlobalNameMapping.getLastType(letter);
            } else {
                javaName.append(UNDER_SCORE);
                last = SEPERATOR;
            }
            ++i;
        }
        javaName.append(suffix);
        if (!isClass && AbstractGlobalNameMapping.isJavaKeyWord(javaName)) {
            return UNDER_SCORE + javaName.toString();
        }
        return javaName.toString();
    }

    private static int getLastType(char letter) {
        if (Character.isUpperCase(letter)) {
            return UPPER;
        }
        if (Character.isLowerCase(letter)) {
            return LOWER;
        }
        return SEPERATOR;
    }

    private String getName(String name) {
        StringBuffer javaName = new StringBuffer();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            javaName.append(name.charAt(0));
        } else {
            javaName.append(UNDER_SCORE);
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                javaName.append(name.charAt(i));
            } else {
                javaName.append(UNDER_SCORE);
            }
            ++i;
        }
        return javaName.toString();
    }

    public static final boolean isRfcTime(XsdQName name) {
        return RFC_NAMESPACE.equals(name.getNamespaceUri()) && RFC_TIME.equals(name.getLocalName());
    }

    public static final boolean isRfcDate(XsdQName name) {
        return RFC_NAMESPACE.equals(name.getNamespaceUri()) && RFC_DATE.equals(name.getLocalName());
    }

    ElementTable getKind(String namespace, int kind) throws ProxyGenerationException {
        return this.parts.get(kind);
    }

    public void addWsdl(Wsdl wsdl) {
        if (wsdl != null) {
            List portTypes = wsdl.getPortTypes();
            int i = 0;
            while (i < portTypes.size()) {
                this.add(((WsdlPortType)portTypes.get(i)).getQName(), 7, "");
                ++i;
            }
            List messages = wsdl.getMessages();
            int i2 = 0;
            while (i2 < messages.size()) {
                this.add(((WsdlMessage)messages.get(i2)).getQName(), 6, "");
                ++i2;
            }
            Collection types = wsdl.getTypes().values();
            Iterator i3 = types.iterator();
            while (i3.hasNext()) {
                XsdTypeDef type = (XsdTypeDef)i3.next();
                if (type instanceof XsdSimpleType) {
                    if (!NO_ENUM && !Wsdl.isEnumType((XsdSimpleType)type)) continue;
                    this.add(type.getQName(), 1, T_TYPE);
                    continue;
                }
                this.add(type.getQName(), 1, T_TYPE);
            }
            Collection elements = wsdl.getElements().values();
            Iterator i4 = elements.iterator();
            while (i4.hasNext()) {
                XsdElement elem = (XsdElement)i4.next();
                this.add(elem.getQName(), 2, T_ELEMENT);
                if (!ProxyHelper.hasLocalComplexType(elem)) continue;
                this.add(elem.getQName(), 1, "");
            }
        }
    }

    public final String getPackageName(XsdQName name) {
        return this.packageName;
    }

    final GlobalNameMapping.Parts getParts(String namespace) throws ProxyGenerationException {
        return this.parts;
    }

    final String getSpecialTypeName(XsdQName name) {
        if (RfcGlobalNameMapping.isRfcTime(name)) {
            return "java.sql.Time";
        }
        return "java.sql.Date";
    }

    final boolean isSpecialTypeName(XsdQName name) {
        return RfcGlobalNameMapping.isRfcTime(name) || RfcGlobalNameMapping.isRfcDate(name);
    }

    public class ElementImpl
    extends AbstractGlobalNameMapping.GlobalAbstractElement {
        ElementImpl(GlobalNameMapping globalNames, String typeName, String packageName, XsdQName wsdlName, int kind) {
            super(globalNames, typeName, packageName, wsdlName.toString(), kind);
        }

        public final String getTypeName() {
            return this.getJavaName();
        }

        protected final LocalNameMapping getNewLocalNamemapping(GlobalNameMapping globalNames, NameMapping.Element outerElement) {
            return LocalNameMappingFactory.getLocalNameMapping(globalNames, outerElement);
        }
    }
}

