/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import java.io.Serializable;

interface NameMapping {

    public static abstract class AbstractElement
    implements Element,
    Serializable {
        private static final long serialVersionUID = 1156194321948330063L;
        private String packageName;
        private String javaName;
        private String wsdlName;
        private int kind;
        private LocalNameMapping localMapping;

        AbstractElement(GlobalNameMapping globalNames, String typeName, String packageName, String wsdlName, int kind) {
            this.init(globalNames, typeName, packageName, wsdlName, kind);
        }

        final void setJavaName(String javaName) {
            this.javaName = javaName;
        }

        final void init(GlobalNameMapping globalMapping, String javaName, String packageName, String wsdlName, int kind) {
            this.javaName = javaName;
            this.packageName = packageName;
            this.wsdlName = wsdlName;
            this.kind = kind;
            this.localMapping = this.getNewLocalNamemapping(globalMapping, this);
        }

        abstract LocalNameMapping getNewLocalNamemapping(GlobalNameMapping var1, Element var2);

        abstract String getType();

        final int getKind() {
            return this.kind;
        }

        final String getWsdlName() {
            return this.wsdlName;
        }

        public String getFullName() {
            if (this.packageName == null || this.packageName.trim().equals("")) {
                return this.javaName;
            }
            return this.packageName + "." + this.javaName;
        }

        public final String getJavaName() {
            return this.javaName;
        }

        public final LocalNameMapping getLocalMapping() {
            return this.localMapping;
        }

        public final String getName() {
            return this.javaName;
        }

        public String getOuterPath(String name) {
            return this.getPath();
        }

        public String getPath() {
            return this.getType() + " " + this.getWsdlName();
        }

        public boolean isOuterClass(String name) {
            return name.equalsIgnoreCase(this.javaName);
        }

        public final void setLocalMapping(LocalNameMapping localMapping) {
            this.localMapping = localMapping;
        }

        public abstract String getTypeName();
    }

    public static interface Element {
        public String getFullName();

        public String getName();

        public boolean isOuterClass(String var1);

        public String getTypeName();

        public String getJavaName();

        public String getPath();

        public String getOuterPath(String var1);

        public LocalNameMapping getLocalMapping();

        public void setLocalMapping(LocalNameMapping var1);
    }
}

