/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlOperation;
import com.sap.aii.proxy.generation.core.WsdlParameter;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMappingImpl;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMappingImpl;
import com.sap.aii.proxy.generation.core.nameMapping.LocalOperationMapping;
import com.sap.aii.proxy.generation.core.nameMapping.MessageId;
import com.sap.aii.proxy.generation.core.nameMapping.NameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.ParameterMapping;
import com.sap.aii.proxy.generation.core.nameMapping.RfcGlobalNameMapping;
import com.sap.aii.util.xsd.api.XsdQName;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class LocalOperationMappingImpl
extends LocalNameMappingImpl
implements LocalOperationMapping,
Serializable {
    private static final long serialVersionUID = -2806444658374760275L;
    private static final String UNDER_SCORE = "_";
    public static final String DOT = ".";
    OperationsTable operations = new OperationsTable();
    MessageTable messages = new MessageTable();

    LocalOperationMappingImpl(GlobalNameMapping globalMapping, NameMapping.Element element) {
        super(globalMapping, element);
    }

    private String add(String name, OperationKey key, boolean isRfc) {
        if (this.operations.containsKey(key)) {
            return this.operations.getName(key);
        }
        String javaName = this.getJavaName(name, isRfc);
        this.operations.put(key, javaName);
        return javaName;
    }

    private String getJavaName(String name, boolean isRfc) {
        if (isRfc) {
            String javaName = RfcGlobalNameMapping.getJavaName(name, "", false);
            if (!this.operations.containsName(javaName)) {
                return javaName;
            }
            int i = 1;
            while (this.operations.containsName(javaName + i)) {
                ++i;
            }
            return javaName + i;
        }
        return GlobalNameMappingImpl.getMethodName(name);
    }

    public String addMessage(XsdQName name) {
        String javaName = this.getJavaName(name.getLocalName(), true);
        this.messages.put(name, javaName);
        return javaName;
    }

    public String addOperation(String name, XsdQName parameter, XsdQName returnParam, boolean isRfc) {
        OperationKey key = new OperationKey(name, parameter, returnParam);
        return this.add(name, key, isRfc);
    }

    public String addOperation(String name, XsdQName parameter, XsdQName returnParam, Wsdl wsdl) {
        OperationKey key = new OperationKey(name, parameter, returnParam);
        if (this.operations.containsKey(key)) {
            return this.operations.getName(key);
        }
        String javaName = this.getJavaName(name, false);
        ParameterMapping map = new ParameterMapping(javaName);
        this.messages.add(parameter);
        this.messages.add(returnParam);
        this.operations.put(key, javaName);
        return javaName;
    }

    public String addOperation(WsdlOperation operation) {
        OperationKey key = new OperationKey(operation);
        return this.add(operation.getName(), key, false);
    }

    public String getAbapOperationName(String name) throws ProxyGenerationException {
        return name.toUpperCase();
    }

    public XsdQName[] getAllMessages() {
        return this.messages.getAllKeys();
    }

    public String getFullMessageName(XsdQName name) throws ProxyGenerationException {
        return this.element.getFullName() + DOT + this.getLocalMessageName(name);
    }

    public String getLocalMessageName(XsdQName name) throws ProxyGenerationException {
        return this.messages.get(name);
    }

    public String getOperationName(String name, XsdQName parameter, XsdQName returnParam) throws ProxyGenerationException {
        String opName = this.operations.getName(new OperationKey(name, parameter, returnParam));
        if (opName == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_OPERATION, new Object[]{name});
        }
        return opName;
    }

    public ParameterMapping getParameterMapping(WsdlOperation operation) {
        OperationKey key = new OperationKey(operation);
        return this.operations.get(key);
    }

    private final class MessageTable {
        private Map names = new Hashtable();

        private MessageTable() {
        }

        private void add(XsdQName message) {
            if (message != null) {
                String javaName = GlobalNameMappingImpl.getClassName(message.getLocalName());
                if (this.containsName(javaName)) {
                    int i = 1;
                    while (this.containsName(javaName + i)) {
                        ++i;
                    }
                    javaName = javaName + i;
                }
                this.names.put(message, javaName);
            }
        }

        private void put(XsdQName message, String name) {
            this.names.put(message, name);
        }

        private boolean containsKey(XsdQName key) {
            return this.names.containsKey(key);
        }

        private String get(XsdQName key) {
            return (String)this.names.get(key);
        }

        private boolean containsName(String value) {
            Collection values = this.names.values();
            boolean contains = false;
            Iterator iter = values.iterator();
            while (iter.hasNext() && !contains) {
                String namespace = (String)iter.next();
                contains = namespace.equalsIgnoreCase(value);
            }
            return contains;
        }

        private XsdQName[] getAllKeys() {
            Set keys = this.names.keySet();
            XsdQName[] messages = new XsdQName[keys.size()];
            return keys.toArray(messages);
        }

        private XsdQName getKey(String value) {
            Set keys = this.names.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                XsdQName key = (XsdQName)iter.next();
                String currentValue = this.get(key);
                if (!currentValue.equalsIgnoreCase(value)) continue;
                return key;
            }
            return null;
        }
    }

    private final class OperationsTable {
        private Map operations = new Hashtable();

        private OperationsTable() {
        }

        private boolean containsKey(OperationKey key) {
            return this.operations.containsKey(key);
        }

        private boolean containsName(String name) {
            return this.operations.containsValue(name);
        }

        private void put(OperationKey key, String name) {
            this.operations.put(key, new ParameterMapping(name));
        }

        private ParameterMapping get(OperationKey key) {
            return (ParameterMapping)this.operations.get(key);
        }

        private String getName(OperationKey key) {
            return this.get(key).getName();
        }
    }

    private final class OperationKey
    implements Serializable {
        private static final long serialVersionUID = -7655509943621599762L;
        String name;
        private XsdQName parameter;
        private XsdQName returnParameter;

        OperationKey(String name, XsdQName parameter, XsdQName returnParameter) {
            this.init(name, parameter, returnParameter);
        }

        OperationKey(WsdlOperation operation) {
            WsdlParameter in = operation.getInput();
            XsdQName inputMessage = null;
            if (in != null) {
                inputMessage = in.getMessage();
            }
            WsdlParameter out = operation.getOutput();
            XsdQName outputMessage = null;
            if (out != null) {
                outputMessage = out.getMessage();
            }
            this.init(operation.getName(), inputMessage, outputMessage);
        }

        private void init(String name, XsdQName parameter, XsdQName returnParameter) {
            this.name = name;
            this.parameter = parameter;
            this.returnParameter = returnParameter;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof OperationKey) {
                OperationKey key = (OperationKey)o;
                if (this.compareString(key.name, this.name)) {
                    if (this.compareXsdQName(key.parameter, this.parameter)) {
                        return this.compareXsdQName(key.returnParameter, this.returnParameter);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        private boolean compareXsdQName(XsdQName s1, XsdQName s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null && s2 != null) {
                return false;
            }
            return s1.equals((Object)s2);
        }

        private boolean compareString(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return true;
            }
            if (s1 == null && s2 != null) {
                return false;
            }
            return s1.equals(s2);
        }
    }
}

