/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.nameMapping.ElementTable;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMappingImpl;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.MessageId;
import com.sap.aii.proxy.generation.core.nameMapping.NameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.RfcGlobalNameMapping;
import com.sap.aii.util.log.api.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public class LocalNameMappingImpl
implements LocalNameMapping,
Serializable {
    private static final long serialVersionUID = 5086764225461664902L;
    private static final Logger LOGGER = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$nameMapping$LocalNameMappingImpl == null ? (class$com$sap$aii$proxy$generation$core$nameMapping$LocalNameMappingImpl = LocalNameMappingImpl.class$("com.sap.aii.proxy.generation.core.nameMapping.LocalNameMappingImpl")) : class$com$sap$aii$proxy$generation$core$nameMapping$LocalNameMappingImpl).getName());
    final GlobalNameMapping globalMapping;
    NameMapping.Element element;
    ElementTable attributes = new ElementTable();
    ElementTable elements = new ElementTable();
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$nameMapping$LocalNameMappingImpl;

    LocalNameMappingImpl(GlobalNameMapping globalMapping, NameMapping.Element element) {
        this(globalMapping);
        this.element = element;
    }

    LocalNameMappingImpl(GlobalNameMapping globalMapping) {
        this.globalMapping = globalMapping;
    }

    private ElementTable getKind(int kind) {
        switch (kind) {
            case 1: {
                return this.attributes;
            }
            case 2: {
                return this.elements;
            }
        }
        return new ElementTable();
    }

    private ElementTable getOtherKind(int kind) {
        switch (kind) {
            case 1: {
                return this.elements;
            }
            case 2: {
                return this.attributes;
            }
        }
        return new ElementTable();
    }

    private String getFullName(String name, int kind) throws ProxyGenerationException {
        if (this.element == null) {
            throw LocalNameMappingImpl.getException(name, kind);
        }
        return this.element.getFullName() + "." + this.getLocalTypeName(name, kind);
    }

    private String getLocalName(String name, int kind) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(kind);
        NameMapping.Element element = kindTable.get(name);
        if (element == null) {
            throw LocalNameMappingImpl.getException(name, kind);
        }
        return element.getJavaName();
    }

    private String getLocalTypeName(String name, int kind) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(kind);
        NameMapping.Element element = kindTable.get(name);
        if (element == null) {
            throw LocalNameMappingImpl.getException(name, kind);
        }
        String typeName = element.getTypeName();
        if (this.isOuterClass(typeName)) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.LOCAL_TYPE_EQUALS_OUTER, new Object[]{"\n" + element.getOuterPath(typeName) + "\n", element.getPath() + "\n"});
        }
        return typeName;
    }

    private String add(String name, int kind, boolean isRfc) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(kind);
        if (kindTable.containsKey(name)) {
            NameMapping.Element elem = kindTable.get(name);
            LOGGER.warning("double element/attribute " + name + "  -> " + elem.getJavaName());
            return elem.getJavaName();
        }
        LocalNameMapping.ElementImpl element = new LocalNameMapping.ElementImpl(this.globalMapping, this.element, name, kind);
        String javaName = this.getName(name, isRfc);
        if (isRfc) {
            if (!kindTable.containsJavaName(javaName)) {
                element.setJavaName(javaName);
            } else {
                int i = 1;
                while (kindTable.containsJavaName(javaName + i)) {
                    ++i;
                }
                element.setJavaName(javaName + i);
            }
            String typeName = javaName + "Type";
            if (!kindTable.containsTypeName(typeName) && !this.isOuterClass(typeName)) {
                element.setTypeName(typeName);
            } else {
                int i = 1;
                while (kindTable.containsTypeName(typeName + i) || this.isOuterClass(typeName + i)) {
                    ++i;
                }
                element.setTypeName(typeName + i);
            }
            kindTable.put(name, element);
            return element.getJavaName();
        }
        String oldName = kindTable.getKeyToJavaName(javaName);
        if (oldName != null) {
            NameMapping.Element otherElem = kindTable.get(oldName);
            if (kind == 1) {
                throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_LOCAL_ATTRIBUTE, new Object[]{element.getPath(), otherElem.getPath()});
            }
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_LOCAL_ELEMENT, new Object[]{element.getPath(), otherElem.getPath()});
        }
        ElementTable other = this.getOtherKind(kind);
        oldName = other.getKeyToJavaName(javaName);
        if (oldName != null) {
            NameMapping.Element otherElem = other.get(oldName);
            if (kind == 2) {
                throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_LOCAL_ELEMENT_ATTRI, new Object[]{element.getPath(), otherElem.getPath()});
            }
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_LOCAL_ELEMENT_ATTRI, new Object[]{otherElem.getPath(), element.getPath()});
        }
        element.setJavaName(javaName);
        String typeName = GlobalNameMappingImpl.getClassName(name) + "_Type";
        element.setTypeName(typeName);
        kindTable.put(name, element);
        return javaName;
    }

    private LocalNameMapping getLocalMapping(String name, int kind) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(kind);
        NameMapping.Element element = kindTable.get(name);
        if (element == null) {
            throw LocalNameMappingImpl.getException(name, kind);
        }
        return element.getLocalMapping();
    }

    private boolean containsTypeName(Hashtable table, String value) {
        Collection values = table.values();
        boolean contains = false;
        Iterator iter = values.iterator();
        while (iter.hasNext() && !contains) {
            LocalNameMapping.ElementImpl element = (LocalNameMapping.ElementImpl)iter.next();
            contains = element.getTypeName().equalsIgnoreCase(value);
        }
        return contains;
    }

    private String getName(String name, boolean isRfc) {
        if (isRfc) {
            return this.proveClass(RfcGlobalNameMapping.getJavaName(name, "", true));
        }
        String javaName = GlobalNameMappingImpl.getAttributeName(name);
        return this.proveClass(javaName.toString());
    }

    private String proveClass(String name) {
        if (name.equals("Class") || name.equals("class")) {
            return "_" + name;
        }
        return name;
    }

    private String getPath() {
        return null;
    }

    private boolean isOuterClass(String name) {
        return this.element.isOuterClass(name);
    }

    private static ProxyGenerationException getException(String name, int kind) {
        if (kind == 2) {
            return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_LOCAL_ELEMENT, new Object[]{name});
        }
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_LOCAL_ATTRIBUTE, new Object[]{name});
    }

    public String addAttribute(String name, boolean isRfc) throws ProxyGenerationException {
        return this.add(name, 1, isRfc);
    }

    public String addElement(String name, boolean isRfc) throws ProxyGenerationException {
        return this.add(name, 2, isRfc);
    }

    public final String getAttributeName(String name) throws ProxyGenerationException {
        return this.getLocalName(name, 1);
    }

    public final String getElementName(String name) throws ProxyGenerationException {
        return this.getLocalName(name, 2);
    }

    public String getFullAttributeType(String name) throws ProxyGenerationException {
        return this.getFullName(name, 1);
    }

    public final String getFullElementType(String name) throws ProxyGenerationException {
        return this.getFullName(name, 2);
    }

    public final String getLocalAttributeType(String name) throws ProxyGenerationException {
        return this.getLocalTypeName(name, 1);
    }

    public final String getLocalElementTable(String name) throws ProxyGenerationException {
        return this.getLocalTypeName(name, 2) + "Table";
    }

    public final String getLocalElementType(String name) throws ProxyGenerationException {
        return this.getLocalTypeName(name, 2);
    }

    public LocalNameMapping getLocalMappingAttribute(String name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 1);
    }

    public LocalNameMapping getLocalMappingElement(String name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

