/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMappingFactory;
import com.sap.aii.proxy.generation.core.nameMapping.NameMapping;
import java.io.Serializable;

public interface LocalNameMapping
extends NameMapping {
    public static final String UNDER_SCORE = "_";
    public static final String DOT = ".";
    public static final String TYPE = "Type";
    public static final String TABLE = "Table";
    public static final int ATTRIBUTE = 1;
    public static final int ELEMENT = 2;

    public String getAttributeName(String var1) throws ProxyGenerationException;

    public String getElementName(String var1) throws ProxyGenerationException;

    public String getLocalElementType(String var1) throws ProxyGenerationException;

    public String getLocalAttributeType(String var1) throws ProxyGenerationException;

    public String getLocalElementTable(String var1) throws ProxyGenerationException;

    public String getFullElementType(String var1) throws ProxyGenerationException;

    public String getFullAttributeType(String var1) throws ProxyGenerationException;

    public LocalNameMapping getLocalMappingElement(String var1) throws ProxyGenerationException;

    public LocalNameMapping getLocalMappingAttribute(String var1) throws ProxyGenerationException;

    public String addElement(String var1, boolean var2) throws ProxyGenerationException;

    public String addAttribute(String var1, boolean var2) throws ProxyGenerationException;

    public static final class ElementImpl
    extends NameMapping.AbstractElement
    implements NameMapping.Element,
    Serializable {
        private static final long serialVersionUID = 7981784526925687834L;
        private String typeName = null;
        private NameMapping.Element outerElement;

        ElementImpl(GlobalNameMapping globalMapping, NameMapping.Element outerElement, String wsdlName, int kind) {
            super(globalMapping, null, null, wsdlName, kind);
            this.outerElement = outerElement;
        }

        final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getFullName() {
            return this.outerElement.getFullName() + LocalNameMapping.DOT + this.typeName;
        }

        protected final LocalNameMapping getNewLocalNamemapping(GlobalNameMapping globalNames, NameMapping.Element outerElement) {
            return LocalNameMappingFactory.getLocalNameMapping(globalNames, this);
        }

        public String getOuterPath(String name) {
            if (this.outerElement.getTypeName().equalsIgnoreCase(name)) {
                return this.outerElement.getPath();
            }
            return this.outerElement.getOuterPath(name);
        }

        public String getPath() {
            return this.outerElement.getPath() + this.getType() + this.getWsdlName();
        }

        String getType() {
            int kind = this.getKind();
            switch (kind) {
                case 1: {
                    return "<attribute>";
                }
                case 2: {
                    return "<element>";
                }
            }
            return "";
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final boolean isOuterClass(String name) {
            return this.getTypeName().equalsIgnoreCase(name) || this.outerElement.isOuterClass(name);
        }
    }
}

