/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlParameter;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.proxy.generation.core.nameMapping.AbstractGlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.ElementTable;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMappingFactory;
import com.sap.aii.proxy.generation.core.nameMapping.LocalOperationMappingImpl;
import com.sap.aii.proxy.generation.core.nameMapping.MessageId;
import com.sap.aii.proxy.generation.core.nameMapping.NameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.NameTable;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

final class GlobalNameMappingImpl
extends AbstractGlobalNameMapping
implements GlobalNameMapping,
JavaTypes,
Serializable {
    private static final boolean NO_ENUM = false;
    private static final long serialVersionUID = -2340432513622948951L;
    private static final String RFC_NAMESPACE = "urn:sap-com:document:sap:rfc:functions";
    private static final String RFC_DATE = "date";
    private static final String RFC_TIME = "time";
    private static final Set DOMAINS;
    private static final char DOT = '.';
    private static final char COLON = ':';
    private static final char ESCAPE_HTTP = '%';
    private static final String SLASH = "/";
    private static final String HTML = ".html";
    private static final String UNDER_SCORE = "_";
    private static final String ASCII = "ASCII";
    private static final String WWW = "www";
    private static final String HEX = "0x";
    private static final String T_PORTTYPE = "_PortType";
    private static final String T_ELEMENT = "_Element";
    private static final String T_ATTRIBUTE = "Attribute";
    private static final String T_GROUP = "Group";
    private static final String T_ATTRIBUTE_GROUP = "AttributeGroup";
    private static final String T_EXCEPTION = "_Exception";
    private static final String T_MESSAGE = "_Message";
    static final String T_TYPE = "_Type";
    private NameTable packageNames = new NameTable();
    private PartsTable packages = new PartsTable();

    GlobalNameMappingImpl() {
    }

    private void add(XsdQName name, int type, String suffix) throws ProxyGenerationException {
        String namespace = name.getNamespaceUri();
        if (!this.packageNames.containsKey(namespace)) {
            String packageName = this.getUniquePackageName(namespace, this.packageNames);
            this.packageNames.put(namespace, packageName);
            GlobalNameMapping.Parts types = new GlobalNameMapping.Parts();
            String typeName = GlobalNameMappingImpl.getClassName(GlobalNameMappingImpl.getWordList(name.getLocalName())) + suffix;
            ElementTable kind = types.get(type);
            ElementImpl el = new ElementImpl((GlobalNameMapping)this, typeName, packageName, name, type);
            if (type == 7) {
                el.setLocalMapping(new LocalOperationMappingImpl(this, el));
            }
            kind.put(name.getLocalName(), el);
            this.packages.put(packageName, types);
        } else {
            String locName;
            ElementTable kindTable = this.getKind(namespace, type);
            if (!kindTable.containsKey(locName = name.getLocalName())) {
                String typeName = GlobalNameMappingImpl.getClassName(GlobalNameMappingImpl.getWordList(locName)) + suffix;
                ElementImpl el = new ElementImpl((GlobalNameMapping)this, typeName, this.getPackageName(name), name, type);
                String oldName = kindTable.getKeyToJavaName(typeName);
                if (oldName != null) {
                    NameMapping.Element oldElement = kindTable.get(oldName);
                    throw this.getDoubleGlobalNameException(type, oldElement, el);
                }
                if (type == 7) {
                    el.setLocalMapping(new LocalOperationMappingImpl(this, el));
                }
                kindTable.put(name.getLocalName(), el);
            }
        }
    }

    private ProxyGenerationException getDoubleGlobalNameException(int type, NameMapping.Element old, NameMapping.Element newElem) {
        Object[] args = new Object[]{old.getPath(), newElem.getPath()};
        switch (type) {
            case 1: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_TYPE, args);
            }
            case 5: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_ATTRIBUTE_GR, args);
            }
            case 4: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_ATTRIBUTE, args);
            }
            case 2: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_ELEMENT, args);
            }
            case 3: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_GROUP, args);
            }
            case 6: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_MESSAGE, args);
            }
        }
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_GLOBAL_PORTTYPE, args);
    }

    private static List getWordListPackage(String uri) throws ProxyGenerationException {
        int index = uri.indexOf(58);
        if (index != -1) {
            uri = uri.substring(index + 1);
        }
        index = uri.lastIndexOf(46);
        int length = uri.length();
        if (index != -1 && (index == length - 4 || index == length - 3 || uri.endsWith(HTML))) {
            uri = uri.substring(0, index);
        }
        ArrayList<String> words = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(uri, SLASH, false);
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            word = GlobalNameMappingImpl.unEscape(word);
            if (i == 0 && GlobalNameMappingImpl.isDomain(word)) {
                List list = GlobalNameMappingImpl.reverse(word);
                int j = 0;
                while (j < list.size()) {
                    words.add(GlobalNameMappingImpl.getMethodName(GlobalNameMappingImpl.getWordList((String)list.get(j))));
                    ++j;
                }
            } else {
                words.add(GlobalNameMappingImpl.getMethodName(GlobalNameMappingImpl.getWordList(word)));
            }
            ++i;
        }
        return words;
    }

    private static String getPackageName(String name) throws ProxyGenerationException {
        return GlobalNameMappingImpl.getPackageName(GlobalNameMappingImpl.getWordListPackage(name), name);
    }

    private static boolean isDomain(String text) {
        int index = text.lastIndexOf(46);
        if (index != -1) {
            if (index == text.length() - 3) {
                return true;
            }
            String suffix = text.substring(index + 1);
            return DOMAINS.contains(suffix.toLowerCase());
        }
        return false;
    }

    private static String unEscape(String text) throws ProxyGenerationException {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char letter = text.charAt(i);
            if (letter == '%') {
                String hex = text.substring(i + 1, i + 3);
                letter = GlobalNameMappingImpl.getChar(hex);
                i += 2;
            }
            result.append(letter);
            ++i;
        }
        return result.toString();
    }

    private static char getChar(String hex) throws ProxyGenerationException {
        String sign = null;
        try {
            byte i = Byte.decode(HEX + hex);
            sign = new String(new byte[]{i}, ASCII);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Exception)e);
        }
        return sign.charAt(0);
    }

    private static List reverse(String text) {
        ArrayList<String> words = new ArrayList<String>();
        int start = text.lastIndexOf(46);
        int end = text.length();
        while (start != -1) {
            words.add(text.substring(start + 1, end));
            end = start;
            start = text.lastIndexOf(46, end - 1);
        }
        String word = text.substring(start + 1, end);
        if (!word.equalsIgnoreCase(WWW)) {
            words.add(word);
        }
        return words;
    }

    private String getUniquePackageName(String name, NameTable table) throws ProxyGenerationException {
        String javaName = GlobalNameMappingImpl.getPackageName(name);
        String key = table.getKey(javaName);
        if (key == null) {
            return javaName;
        }
        throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.DOUBLE_PACKAGEANAME, new Object[]{name, key, javaName});
    }

    static String getClassName(String name) {
        return GlobalNameMappingImpl.getClassName(GlobalNameMappingImpl.getWordList(name));
    }

    private static String getClassName(String[] words) {
        StringBuffer className = new StringBuffer();
        int i = 0;
        while (i < words.length) {
            className.append(words[i]);
            ++i;
        }
        className.setCharAt(0, Character.toUpperCase(className.charAt(0)));
        return className.toString();
    }

    private static String getConstantName(String[] words) {
        StringBuffer constantName = new StringBuffer();
        int i = 0;
        while (i < words.length) {
            if (i > 0) {
                constantName.append(UNDER_SCORE);
            }
            constantName.append(words[i].toUpperCase());
            ++i;
        }
        return constantName.toString();
    }

    static String getAttributeName(String name) {
        return GlobalNameMappingImpl.getMethodName(GlobalNameMappingImpl.getWordList(name));
    }

    static String getMethodName(String name) {
        return GlobalNameMappingImpl.getMethodName(GlobalNameMappingImpl.getWordList(name));
    }

    private static String getMethodName(String[] words) {
        StringBuffer methodName = new StringBuffer();
        int i = 0;
        while (i < words.length) {
            methodName.append(words[i]);
            if (i == 0) {
                methodName.setCharAt(i, Character.toLowerCase(methodName.charAt(i)));
            }
            ++i;
        }
        return methodName.toString();
    }

    private static String[] getWordList(String text) {
        ArrayList<String> words = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        int index = 0;
        while (index < text.length() && SignKind.isPunctuation(text.charAt(index))) {
            ++index;
        }
        SignKind last = SignKind.NONE;
        if (index < text.length()) {
            last = SignKind.getSignKind(text.charAt(index));
            word.append(text.charAt(index));
            ++index;
            while (index < text.length()) {
                char letter = text.charAt(index);
                SignKind newStatus = SignKind.getSignKind(letter);
                if (newStatus == SignKind.PUNCTUATION) {
                    last = newStatus;
                } else if (last == SignKind.PUNCTUATION && newStatus != SignKind.PUNCTUATION) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else if (last == SignKind.DIGIT && newStatus != SignKind.DIGIT) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else if (last != SignKind.DIGIT && newStatus == SignKind.DIGIT) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else if (last == SignKind.LOWER && newStatus != SignKind.LOWER) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else if (last == SignKind.UPPER && newStatus == SignKind.UPPER && index < text.length() - 1 && SignKind.getSignKind(text.charAt(index + 1)) == SignKind.LOWER) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else if (last.isLetter() && !newStatus.isLetter()) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else if (!last.isLetter() && newStatus.isLetter()) {
                    word = GlobalNameMappingImpl.newWord(words, word, letter);
                } else {
                    word.append(letter);
                    last = newStatus;
                }
                last = newStatus;
                ++index;
            }
            words.add(word.toString());
        } else {
            words.add(UNDER_SCORE);
        }
        return words.toArray(new String[0]);
    }

    private static StringBuffer newWord(List words, StringBuffer word, char letter) {
        words.add(word.toString());
        StringBuffer newWord = new StringBuffer();
        newWord.append(Character.toUpperCase(letter));
        return newWord;
    }

    private String getName(String name) {
        StringBuffer javaName = new StringBuffer();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            javaName.append(name.charAt(0));
        } else {
            javaName.append(UNDER_SCORE);
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                javaName.append(name.charAt(i));
            } else {
                javaName.append(UNDER_SCORE);
            }
            ++i;
        }
        return javaName.toString();
    }

    private static String getPackageName(List words, String name) throws ProxyGenerationException {
        StringBuffer className = new StringBuffer();
        int i = 0;
        while (i < words.size()) {
            StringBuffer word;
            char start;
            if (i != 0) {
                className.append('.');
            }
            if (!Character.isJavaIdentifierStart(start = (word = new StringBuffer((String)words.get(i))).charAt(0))) {
                word.insert(0, UNDER_SCORE);
            }
            word.setCharAt(0, Character.toLowerCase(word.charAt(0)));
            if (AbstractGlobalNameMapping.isJavaKeyWord(word)) {
                throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.WRONG_PACKAGENAME, new Object[]{name, word});
            }
            className.append((Object)word);
            ++i;
        }
        return className.toString();
    }

    ElementTable getKind(String namespace, int kind) throws ProxyGenerationException {
        String packageName = this.packageNames.get(namespace);
        if (packageName == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_NAMESPACE, new Object[]{namespace});
        }
        return this.packages.get(packageName).get(kind);
    }

    public void addWsdl(Wsdl wsdl) throws ProxyGenerationException {
        if (wsdl != null) {
            List portTypes = wsdl.getPortTypes();
            int i = 0;
            while (i < portTypes.size()) {
                this.add(((WsdlPortType)portTypes.get(i)).getQName(), 7, T_PORTTYPE);
                ++i;
            }
            List messages = wsdl.getMessages();
            int i2 = 0;
            while (i2 < messages.size()) {
                this.add(((WsdlMessage)messages.get(i2)).getQName(), 6, T_MESSAGE);
                ++i2;
            }
            Collection types = wsdl.getTypes().values();
            Iterator i3 = types.iterator();
            while (i3.hasNext()) {
                XsdTypeDef type = (XsdTypeDef)i3.next();
                if (type instanceof XsdSimpleType) {
                    if (!Wsdl.isEnumType((XsdSimpleType)type)) continue;
                    this.add(type.getQName(), 1, T_TYPE);
                    continue;
                }
                this.add(type.getQName(), 1, T_TYPE);
            }
            Collection elements = wsdl.getElements().values();
            Iterator i4 = elements.iterator();
            while (i4.hasNext()) {
                XsdElement elem = (XsdElement)i4.next();
                this.add(elem.getQName(), 2, T_ELEMENT);
                if (!ProxyHelper.hasLocalComplexType(elem)) continue;
                this.add(elem.getQName(), 1, T_TYPE);
            }
            WsdlParameter[] faults = wsdl.getFaults().toArray(new WsdlParameter[0]);
            int i5 = 0;
            while (i5 < faults.length) {
                XsdQName mesName = faults[i5].getMessage();
                this.add(mesName, 6, T_MESSAGE);
                ++i5;
            }
        }
    }

    public final String getPackageName(XsdQName name) {
        return this.packageNames.get(name.getNamespaceUri());
    }

    final GlobalNameMapping.Parts getParts(String namespace) throws ProxyGenerationException {
        String packageName = this.packageNames.get(namespace);
        if (packageName == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_NAMESPACE, new Object[]{namespace});
        }
        return this.packages.get(packageName);
    }

    final String getSpecialTypeName(XsdQName name) {
        if (GlobalNameMappingImpl.isRfcTime(name)) {
            return "java.sql.Time";
        }
        return "java.sql.Date";
    }

    final boolean isSpecialTypeName(XsdQName name) {
        return GlobalNameMappingImpl.isRfcTime(name) || GlobalNameMappingImpl.isRfcDate(name);
    }

    public static final boolean isRfcDate(XsdQName name) {
        return RFC_NAMESPACE.equals(name.getNamespaceUri()) && RFC_DATE.equals(name.getLocalName());
    }

    public static final boolean isRfcTime(XsdQName name) {
        return RFC_NAMESPACE.equals(name.getNamespaceUri()) && RFC_TIME.equals(name.getLocalName());
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("com");
        set.add("edu");
        set.add("gov");
        set.add("mil");
        set.add("net");
        set.add("org");
        DOMAINS = set;
    }

    private final class PartsTable {
        private Map parts = new Hashtable();

        PartsTable() {
        }

        void put(String packageName, GlobalNameMapping.Parts parts) {
            this.parts.put(packageName, parts);
        }

        GlobalNameMapping.Parts get(String packageName) {
            return (GlobalNameMapping.Parts)this.parts.get(packageName);
        }
    }

    class ElementImpl
    extends AbstractGlobalNameMapping.GlobalAbstractElement {
        ElementImpl(GlobalNameMapping globalNames, String typeName, String packageName, XsdQName wsdlName, int kind) {
            super(globalNames, typeName, packageName, wsdlName.toString(), kind);
        }

        final LocalNameMapping getNewLocalNamemapping(GlobalNameMapping globalNames, NameMapping.Element outerElement) {
            return LocalNameMappingFactory.getLocalNameMapping(globalNames, outerElement);
        }

        public final String getTypeName() {
            return this.getJavaName();
        }
    }

    private static class SignKind {
        private final String i;
        public static final SignKind PUNCTUATION = new SignKind("punc");
        public static final SignKind UPPER = new SignKind("upper");
        public static final SignKind LOWER = new SignKind("lower");
        public static final SignKind DIGIT = new SignKind("digit");
        public static final SignKind MARK = new SignKind("mark");
        public static final SignKind NONE = new SignKind("none");
        private static final Set PUNCTUATION_SET = new HashSet();

        private SignKind(String i) {
            this.i = i;
        }

        private static SignKind getSignKind(char letter) {
            if (SignKind.isPunctuation(String.valueOf(letter))) {
                return PUNCTUATION;
            }
            if (Character.isLetter(letter)) {
                if (Character.isUpperCase(letter)) {
                    return UPPER;
                }
                return LOWER;
            }
            if (Character.isDigit(letter)) {
                return DIGIT;
            }
            if (Character.isJavaIdentifierPart(letter)) {
                return MARK;
            }
            return PUNCTUATION;
        }

        private static boolean isPunctuation(char letter) {
            return PUNCTUATION == SignKind.getSignKind(letter);
        }

        private static boolean isPunctuation(String letter) {
            return PUNCTUATION_SET.contains(letter);
        }

        private boolean isLetter() {
            return this == UPPER || this == LOWER;
        }

        static {
            PUNCTUATION_SET.add("-");
            PUNCTUATION_SET.add(".");
            PUNCTUATION_SET.add(":");
            PUNCTUATION_SET.add(GlobalNameMappingImpl.UNDER_SCORE);
            PUNCTUATION_SET.add("\u00b7");
            PUNCTUATION_SET.add("\u0387");
            PUNCTUATION_SET.add("\u06dd");
            PUNCTUATION_SET.add("\u06de");
        }
    }
}

