/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.core.util.Util;
import java.util.Hashtable;
import java.util.Map;

public final class EnumerationMapping {
    private static final String UNDER_SCORE = "_";
    private static final String VALUE = "value";
    private static final String FROM_STRING = " fromString(";
    private static final String THROW = " throw ";
    private static final String EQUALS = "if (name.equals(\"";
    private static final String RETURN = "\")){return ";
    private static final String END = ";};";
    private static final String CLASS = " class ";
    private static final int LENGTH_EQUALS = "if (name.equals(\"".length();
    private static final int LENGTH_RETURN = "\")){return ".length();
    private static final char ESCAPE = '\\';
    private Map labels = new Hashtable();
    private int index = 0;
    private String name = null;

    EnumerationMapping(String enumName, String oldFile) {
        this.name = enumName;
        this.initLabels(oldFile);
    }

    private void initLabels(String text) {
        if (text != null) {
            int begin = text.indexOf(CLASS + this.name);
            int parseBegin = text.indexOf(this.name + FROM_STRING, begin);
            int parseEnd = text.indexOf(THROW, parseBegin);
            String method = text.substring(parseBegin, parseEnd);
            int endLabel = 0;
            int startValue = method.indexOf(EQUALS, endLabel);
            while (startValue != -1) {
                int endValue = method.indexOf(RETURN, startValue += LENGTH_EQUALS);
                String value = method.substring(startValue, endValue);
                int startLabel = endValue + LENGTH_RETURN;
                endLabel = method.indexOf(END, startLabel);
                String label = method.substring(startLabel, endLabel);
                this.labels.put(this.unEscape(value), label);
                startValue = method.indexOf(EQUALS, endLabel);
            }
        }
    }

    private String unEscape(String text) {
        StringBuffer t = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char letter = text.charAt(i);
            if (letter == '\\' && i < text.length() - 1) {
                letter = text.charAt(++i);
            }
            t.append(letter);
            ++i;
        }
        return t.toString();
    }

    public String addLabel(String value) {
        if (!this.labels.containsKey(value)) {
            String label = this.mapValue(value);
            this.labels.put(value, label);
            return label;
        }
        return (String)this.labels.get(value);
    }

    public String getStringLabel(String value) {
        return UNDER_SCORE + this.getLabel(value);
    }

    public String getLabel(String value) {
        return (String)this.labels.get(value);
    }

    public String getEnumName() {
        return this.name;
    }

    private String mapValue(String value) {
        boolean isJavaIdentifier = !Util.isJavaKeyWord(value);
        int i = 0;
        while (isJavaIdentifier && i < value.length()) {
            isJavaIdentifier = i == 0 ? Character.isJavaIdentifierStart(value.charAt(i)) : Character.isJavaIdentifierPart(value.charAt(i));
            ++i;
        }
        if (isJavaIdentifier) {
            return value;
        }
        ++this.index;
        while (this.labels.containsValue(VALUE + this.index)) {
            ++this.index;
        }
        return VALUE + this.index;
    }
}

