/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.nameMapping;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.nameMapping.ElementTable;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalOperationMapping;
import com.sap.aii.proxy.generation.core.nameMapping.MessageId;
import com.sap.aii.proxy.generation.core.nameMapping.NameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.RpcTypeMapping;
import com.sap.aii.proxy.generation.core.util.Util;
import com.sap.aii.util.xsd.api.XsdQName;
import java.io.Serializable;
import java.util.StringTokenizer;

abstract class AbstractGlobalNameMapping
implements GlobalNameMapping,
JavaTypes {
    private static final String UNDER_SCORE = "_";
    private static final String DOT = ".";
    private static final String SLASH = "/";

    AbstractGlobalNameMapping() {
    }

    abstract String getSpecialTypeName(XsdQName var1);

    abstract boolean isSpecialTypeName(XsdQName var1);

    abstract GlobalNameMapping.Parts getParts(String var1) throws ProxyGenerationException;

    public final String getLocalName(XsdQName name, int kind) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(name.getNamespaceUri(), kind);
        NameMapping.Element element = kindTable.get(name.getLocalName());
        if (element == null) {
            throw this.getException(name, kind);
        }
        return element.getJavaName();
    }

    private ElementTable getKind(String namespace, int kind) throws ProxyGenerationException {
        GlobalNameMapping.Parts parts = this.getParts(namespace);
        ElementTable table = parts.get(kind);
        return table;
    }

    public final ProxyGenerationException getException(XsdQName name, int kind) {
        StringBuffer text = new StringBuffer();
        Object[] args = new Object[]{name.toString()};
        switch (kind) {
            case 2: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_ELEMENT, args);
            }
            case 1: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_TYPE, args);
            }
            case 3: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_GROUP, args);
            }
            case 4: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_ATTRIBUTE, args);
            }
            case 5: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_ATTRIBUTE_GROUP, args);
            }
            case 6: {
                return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_MESSAGE, args);
            }
        }
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_PORTTYPE, args);
    }

    public static final String getJavaType(XsdQName name) throws ProxyGenerationException {
        return RpcTypeMapping.getType(name);
    }

    private static String reverseFirstPart(String name) {
        StringBuffer newStr = new StringBuffer();
        StringTokenizer tokens1 = new StringTokenizer(name, SLASH, true);
        if (tokens1.hasMoreTokens()) {
            String first = tokens1.nextToken();
            StringTokenizer tokens2 = new StringTokenizer(first, DOT, true);
            while (tokens2.hasMoreTokens()) {
                String token = tokens2.nextToken();
                if (token.equals(DOT)) {
                    newStr.insert(0, SLASH);
                    continue;
                }
                newStr.insert(0, token);
            }
        }
        while (tokens1.hasMoreTokens()) {
            newStr.append(tokens1.nextToken());
        }
        return newStr.toString();
    }

    public final String getFullName(XsdQName name, int kind) throws ProxyGenerationException {
        if (Util.isXsdType(name)) {
            return AbstractGlobalNameMapping.getJavaType(name);
        }
        String packageName = this.getPackageName(name);
        if (packageName.trim().equals("")) {
            return this.getLocalName(name, kind);
        }
        return packageName + DOT + this.getLocalName(name, kind);
    }

    public final LocalNameMapping getLocalMapping(XsdQName name, int kind) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(name.getNamespaceUri(), kind);
        NameMapping.Element element = kindTable.get(name.getLocalName());
        if (element == null) {
            throw this.getException(name, kind);
        }
        return element.getLocalMapping();
    }

    static final boolean isJavaKeyWord(StringBuffer name) {
        return Util.isJavaKeyWord(name.toString());
    }

    public final String getFullNameAttribute(XsdQName name) throws ProxyGenerationException {
        return this.getFullName(name, 4);
    }

    public final String getFullNameAttributeGroup(XsdQName name) throws ProxyGenerationException {
        return this.getFullName(name, 5);
    }

    public final String getFullNameElement(XsdQName name) throws ProxyGenerationException {
        return this.getFullName(name, 2);
    }

    public final String getFullNameGroup(XsdQName name) throws ProxyGenerationException {
        return this.getFullName(name, 3);
    }

    public final String getFullNameMessage(XsdQName name) throws ProxyGenerationException {
        return this.getFullName(name, 6);
    }

    public final String getFullNamePortType(XsdQName name) throws ProxyGenerationException {
        return this.getFullName(name, 7);
    }

    public final String getFullNameType(XsdQName name) throws ProxyGenerationException {
        if (Util.isXsdType(name)) {
            return AbstractGlobalNameMapping.getJavaType(name);
        }
        if (this.isSpecialTypeName(name)) {
            return this.getSpecialTypeName(name);
        }
        String packageName = this.getPackageName(name);
        if (packageName.trim().equals("")) {
            return this.getLocalNameType(name);
        }
        return packageName + DOT + this.getLocalNameType(name);
    }

    public final LocalNameMapping getLocalMappingAttribute(XsdQName name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 4);
    }

    public final LocalNameMapping getLocalMappingAttributeGroup(XsdQName name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 5);
    }

    public final LocalNameMapping getLocalMappingElement(XsdQName name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 2);
    }

    public final LocalNameMapping getLocalMappingGroup(XsdQName name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 3);
    }

    public final LocalNameMapping getLocalMappingMessage(XsdQName name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 6);
    }

    public final LocalOperationMapping getLocalMappingPortType(XsdQName name) throws ProxyGenerationException {
        ElementTable kindTable = this.getKind(name.getNamespaceUri(), 7);
        NameMapping.Element element = kindTable.get(name.getLocalName());
        return (LocalOperationMapping)((Object)element.getLocalMapping());
    }

    public final LocalNameMapping getLocalMappingType(XsdQName name) throws ProxyGenerationException {
        return this.getLocalMapping(name, 1);
    }

    public final String getLocalNameAttribute(XsdQName name) throws ProxyGenerationException {
        return this.getLocalName(name, 5);
    }

    public final String getLocalNameAttributeGroup(XsdQName name) throws ProxyGenerationException {
        return this.getLocalName(name, 5);
    }

    public final String getLocalNameElement(XsdQName name) throws ProxyGenerationException {
        return this.getLocalName(name, 2);
    }

    public final String getLocalNameGroup(XsdQName name) throws ProxyGenerationException {
        return this.getLocalName(name, 3);
    }

    public final String getLocalNameMessage(XsdQName name) throws ProxyGenerationException {
        return this.getLocalName(name, 6);
    }

    public final String getLocalNamePortType(XsdQName name) throws ProxyGenerationException {
        return this.getLocalName(name, 7);
    }

    public final String getLocalNameType(XsdQName name) throws ProxyGenerationException {
        if (Util.isXsdType(name)) {
            return AbstractGlobalNameMapping.getJavaType(name);
        }
        if (this.isSpecialTypeName(name)) {
            return this.getSpecialTypeName(name);
        }
        return this.getLocalName(name, 1);
    }

    public abstract String getPackageName(XsdQName var1) throws ProxyGenerationException;

    public abstract void addWsdl(Wsdl var1) throws ProxyGenerationException;

    public abstract class GlobalAbstractElement
    extends NameMapping.AbstractElement
    implements NameMapping.Element,
    Serializable {
        private static final long serialVersionUID = 1561943219408330063L;

        protected GlobalAbstractElement(GlobalNameMapping globalNames, String typeName, String packageName, String wsdlName, int kind) {
            super(globalNames, typeName, packageName, wsdlName, kind);
        }

        final String getType() {
            int kind = this.getKind();
            switch (kind) {
                case 1: {
                    return "<type>";
                }
                case 2: {
                    return "<element>";
                }
                case 3: {
                    return "<group>";
                }
                case 4: {
                    return "<attribute>";
                }
                case 5: {
                    return "<group>";
                }
                case 6: {
                    return "<message>";
                }
                case 7: {
                    return "<portType>";
                }
            }
            return null;
        }
    }
}

