/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.binding.sap;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.InternalProxyGenException;
import com.sap.aii.proxy.generation.core.binding.sap.MessageId;
import com.sap.aii.util.misc.api.UnexpectedException;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.impl.XDocumentImpl;
import com.sap.aii.util.xml.xdom.io.XDOMOutputter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public abstract class TypeMapping {
    private static final HashMap typeMapAbap2Java = new HashMap();
    private static final String ASCII = "ASCII";
    private static final String UTF_8 = "UTF-8";
    private static final String HEX = "0x";
    private static final char SLASH = '/';
    private static final char DOT = '.';
    private static final char UNDER_SCORE = '_';
    private static final String PREFIX_ABAP_1 = "_-";
    private static final String PREFIX_ABAP_2 = "_--";
    private static final String PREFIX_ABAP_3 = "_--0";

    protected static final String mapAbap2Java(String abapType) throws ProxyGenerationException {
        String jcoType = (String)typeMapAbap2Java.get(abapType);
        if (jcoType != null) {
            return jcoType;
        }
        throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.INVALID_ABAP_TYPE, new Object[]{abapType});
    }

    protected static final String mapIfrClass2Jco(String ifrClass) throws ProxyGenerationException {
        if (ifrClass.compareToIgnoreCase("import") == 0) {
            return "com.sap.mw.jco.JCO.IMPORT_PARAMETER";
        }
        if (ifrClass.compareToIgnoreCase("export") == 0) {
            return "com.sap.mw.jco.JCO.EXPORT_PARAMETER";
        }
        if (ifrClass.compareToIgnoreCase("tables") == 0) {
            return "0";
        }
        if (ifrClass.compareToIgnoreCase("changing") == 0 || ifrClass.compareToIgnoreCase("import_export") == 0) {
            return "com.sap.mw.jco.JCO.EXPORT_PARAMETER | com.sap.mw.jco.JCO.IMPORT_PARAMETER";
        }
        throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.INVALID_PARAMETER_TYPE, new Object[]{ifrClass});
    }

    public static final String getAbapName(String xmlName) {
        StringBuffer abap = new StringBuffer();
        int index = xmlName.indexOf(PREFIX_ABAP_1);
        while (index != -1) {
            abap.append(xmlName.substring(0, index));
            xmlName = xmlName.substring(index);
            if (xmlName.startsWith(PREFIX_ABAP_2)) {
                String sign = null;
                try {
                    String value = xmlName.substring(3, 5);
                    byte i = Byte.decode(HEX + value);
                    sign = new String(new byte[]{i}, ASCII);
                }
                catch (NumberFormatException e) {
                    new UnexpectedException((Exception)e);
                }
                catch (UnsupportedEncodingException e) {
                    new UnexpectedException((Exception)e);
                }
                abap.append(sign);
                xmlName = xmlName.substring(5);
            } else {
                abap.append('/');
                xmlName = xmlName.substring(2);
            }
            index = xmlName.indexOf(PREFIX_ABAP_1);
        }
        abap.append(xmlName);
        return abap.toString();
    }

    static final String getWsdlName(String abapName) throws ProxyGenerationException {
        StringBuffer wsdl = new StringBuffer();
        int i = 0;
        while (i < abapName.length()) {
            char letter = abapName.charAt(i);
            if (letter == '/') {
                wsdl.append(PREFIX_ABAP_1);
            } else if (i == 0) {
                if (Character.isLetter(letter) || letter == '_') {
                    wsdl.append(letter);
                } else {
                    wsdl.append(TypeMapping.getHex(letter));
                }
            } else if (Character.isLetterOrDigit(letter) || letter == '_' || letter == '.') {
                wsdl.append(letter);
            } else {
                wsdl.append(TypeMapping.getHex(letter));
            }
            ++i;
        }
        return wsdl.toString();
    }

    private static String getHex(char letter) {
        byte[] code = new byte[]{0};
        try {
            code = String.valueOf(letter).getBytes(ASCII);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnexpectedException((Exception)e);
        }
        byte codes = code[0];
        String hex = Integer.toHexString(codes);
        if (hex.length() == 1) {
            return PREFIX_ABAP_3 + hex.toLowerCase();
        }
        return PREFIX_ABAP_2 + hex.toLowerCase();
    }

    public static final String getXmlString(XElement element) throws ProxyGenerationException {
        String xml = null;
        try {
            XDOMOutputter out = new XDOMOutputter("", false, UTF_8);
            out.setIndent(false);
            XDocumentImpl doc = new XDocumentImpl(element);
            xml = out.write((XDocument)doc);
        }
        catch (IOException e) {
            throw new InternalProxyGenException((ProxyGenerationException.MessageId)MessageId.INTERNAL_ERROR_XML, (Throwable)e);
        }
        return xml;
    }

    static {
        typeMapAbap2Java.put("b", "com.sap.mw.jco.JCO.TYPE_INT1");
        typeMapAbap2Java.put("I", "com.sap.mw.jco.JCO.TYPE_INT");
        typeMapAbap2Java.put("P", "com.sap.mw.jco.JCO.TYPE_BCD");
        typeMapAbap2Java.put("D", "com.sap.mw.jco.JCO.TYPE_DATE");
        typeMapAbap2Java.put("N", "com.sap.mw.jco.JCO.TYPE_NUM");
        typeMapAbap2Java.put("T", "com.sap.mw.jco.JCO.TYPE_TIME");
        typeMapAbap2Java.put("C", "com.sap.mw.jco.JCO.TYPE_CHAR");
        typeMapAbap2Java.put("F", "com.sap.mw.jco.JCO.TYPE_FLOAT");
        typeMapAbap2Java.put("s", "com.sap.mw.jco.JCO.TYPE_INT2");
        typeMapAbap2Java.put("X", "com.sap.mw.jco.JCO.TYPE_BYTE");
        typeMapAbap2Java.put("g", "com.sap.mw.jco.JCO.TYPE_STRING");
        typeMapAbap2Java.put("y", "com.sap.mw.jco.JCO.TYPE_XSTRING");
    }
}

