/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.binding.sap;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.binding.sap.SapBindingTags;
import com.sap.aii.proxy.generation.core.binding.sap.SapElement;
import com.sap.aii.proxy.generation.core.binding.sap.TypeMapping;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xsd.api.XsdQName;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class SapType
extends TypeMapping
implements SapBindingTags {
    private String abapName;
    private int byteLength1 = -1;
    private int byteLength2 = -1;
    private int byteLength4 = -1;
    private Map elements = new Hashtable();
    private String internalType = "com.sap.mw.jco.JCO.TYPE_STRUCTURE";
    private XsdQName complexType;
    private String xml;

    SapType(XElement element) throws ProxyGenerationException {
        if (element.getNamespace().getURI().equals("urn:sap-com:document:sap:rfc:functions") && element.getLocalName().equals("type")) {
            XElement abapType;
            XElement fields;
            XElement internalLength4;
            XElement internalLength2;
            String namespace = "urn:sap-com:ifr:v2:metamodel";
            this.xml = TypeMapping.getXmlString(SapType.getElement(element, namespace));
            List attributes = element.getAttributes();
            int i = 0;
            while (i < attributes.size()) {
                XAttribute attribute = (XAttribute)attributes.get(i);
                if (attribute.getLocalName().equals("name")) {
                    this.abapName = attribute.getValue();
                }
                ++i;
            }
            XElement container = element.getSubElement("container", namespace);
            XElement definition = container.getSubElement("definition", namespace);
            XElement scalarType = definition.getSubElement("scalarType", namespace);
            if (scalarType != null) {
                definition = scalarType.getSubElement("definition", namespace);
            } else {
                String name;
                XElement complex = definition.getSubElement("complexType", namespace);
                if (complex != null && (name = complex.getAttribute("name").getValue()) != null) {
                    String wsdlName = TypeMapping.getWsdlName(name);
                    this.complexType = new XsdQName(wsdlName, "urn:sap-com:document:sap:rfc:functions");
                }
            }
            XElement internalLength1 = definition.getSubElement("internalLength1", namespace);
            if (internalLength1 != null) {
                this.byteLength1 = Integer.parseInt(internalLength1.getText().trim());
            }
            if ((internalLength2 = definition.getSubElement("internalLength2", namespace)) != null) {
                this.byteLength2 = Integer.parseInt(internalLength2.getText().trim());
            }
            if ((internalLength4 = definition.getSubElement("internalLength4", namespace)) != null) {
                this.byteLength4 = Integer.parseInt(internalLength4.getText().trim());
            }
            if ((fields = definition.getSubElement("fields", namespace)) != null) {
                this.addElements(fields);
            }
            if ((abapType = definition.getSubElement("abapType", namespace)) != null) {
                this.internalType = TypeMapping.mapAbap2Java(abapType.getText().trim());
            }
        }
    }

    private void addElements(XElement element) throws ProxyGenerationException {
        XElement[] fields = element.getSubElements();
        int i = 0;
        while (i < fields.length) {
            XElement elem = fields[i];
            if (elem.getLocalName().equals("field") && elem.getNamespace().getURI().equals("urn:sap-com:ifr:v2:metamodel")) {
                SapElement sapElement = new SapElement(fields[i]);
                this.elements.put(TypeMapping.getWsdlName(sapElement.getAbapName()), sapElement);
            }
            ++i;
        }
    }

    private static XElement getElement(XElement element, String namespace) {
        XElement fields;
        XElement definition;
        XElement elem = (XElement)element.clone();
        XElement container = elem.getSubElement("container", namespace);
        if (container != null && (definition = container.getSubElement("definition", namespace)) != null && (fields = definition.getSubElement("fields", namespace)) != null) {
            definition.remove(fields);
        }
        return elem;
    }

    public String getAbapName() {
        return this.abapName;
    }

    public int getByteLength1() {
        return this.byteLength1;
    }

    public int getByteLength2() {
        return this.byteLength2;
    }

    public int getByteLength4() {
        return this.byteLength4;
    }

    public Map getElements() {
        return this.elements;
    }

    public SapElement getSapElement(String name) {
        return (SapElement)this.elements.get(name);
    }

    public String getInternalType() {
        return this.internalType;
    }

    public XsdQName getComplexType() {
        return this.complexType;
    }

    public String getXml() {
        return this.xml;
    }
}

