/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.binding.sap;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.WsdlBindingOperation;
import com.sap.aii.proxy.generation.core.binding.sap.SapBindingTags;
import com.sap.aii.proxy.generation.core.binding.sap.SapParameter;
import com.sap.aii.proxy.generation.core.binding.sap.TypeMapping;
import com.sap.aii.util.xml.xdom.XElement;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class SapOperation
implements SapBindingTags {
    private String wsdlName;
    private String abapName;
    private Hashtable parameters = new Hashtable();
    private boolean isUnicode1 = true;
    private boolean isUnicode2 = false;
    private boolean isUnicode4 = false;
    private String xml = null;

    public SapOperation() {
    }

    SapOperation(WsdlBindingOperation operation) throws ProxyGenerationException {
        this.wsdlName = operation.getName();
        this.abapName = TypeMapping.getAbapName(this.wsdlName);
        this.addParameters(operation.getExtentions());
    }

    private void addParameters(List extentions) throws ProxyGenerationException {
        int i = 0;
        while (i < extentions.size()) {
            XElement element = (XElement)extentions.get(i);
            if (element.getNamespace().getURI().equals("urn:sap-com:ifr:v2:metamodel") && element.getLocalName().equals("container")) {
                String namespace = element.getNamespace().getURI();
                this.xml = TypeMapping.getXmlString(SapOperation.getElement(element, namespace));
                XElement properties = element.getSubElement("properties", namespace);
                if (properties != null) {
                    XElement unicode4;
                    XElement unicode2 = properties.getSubElement("unicode2", namespace);
                    if (unicode2 != null) {
                        this.isUnicode2 = unicode2.getText().trim().equals("true");
                    }
                    if ((unicode4 = properties.getSubElement("unicode4", namespace)) != null) {
                        this.isUnicode4 = unicode4.getText().trim().equals("true");
                    }
                }
                XElement definition = element.getSubElement("definition", namespace);
                XElement parameters = definition.getSubElement("parameters", namespace);
                XElement[] children = parameters.getSubElements();
                int j = 0;
                while (j < children.length) {
                    XElement child = children[j];
                    if (child.getNamespace().getURI().equals("urn:sap-com:ifr:v2:metamodel") && child.getLocalName().equals("parameter")) {
                        this.addParameter(new SapParameter(child, this.isUnicode1, this.isUnicode2, this.isUnicode4));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static XElement getElement(XElement element, String namespace) {
        XElement elem = (XElement)element.clone();
        XElement definition = elem.getSubElement("definition", namespace);
        if (definition != null) {
            XElement exceptions;
            XElement parameters = definition.getSubElement("parameters", namespace);
            if (parameters != null) {
                definition.remove(parameters);
            }
            if ((exceptions = definition.getSubElement("exceptions", namespace)) != null) {
                definition.remove(exceptions);
            }
        }
        return elem;
    }

    public String getWsdlName() {
        return this.wsdlName;
    }

    public String getAbapName() {
        return this.abapName;
    }

    public void addParameter(SapParameter parameter) throws ProxyGenerationException {
        this.parameters.put(TypeMapping.getWsdlName(parameter.getAbapName()), parameter);
    }

    public SapParameter getParameter(String name) {
        return (SapParameter)this.parameters.get(name);
    }

    public Map getParameters() {
        return this.parameters;
    }

    public boolean isUnicode1() {
        return this.isUnicode1;
    }

    public boolean isUnicode2() {
        return this.isUnicode2;
    }

    public boolean isUnicode4() {
        return this.isUnicode4;
    }

    public String getXml() {
        return this.xml;
    }
}

