/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core.binding.sap;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlBinding;
import com.sap.aii.proxy.generation.core.WsdlBindingOperation;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlOperation;
import com.sap.aii.proxy.generation.core.WsdlParameter;
import com.sap.aii.proxy.generation.core.WsdlPart;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.proxy.generation.core.binding.sap.SapBindingTags;
import com.sap.aii.proxy.generation.core.binding.sap.SapOperation;
import com.sap.aii.proxy.generation.core.binding.sap.SapType;
import com.sap.aii.proxy.generation.core.binding.sap.TypeMapping;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xsd.api.XsdQName;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SapBinding
implements SapBindingTags {
    private String name;
    private XsdQName bindingType;
    private String style;
    private Hashtable operations = new Hashtable();
    private Hashtable types = new Hashtable();
    private Hashtable params = new Hashtable();

    public SapBinding(WsdlBinding binding, Wsdl wsdl) throws ProxyGenerationException {
        this.name = binding.getName();
        this.bindingType = binding.getType();
        this.addTypes(binding.getExtentions());
        this.addOperations(binding.getOperations(), wsdl);
    }

    private void addTypes(List extentions) throws ProxyGenerationException {
        int i = 0;
        while (i < extentions.size()) {
            XElement element = (XElement)extentions.get(i);
            if (element.getNamespace().getURI().equals("urn:sap-com:document:sap:rfc:functions") && element.getLocalName().equals("binding")) {
                List attributes = element.getAttributes();
                int j = 0;
                while (j < attributes.size()) {
                    XAttribute attribute = (XAttribute)attributes.get(j);
                    if (attribute.getLocalName().equals("style")) {
                        this.style = attribute.getValue();
                    }
                    ++j;
                }
            } else if (element.getNamespace().getURI().equals("urn:sap-com:document:sap:rfc:functions") && element.getLocalName().equals("type")) {
                this.addType(new SapType(element));
            }
            ++i;
        }
    }

    private void addElements(WsdlParameter param, Set elements, Wsdl wsdl) {
        WsdlMessage message;
        if (param != null && (message = wsdl.getMessage(param.getMessage())) != null) {
            List parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                WsdlPart part = (WsdlPart)parts.get(i);
                XsdQName element = part.getElement();
                if (element != null) {
                    elements.add(element);
                }
                ++i;
            }
        }
    }

    private Set getElements(String operationName, Wsdl wsdl) {
        WsdlOperation operation;
        HashSet elements = new HashSet();
        WsdlPortType porttype = wsdl.getPortType(this.bindingType);
        if (porttype != null && (operation = porttype.getOperation(operationName)) != null) {
            this.addElements(operation.getInput(), elements, wsdl);
            this.addElements(operation.getOutput(), elements, wsdl);
            List faults = operation.getFaults();
            int i = 0;
            while (i < faults.size()) {
                this.addElements((WsdlParameter)faults.get(i), elements, wsdl);
                ++i;
            }
        }
        return elements;
    }

    private void addOperations(Enumeration wsdlOperations, Wsdl wsdl) throws ProxyGenerationException {
        while (wsdlOperations.hasMoreElements()) {
            WsdlBindingOperation operation = (WsdlBindingOperation)wsdlOperations.nextElement();
            String name = operation.getName();
            SapOperation SapOp = new SapOperation(operation);
            this.addOperation(SapOp, this.getElements(name, wsdl));
        }
    }

    public String getName() {
        return this.name;
    }

    public XsdQName getBindingType() {
        return this.bindingType;
    }

    public String getStyle() {
        return this.style;
    }

    public void addOperation(SapOperation operation, Set elements) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            this.params.put(iter.next(), operation);
        }
        this.operations.put(operation.getWsdlName(), operation);
    }

    public SapOperation getOperation(String name) {
        return (SapOperation)this.operations.get(name);
    }

    public SapOperation getOperation(XsdQName elementName) {
        return (SapOperation)this.params.get(elementName);
    }

    public Enumeration getOperations() {
        return this.operations.elements();
    }

    public void addType(SapType type) throws ProxyGenerationException {
        String wsdlName = TypeMapping.getWsdlName(type.getAbapName());
        XsdQName name = new XsdQName(wsdlName, "urn:sap-com:document:sap:rfc:functions");
        this.types.put(name, type);
    }

    public SapType getType(XsdQName name) {
        return (SapType)this.types.get(name);
    }

    public Enumeration getTypes() {
        return this.types.elements();
    }
}

