/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.MessageId;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlBinding;
import com.sap.aii.proxy.generation.core.WsdlBindingOperation;
import com.sap.aii.proxy.generation.core.WsdlBindingParameter;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlOperation;
import com.sap.aii.proxy.generation.core.WsdlParameter;
import com.sap.aii.proxy.generation.core.WsdlPart;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.proxy.generation.core.WsdlTags;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.impl.XElementImpl;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdException;
import com.sap.aii.util.xsd.api.XsdHandler;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSchema;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WsdlParser
implements WsdlTags {
    private Wsdl wsdl;

    WsdlParser() {
    }

    Wsdl parseWsdl(XDocument doc) throws ProxyGenerationException {
        XElement root = doc.getRoot();
        return this.parseWsdl(root);
    }

    private boolean isWsdlNamespace(XElement element) {
        String uri = element.getNamespace().getURI();
        return "http://schemas.xmlsoap.org/wsdl/".equals(uri) || "http://schemas.xmlsoap.org/wsdl".equals(uri);
    }

    Wsdl parseWsdl(XElement root) throws ProxyGenerationException {
        if (!root.getLocalName().equals("definitions") || !this.isWsdlNamespace(root)) {
            throw this.getNotAllowedRootException(root);
        }
        this.wsdl = new Wsdl();
        List attributes = root.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                this.wsdl.setName(attribute.getValue());
            } else if (attribute.getLocalName().equals("targetNamespace")) {
                this.wsdl.setTargetNamespace(attribute.getValue());
            } else {
                throw this.getNotAllowedAttributeException(attribute, root);
            }
            ++i;
        }
        XElement[] children = root.getSubElements();
        int i2 = 0;
        while (i2 < children.length) {
            XElement child = children[i2];
            if (this.isWsdlTag(child, "import")) {
                this.wsdl.addImport(child);
            } else if (this.isWsdlTag(child, "documentation")) {
                this.parseDocumentation(child);
            } else if (this.isWsdlTag(child, "types")) {
                XsdSchema[] schemas = this.parseTypes(child);
                int j = 0;
                while (j < schemas.length) {
                    this.wsdl.addSchema(schemas[j]);
                    List complexTypes = schemas[j].getComplexTypes();
                    int k = 0;
                    while (k < complexTypes.size()) {
                        XsdComplexType cType = (XsdComplexType)complexTypes.get(k);
                        this.wsdl.addType((XsdTypeDef)cType);
                        ++k;
                    }
                    List simpleTypes = schemas[j].getSimpleTypes();
                    int k2 = 0;
                    while (k2 < simpleTypes.size()) {
                        XsdSimpleType sType = (XsdSimpleType)simpleTypes.get(k2);
                        this.wsdl.addType((XsdTypeDef)sType);
                        ++k2;
                    }
                    List elements = schemas[j].getElements();
                    int k3 = 0;
                    while (k3 < elements.size()) {
                        XsdElement element = (XsdElement)elements.get(k3);
                        this.wsdl.addElement(element);
                        ++k3;
                    }
                    List attribs = schemas[j].getAttributes();
                    int k4 = 0;
                    while (k4 < attribs.size()) {
                        XsdAttribute attribute = (XsdAttribute)attribs.get(k4);
                        this.wsdl.addAttribute(attribute);
                        ++k4;
                    }
                    List attGroups = schemas[j].getAttributeGroups();
                    int k5 = 0;
                    while (k5 < attGroups.size()) {
                        XsdAttributeGroup attGroup = (XsdAttributeGroup)attGroups.get(k5);
                        this.wsdl.addAttributeGroup(attGroup);
                        ++k5;
                    }
                    List groups = schemas[j].getGroups();
                    int k6 = 0;
                    while (k6 < groups.size()) {
                        XsdParticle group = (XsdParticle)groups.get(k6);
                        this.wsdl.addGroup(group);
                        ++k6;
                    }
                    ++j;
                }
            } else if (this.isWsdlTag(child, "message")) {
                WsdlMessage m = this.parseMessage(child);
                this.wsdl.addMessage(m);
            } else if (this.isWsdlTag(child, "portType")) {
                this.wsdl.addPortType(this.parsePortType(child));
            } else if (this.isWsdlTag(child, "binding")) {
                this.wsdl.addBinding(this.parseBinding(child));
            } else if (this.isWsdlTag(child, "service")) {
                this.wsdl.addService(child);
            } else if (this.isTopLevelExtension(child)) {
                this.wsdl.addExtention(child);
            } else {
                throw this.getNotAllowedTagException(child);
            }
            ++i2;
        }
        return this.wsdl;
    }

    protected XsdSchema[] parseTypes(XElement element) throws ProxyGenerationException {
        ArrayList<XsdSchema> schemas = new ArrayList<XsdSchema>();
        XElement[] children = element.getSubElements();
        int i = 0;
        while (i < children.length) {
            XElement child = children[i];
            if (child.getLocalName().equals("schema")) {
                try {
                    XsdHandler parser = new XsdHandler();
                    schemas.add(parser.parseSchema(child));
                }
                catch (XsdException e) {
                    throw this.getXsdException(e, child);
                }
            } else {
                throw new ProxyGenerationException(MessageId.NEEDED_TYPEDEF);
            }
            ++i;
        }
        return schemas.toArray(new XsdSchema[0]);
    }

    protected String parseDocumentation(XElement element) {
        StringBuffer text = new StringBuffer(element.getText());
        return text.toString();
    }

    protected WsdlPortType parsePortType(XElement element) throws ProxyGenerationException {
        WsdlPortType portType = new WsdlPortType(this.wsdl);
        List attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                portType.setName(attribute.getValue());
            }
            ++i;
        }
        XElement[] children = element.getSubElements();
        int i2 = 0;
        XElement child = null;
        if (i2 < children.length && this.isWsdlTag(child = children[i2], "documentation")) {
            this.parseDocumentation(child);
            ++i2;
        }
        if (i2 < children.length) {
            do {
                if (!this.isWsdlTag(child = children[i2], "operation")) continue;
                WsdlOperation op = this.parseOperation(child);
                portType.addOperation(op);
                portType.setInbound(op.inbound);
                ++i2;
            } while (this.isWsdlTag(child, "operation") && i2 < children.length);
        }
        if (i2 < children.length) {
            do {
                if (!this.isTopLevelExtension(child = children[i2])) continue;
                ++i2;
            } while (this.isTopLevelExtension(child) && i2 < children.length);
        }
        return portType;
    }

    protected WsdlBinding parseBinding(XElement element) {
        WsdlBinding binding = new WsdlBinding();
        List attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                binding.setName(attribute.getValue());
            } else if (attribute.getLocalName().equals("type")) {
                binding.setType(new XsdQName(attribute.getValue(), element));
            }
            ++i;
        }
        XElement[] children = element.getSubElements();
        int i2 = 0;
        while (i2 < children.length) {
            XElement child = children[i2];
            if (this.isWsdlTag(child, "operation")) {
                binding.addOperation(this.parseBindingOperation(child));
            } else {
                binding.addExtention(child);
            }
            ++i2;
        }
        return binding;
    }

    protected WsdlBindingOperation parseBindingOperation(XElement element) {
        WsdlBindingOperation operation = new WsdlBindingOperation();
        List attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                operation.setName(attribute.getValue());
            }
            ++i;
        }
        XElement[] children = element.getSubElements();
        XElement child = null;
        int i2 = 0;
        while (i2 < children.length) {
            child = children[i2];
            if (this.isWsdlTag(child, "input")) {
                operation.setInput(this.parseBindingParameter(child));
            } else if (this.isWsdlTag(child, "output")) {
                operation.setOutput(this.parseBindingParameter(child));
            } else if (this.isWsdlTag(child, "fault")) {
                operation.addFault(this.parseBindingParameter(child));
            } else {
                operation.addExtention(child);
            }
            ++i2;
        }
        return operation;
    }

    protected WsdlBindingParameter parseBindingParameter(XElement element) {
        WsdlBindingParameter param = new WsdlBindingParameter();
        List attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                param.setName(attribute.getValue());
            }
            ++i;
        }
        XElement[] children = element.getSubElements();
        int i2 = 0;
        while (i2 < children.length) {
            XElement child = children[i2];
            param.addExtention(child);
            ++i2;
        }
        return param;
    }

    protected WsdlMessage parseMessage(XElement element) throws ProxyGenerationException {
        List attributes = element.getAttributes();
        WsdlMessage message = new WsdlMessage(this.wsdl);
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                String name = attribute.getValue();
                int index = name.indexOf(".");
                if (index != -1) {
                    String prefix = name.substring(0, index);
                    XNamespace ns = element.getNamespace(prefix);
                    if (ns != null) {
                        String namespace = ns.getURI();
                        String localName = name.substring(index + 1);
                        message.setName(localName);
                        message.setNamespace(namespace);
                    } else {
                        message.setName(name);
                    }
                } else {
                    message.setName(name);
                }
            }
            ++i;
        }
        if (message.getName() == null) {
            throw this.getNeededAttributeException("name", element);
        }
        XElement[] children = element.getSubElements();
        int i2 = 0;
        XElement child = null;
        if (i2 < children.length && this.isWsdlTag(child = children[i2], "documentation")) {
            this.parseDocumentation(child);
            ++i2;
        }
        if (i2 < children.length) {
            do {
                if (!this.isWsdlTag(child = children[i2], "part")) continue;
                message.addPart(this.parsePart(child));
                ++i2;
            } while (this.isWsdlTag(child, "part") && i2 < children.length);
        }
        if (i2 < children.length) {
            do {
                if (!this.isTopLevelExtension(child = children[i2])) continue;
                ++i2;
            } while (this.isTopLevelExtension(child) && i2 < children.length);
        }
        return message;
    }

    /*
     * Unable to fully structure code
     */
    protected WsdlOperation parseOperation(XElement element) throws ProxyGenerationException {
        block14: {
            block16: {
                block15: {
                    operation = new WsdlOperation();
                    attributes = element.getAttributes();
                    i = 0;
                    while (i < attributes.size()) {
                        attribute = (XAttribute)attributes.get(i);
                        if (attribute.getLocalName().equals("name")) {
                            operation.setName(attribute.getValue());
                        } else if (attribute.getLocalName().equals("parameterOrder")) {
                            operation.setParameterOrder(attribute.getValue());
                        }
                        ++i;
                    }
                    if (operation.getName() == null) {
                        throw this.getNeededAttributeException("name", element);
                    }
                    children = element.getSubElements();
                    i = 0;
                    child = null;
                    if (i < children.length && this.isWsdlTag(child = children[i], "documentation")) {
                        this.parseDocumentation(child);
                        ++i;
                    }
                    if (i >= children.length) break block14;
                    child = children[i];
                    if (!this.isWsdlTag(child, "input")) break block15;
                    operation.setInbound(true);
                    operation.setInput(this.parseParameter(child));
                    if (++i >= children.length) break block14;
                    child = children[i];
                    if (!this.isWsdlTag(child, "output")) ** GOTO lbl48
                    operation.setOutput(this.parseParameter(child));
                    ++i;
                    while (i < children.length) {
                        child = children[i];
                        if (this.isWsdlTag(child, "fault")) {
                            operation.addFault(this.parseParameter(child));
                            ++i;
                            continue;
                        }
                        throw this.getNotAllowedTagException(child);
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        child = children[i];
                        if (this.isWsdlTag(child, "fault")) {
                            operation.addFault(this.parseParameter(child));
                            ++i;
                            continue;
                        }
                        throw this.getNotAllowedTagException(child);
lbl48:
                        // 2 sources

                        ** while (i < children.length)
                    }
lbl49:
                    // 1 sources

                    break block14;
                }
                if (!this.isWsdlTag(child, "output")) break block16;
                operation.setInbound(false);
                operation.setInput(this.parseParameter(child));
                if (++i >= children.length) break block14;
                child = children[i];
                if (!this.isWsdlTag(child, "input")) ** GOTO lbl75
                operation.setOutput(this.parseParameter(child));
                ++i;
                while (i < children.length) {
                    child = children[i];
                    if (this.isWsdlTag(child, "fault")) {
                        operation.addFault(this.parseParameter(child));
                        ++i;
                        continue;
                    }
                    throw this.getNotAllowedTagException(child);
                }
                break block14;
lbl-1000:
                // 1 sources

                {
                    child = children[i];
                    if (this.isWsdlTag(child, "fault")) {
                        operation.addFault(this.parseParameter(child));
                        ++i;
                        continue;
                    }
                    throw this.getNotAllowedTagException(child);
lbl75:
                    // 2 sources

                    ** while (i < children.length)
                }
lbl76:
                // 1 sources

                break block14;
            }
            throw this.getNotAllowedTagException(child);
        }
        return operation;
    }

    protected WsdlPart parsePart(XElement element) {
        WsdlPart part = new WsdlPart();
        List attributes = element.getAttributes();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            XAttribute attribute = (XAttribute)iter.next();
            if (attribute.getLocalName().equals("name")) {
                part.setName(attribute.getValue());
                continue;
            }
            if (attribute.getLocalName().equals("element")) {
                part.setElement(new XsdQName(attribute.getValue(), element));
                continue;
            }
            if (!attribute.getLocalName().equals("type")) continue;
            part.setType(new XsdQName(attribute.getValue(), element));
        }
        return part;
    }

    protected XsdQName getMessageName(String name, XElement element) {
        XNamespace ns2;
        String localName;
        String prefix = null;
        XNamespace ns = null;
        int index = name.indexOf(":");
        if (index != -1) {
            prefix = name.substring(0, index);
            ns = element.getNamespace(prefix);
            localName = name.substring(index + 1);
        } else {
            localName = name;
        }
        int indexIFR = localName.indexOf(".");
        if (indexIFR != -1 && (ns2 = element.getNamespace(prefix = localName.substring(0, indexIFR))) != null) {
            ns = ns2;
            localName = localName.substring(indexIFR + 1);
        }
        String namespace = null;
        if (ns != null) {
            namespace = ns.getURI();
        }
        return new XsdQName(localName, namespace);
    }

    protected WsdlParameter parseParameter(XElement element) throws ProxyGenerationException {
        XElement child;
        WsdlParameter parameter = new WsdlParameter();
        List attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.size()) {
            XAttribute attribute = (XAttribute)attributes.get(i);
            if (attribute.getLocalName().equals("name")) {
                parameter.setName(attribute.getValue());
            } else if (attribute.getLocalName().equals("message")) {
                parameter.setMessage(this.getMessageName(attribute.getValue(), element));
            }
            ++i;
        }
        if (parameter.getMessage() == null) {
            throw this.getNeededAttributeException("message", element);
        }
        int i2 = 0;
        XElement[] children = element.getSubElements();
        if (i2 < children.length && this.isWsdlTag(child = children[i2], "documentation")) {
            this.parseDocumentation(child);
            ++i2;
        }
        if (i2 < children.length) {
            child = children[i2];
            ++i2;
            throw this.getNotAllowedTagException(child);
        }
        return parameter;
    }

    protected boolean isTopLevelExtension(XElement element) {
        return !this.isWsdlNamespace(element);
    }

    protected boolean isWsdlTag(XElement element, String name) {
        return element.getLocalName().equals(name) && this.isWsdlNamespace(element);
    }

    protected boolean isWsdlTag(XElement element) {
        return this.isWsdlNamespace(element);
    }

    private String getPath(XElement element) {
        String path = "<" + element.getLocalName() + ">";
        XElement parent = element.getParent();
        if (parent == null) {
            return path;
        }
        return this.getPath(parent) + path;
    }

    private ProxyGenerationException getNotAllowedAttributeException(XAttribute attribute, XElement element) {
        Object[] args = new Object[]{attribute.getQualifiedName(), this.getPath(element)};
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NEEDED_ATTRIBUTE, args);
    }

    private ProxyGenerationException getNeededAttributeException(String attributeName, XElement element) {
        Object[] args = new Object[]{attributeName, this.getPath(element)};
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NOT_ALLOWED_ATTRIBUTE, args);
    }

    private ProxyGenerationException getNotAllowedTagException(XElement element) {
        Object[] args = new Object[]{element.getQualifiedName(), this.getPath(element)};
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NOT_ALLOWED_TAG, args);
    }

    private ProxyGenerationException getNotAllowedRootException(XElement element) {
        Object[] args = new Object[]{element.getQualifiedName(), new XElementImpl("definitions", "http://schemas.xmlsoap.org/wsdl/").getQualifiedName()};
        return new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NOT_ALLOWED_ROOT, args);
    }

    private ProxyGenerationException getXsdException(XsdException exception, XElement element) {
        Object[] args = new Object[]{this.getPath(element)};
        return new ProxyGenerationException(MessageId.ERROR_IN_SCHEMA, args, (Throwable)exception);
    }
}

