/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.MessageId;
import com.sap.aii.proxy.generation.core.WsdlBinding;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlOperation;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdFacet;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSchema;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

public class Wsdl {
    protected String name;
    protected String documentation;
    protected String targetNamespace;
    protected Hashtable types = new Hashtable();
    protected Hashtable elements = new Hashtable();
    protected Hashtable attributes = new Hashtable();
    protected Hashtable attributeGroups = new Hashtable();
    protected Hashtable groups = new Hashtable();
    protected List schemas = new ArrayList();
    protected List portTypes = new ArrayList();
    protected List messages = new ArrayList();
    protected Set faults = new HashSet();
    protected List bindings = new ArrayList();
    protected List services = new ArrayList();
    protected List imports = new ArrayList();
    protected List extentions = new ArrayList();
    private static final String RFC = "rfc";

    Wsdl() {
    }

    boolean isRfc() {
        boolean isRfc = false;
        int i = 0;
        while (i < this.bindings.size() && !isRfc) {
            WsdlBinding binding = (WsdlBinding)this.bindings.get(i);
            List extentions = binding.getExtentions();
            int j = 0;
            while (j < extentions.size() && !isRfc) {
                XElement element = (XElement)extentions.get(j);
                isRfc = "urn:sap-com:document:sap:rfc:functions".equals(element.getNamespace().getURI()) && RFC.equals(element.getAttributeValue("style"));
                ++j;
            }
            ++i;
        }
        return isRfc;
    }

    Hashtable addType(XsdTypeDef type) {
        this.types.put(type.getQName(), type);
        return this.types;
    }

    XsdTypeDef getType(XsdQName type) {
        return (XsdTypeDef)this.types.get(type);
    }

    Hashtable addType(Hashtable types) {
        this.types.putAll(types);
        return this.types;
    }

    public Hashtable getTypes() {
        return this.types;
    }

    List addSchema(XsdSchema schema) {
        this.schemas.add(schema);
        return this.schemas;
    }

    List getSchemas() {
        return this.schemas;
    }

    Hashtable addElement(XsdElement element) {
        this.elements.put(element.getQName(), element);
        return this.elements;
    }

    Hashtable addAttribute(XsdAttribute attribute) {
        this.attributes.put(attribute.getQName(), attribute);
        return this.attributes;
    }

    public Hashtable getElements() {
        return this.elements;
    }

    XsdElement getElement(XsdQName qname) throws ProxyGenerationException {
        XsdElement element = (XsdElement)this.elements.get(qname);
        if (element == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_ELEM, new Object[]{qname.toString()});
        }
        return element;
    }

    XsdAttribute getAttribute(XsdQName qname) throws ProxyGenerationException {
        XsdAttribute attribute = (XsdAttribute)this.attributes.get(qname);
        if (attribute == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_ELEM, new Object[]{qname.toString()});
        }
        return attribute;
    }

    Hashtable addAttributeGroup(XsdAttributeGroup attGroup) {
        this.attributeGroups.put(attGroup.getQName(), attGroup);
        return this.attributeGroups;
    }

    public Hashtable getAttributeGroups() {
        return this.attributeGroups;
    }

    XsdAttributeGroup getAttributeGroup(XsdQName qname) throws ProxyGenerationException {
        XsdAttributeGroup attGr = (XsdAttributeGroup)this.attributeGroups.get(qname);
        if (attGr == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_ATT_GR, new Object[]{qname.toString()});
        }
        return attGr;
    }

    Hashtable addGroup(XsdParticle group) {
        this.groups.put(group.getQName(), group);
        return this.groups;
    }

    public Hashtable getGroups() {
        return this.groups;
    }

    XsdParticle getGroup(XsdQName qname) throws ProxyGenerationException {
        XsdParticle group = (XsdParticle)this.groups.get(qname);
        if (group == null) {
            throw new ProxyGenerationException((ProxyGenerationException.MessageId)MessageId.NO_GLOBAL_GROUP, new Object[]{qname.toString()});
        }
        return group;
    }

    void setName(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    String getTargetNamespace() {
        return this.targetNamespace;
    }

    void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    String getDocumentation() {
        return this.documentation;
    }

    List addPortType(WsdlPortType portType) {
        this.portTypes.add(portType);
        List operations = portType.getOperations();
        int i = 0;
        while (i < operations.size()) {
            WsdlOperation operation = (WsdlOperation)operations.get(i);
            List faults = operation.getFaults();
            int j = 0;
            while (j < faults.size()) {
                this.faults.add(faults.get(j));
                ++j;
            }
            ++i;
        }
        return this.portTypes;
    }

    public List getPortTypes() {
        return this.portTypes;
    }

    public WsdlPortType getPortType(XsdQName name) {
        int i = 0;
        while (i < this.portTypes.size()) {
            WsdlPortType portType = (WsdlPortType)this.portTypes.get(i);
            if (portType.getQName().equals((Object)name)) {
                return portType;
            }
            ++i;
        }
        return null;
    }

    List addBinding(WsdlBinding binding) {
        this.bindings.add(binding);
        return this.bindings;
    }

    List getBindings() {
        return this.bindings;
    }

    List addService(XElement service) {
        this.services.add(service);
        return this.services;
    }

    List addImport(XElement _import) {
        this.imports.add(_import);
        return this.imports;
    }

    List getImports() {
        return this.imports;
    }

    List addExtention(XElement extention) {
        this.extentions.add(extention);
        return this.extentions;
    }

    List getExtentions() {
        return this.extentions;
    }

    List getServices() {
        return this.services;
    }

    List addMessage(WsdlMessage message) {
        this.messages.add(message);
        return this.messages;
    }

    public List getMessages() {
        return this.messages;
    }

    public WsdlMessage getMessage(XsdQName name) {
        int i = 0;
        while (i < this.messages.size()) {
            WsdlMessage message = (WsdlMessage)this.messages.get(i);
            if (message.getQName().equals((Object)name)) {
                return message;
            }
            ++i;
        }
        return null;
    }

    public Set getFaults() {
        return this.faults;
    }

    public static final boolean isEnumType(XsdSimpleType sType) {
        XsdRestriction restriction = sType.getRestriction();
        if (restriction == null) {
            return false;
        }
        List facets = restriction.getFacets();
        if (facets.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < facets.size()) {
            XsdFacet facet = (XsdFacet)facets.get(i);
            if ("enumeration".equals(facet.getFacetName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

