/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.Comments;
import com.sap.aii.proxy.generation.core.GeneratorBasics;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GenericConstructor;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericOuterClass;
import com.sap.aii.proxy.generation.core.GenericOuterInterface;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.ProxyTypes;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.util.xsd.api.XsdAnnotation;

abstract class SimpleClassGenerator
extends GeneratorBasics {
    SimpleClassGenerator(GlobalNameMapping globalNames, Wsdl wsdl, SapBinding binding, boolean isRfc) {
        super(globalNames, wsdl, binding, isRfc);
    }

    final void addConstructor() {
        GenericConstructor constructor = new GenericConstructor(this.getTypeClass().getName());
        constructor.addImplementation("super(staticDescriptor, staticGenerationInfo, " + this.getConnectionType() + ")" + CodingSegments.END_LINE);
        this.getTypeClass().addConstructor(constructor);
    }

    final GenericOuterClass initClass(String name, String packageName, ProxyTypes proxyType) {
        GenericOuterClass typeClass = null;
        if (proxyType == ProxyTypes.INBOUND_PROXY) {
            typeClass = new GenericOuterInterface(name, packageName);
            typeClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInbound");
        }
        if (proxyType == ProxyTypes.OUTBOUND_PROXY) {
            typeClass = new GenericOuterClass(name, packageName);
            typeClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxy");
        }
        if (proxyType == ProxyTypes.GLOBAL_ITEM) {
            typeClass = new GenericOuterClass(name, packageName);
            typeClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractType");
            typeClass.addInterface("java.io.Serializable");
            typeClass.addAttribute(ProxyHelper.getSerId(name));
        }
        if (proxyType == ProxyTypes.EXCEPTION) {
            typeClass = new GenericOuterClass(name, packageName);
            typeClass.setSuperClass("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            typeClass.addInterface("java.io.Serializable");
            typeClass.addAttribute(ProxyHelper.getSerId(name));
        }
        if (proxyType == ProxyTypes.GLOBAL_ITEM) {
            // empty if block
        }
        return typeClass;
    }

    private final GenericClass initClass(String name) {
        GenericInnerClass innerClass = new GenericInnerClass(name);
        innerClass.setStatic(true);
        innerClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractType");
        innerClass.addInterface("java.io.Serializable");
        innerClass.addAttribute(ProxyHelper.getSerId(name));
        return innerClass;
    }

    private final void addComment(XsdAnnotation annotation) {
        this.getTypeClass().addComment(Comments.getComment(annotation));
    }

    abstract GenericClass getTypeClass();
}

