/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.binding.sap.RfcElementProperties;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.binding.sap.SapOperation;
import com.sap.aii.proxy.generation.core.binding.sap.SapType;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class RfcHelper {
    private static final Logger sLogger = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$RfcHelper == null ? (class$com$sap$aii$proxy$generation$core$RfcHelper = RfcHelper.class$("com.sap.aii.proxy.generation.core.RfcHelper")) : class$com$sap$aii$proxy$generation$core$RfcHelper).getName());
    static final String ITEM = "item";
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$RfcHelper;

    private RfcHelper() {
    }

    static boolean isRfcTable(XsdElement element) {
        XsdTypeDef typeDef = element.getLocalTypeDef();
        if (typeDef == null) {
            return false;
        }
        if (typeDef instanceof XsdSimpleType) {
            return false;
        }
        XsdComplexType type = (XsdComplexType)typeDef;
        XsdParticle particle = type.getParticle();
        if (!particle.getKind().equals("sequence")) {
            return false;
        }
        List elements = particle.getElements();
        if (elements.size() != 1) {
            return false;
        }
        Object o = elements.get(0);
        if (!(o instanceof XsdElement)) {
            return false;
        }
        XsdElement item = (XsdElement)o;
        return item.getName().equals(ITEM) && item.getMaxOccurs() == -1;
    }

    static List getSortedJcoList(XsdParticle particle, boolean isRfc) {
        List elems = particle.getElements();
        if (!isRfc) {
            return elems;
        }
        ArrayList<XsdElement> elements = new ArrayList<XsdElement>();
        int i = elems.size();
        while (i > 0) {
            XsdElement element = (XsdElement)elems.get(i - 1);
            if (RfcHelper.isRfcTable(element)) {
                elements.add(element);
            } else {
                elements.add(0, element);
            }
            --i;
        }
        return elements;
    }

    static SapType getSapType(XsdQName name, SapBinding binding) {
        if (binding != null) {
            return binding.getType(name);
        }
        return null;
    }

    static String getAbapName(SapType sapType) {
        if (sapType != null) {
            return sapType.getAbapName();
        }
        return null;
    }

    static String getXml(SapType sapType) {
        if (sapType != null) {
            return sapType.getXml();
        }
        return null;
    }

    static int getLength1(SapType sapType) {
        if (sapType != null) {
            return sapType.getByteLength1();
        }
        return -1;
    }

    static int getLength2(SapType sapType) {
        if (sapType != null) {
            return sapType.getByteLength2();
        }
        return -1;
    }

    static int getLength4(SapType sapType) {
        if (sapType != null) {
            return sapType.getByteLength4();
        }
        return -1;
    }

    static RfcElementProperties getElementProperties(String name, Map elementProperties) {
        if (elementProperties != null) {
            return (RfcElementProperties)elementProperties.get(name);
        }
        return null;
    }

    static String getAbapName(RfcElementProperties element) {
        if (element != null) {
            return element.getAbapName();
        }
        return null;
    }

    static String getXml(RfcElementProperties element) {
        if (element != null) {
            return element.getXml();
        }
        return null;
    }

    static int getOffset1(RfcElementProperties element) {
        if (element != null) {
            return element.getOffset1();
        }
        return -1;
    }

    static int getOffset2(RfcElementProperties element) {
        if (element != null) {
            return element.getOffset2();
        }
        return -1;
    }

    static int getOffset4(RfcElementProperties element) {
        if (element != null) {
            return element.getOffset4();
        }
        return -1;
    }

    static int getLength1(RfcElementProperties element) {
        if (element != null) {
            return element.getByteLength1();
        }
        return -1;
    }

    static int getLength2(RfcElementProperties element) {
        if (element != null) {
            return element.getByteLength2();
        }
        return -1;
    }

    static int getLength4(RfcElementProperties element) {
        if (element != null) {
            return element.getByteLength4();
        }
        return -1;
    }

    static String getInternalType(RfcElementProperties element) {
        if (element != null) {
            return element.getInternalType();
        }
        return "-1";
    }

    static String getInternalType(SapType element) {
        if (element != null) {
            return element.getInternalType();
        }
        return "-1";
    }

    static String getDirection(RfcElementProperties element) {
        if (element != null) {
            return element.getDirection();
        }
        return "0";
    }

    static SapType getLineType(RfcElementProperties props, SapBinding binding) {
        XsdQName type;
        if (binding != null && props != null && (type = props.getComplexType()) != null) {
            return binding.getType(type);
        }
        return null;
    }

    static SapType getLineType(SapType props, SapBinding binding) {
        XsdQName type;
        if (binding != null && props != null && (type = props.getComplexType()) != null) {
            return binding.getType(type);
        }
        return null;
    }

    static SapOperation getOperationBinding(SapBinding binding, XsdQName elementName) {
        if (binding != null) {
            return binding.getOperation(elementName);
        }
        return null;
    }

    static SapOperation getParamsBinding(SapBinding binding) {
        if (binding != null) {
            return null;
        }
        return null;
    }

    static Map getElementProperties(SapType sapType) {
        if (sapType != null) {
            return sapType.getElements();
        }
        return null;
    }

    static Map getElementProperties(SapBinding binding, XsdQName elementName) {
        SapOperation operation;
        if (binding != null && (operation = binding.getOperation(elementName)) != null) {
            return operation.getParameters();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

