/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.AccessLevel;
import com.sap.aii.proxy.generation.core.AttributeMetadata;
import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.ElementMetadata;
import com.sap.aii.proxy.generation.core.GenericAttribute;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GenericConstructor;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericMethod;
import com.sap.aii.proxy.generation.core.InnerProxyTypeClass;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.binding.sap.SapType;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdQName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ProxyTypeClass
implements ProxyCodingSegments,
JavaTypes {
    private static final Logger LOG = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$ProxyTypeClass == null ? (class$com$sap$aii$proxy$generation$core$ProxyTypeClass = ProxyTypeClass.class$("com.sap.aii.proxy.generation.core.ProxyTypeClass")) : class$com$sap$aii$proxy$generation$core$ProxyTypeClass).getName());
    private ElementList elements;
    private AttributeList attributes;
    private Set innerTypes;
    private String javaName;
    private AccessLevel accessLevel = ProxyCodingSegments.PUBLIC;
    private XsdQName xsdName;
    private boolean addMetadataClass;
    private boolean isRfc = false;
    private String abapName;
    private String xml;
    private int bytelength1;
    private int bytelength2;
    private int bytelength4;
    private int offset1;
    private int offset2;
    private int offset4;
    private String connectionType = "com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_NONE";
    private String proxyType;
    private XsdQName base = null;
    private boolean isRestricted = false;
    private GenericInnerClass metadataClass;
    private GenericClass typeClass;
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$ProxyTypeClass;

    ProxyTypeClass(String javaName, XsdComplexType cType, String connectionType, SapType sapType) {
        this(javaName, cType.getQName(), connectionType, "com.sap.aii.proxy.framework.core.XsdlConstants.XSDL_COMPLEX_TYPE", sapType);
    }

    ProxyTypeClass(String javaName, WsdlMessage message, String connectionType, SapType sapType) {
        this(javaName, message.getQName(), connectionType, ProxyTypeClass.getProxyType(connectionType), sapType);
    }

    private static String getProxyType(String connectionType) {
        if ("com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_JCO".equals(connectionType)) {
            return "com.sap.aii.proxy.framework.core.XsdlConstants.WSDL_MESSAGE_FOR_JCO";
        }
        return "com.sap.aii.proxy.framework.core.XsdlConstants.XSDL_COMPLEX_TYPE";
    }

    private ProxyTypeClass(String javaName, XsdQName xsdName, String connectionType, String proxyType, SapType sapType) {
        this.elements = new ElementList();
        this.attributes = new AttributeList();
        this.innerTypes = new HashSet();
        this.javaName = javaName;
        this.xsdName = xsdName;
        this.proxyType = proxyType;
        this.connectionType = connectionType;
        this.setJco(sapType);
    }

    void setJco(SapType sapType) {
        if (sapType != null) {
            this.isRfc = true;
            this.abapName = sapType.getAbapName();
            this.xml = sapType.getXml();
            this.bytelength1 = sapType.getByteLength1();
            this.bytelength2 = sapType.getByteLength2();
            this.bytelength4 = sapType.getByteLength4();
        }
    }

    void addElement(ElementMetadata elementMetadata) {
        this.elements.add(elementMetadata);
    }

    void addAttribute(AttributeMetadata attributeMetadata) {
        this.attributes.add(attributeMetadata);
    }

    void addInnerType(InnerProxyTypeClass type) {
        this.innerTypes.add(type);
    }

    final ElementList getAllElements(Map types) {
        ProxyTypeClass baseType = this.getBaseType(types);
        ElementList list = new ElementList();
        if (baseType != null && !this.isRestricted) {
            list = baseType.getAllElements(types);
        }
        list.addAll(this.elements);
        return list;
    }

    private ProxyTypeClass getBaseType(Map types) {
        ProxyTypeClass baseType = null;
        if (this.base != null) {
            baseType = (ProxyTypeClass)types.get(this.base);
            if (baseType == null) {
                LOG.error("base type " + baseType + "is missing.");
            } else {
                this.typeClass.setSuperClass(baseType.getJavaName());
            }
        }
        return baseType;
    }

    final AttributeList getAllAttributes(Map types) {
        ProxyTypeClass baseType = this.getBaseType(types);
        AttributeList list = new AttributeList();
        if (baseType != null && !this.isRestricted) {
            list = baseType.getAllAttributes(types);
        }
        list.addAll(this.attributes);
        return list;
    }

    private String getStaticBlock(Map types) {
        ElementList elements = this.getAllElements(types);
        AttributeList attributes = this.getAllAttributes(types);
        StringBuffer txt = new StringBuffer();
        txt.append("com.sap.aii.proxy.framework.core.BaseTypeDescriptor").append(" ");
        txt.append("descriptor").append(" = ").append("createNewBaseTypeDescriptor(");
        txt.append(this.proxyType).append(", ");
        txt.append(ProxyHelper.getString(this.xsdName.getNamespaceUri())).append(", ");
        txt.append(ProxyHelper.getString(this.xsdName.getLocalName())).append(", ");
        txt.append(elements.size()).append(", ");
        txt.append(attributes.size()).append(", ");
        txt.append(this.getClassName()).append(".class").append(", ");
        txt.append(this.connectionType).append(", ");
        txt.append(ProxyHelper.getString(this.abapName)).append(", ");
        txt.append(this.bytelength1).append(", ");
        txt.append(this.bytelength2).append(", ");
        txt.append(this.bytelength4).append(", ");
        txt.append(ProxyHelper.getXmlString(this.xml)).append(")");
        txt.append(CodingSegments.END_LINE);
        int i = 0;
        while (i < attributes.size()) {
            AttributeMetadata metadata = attributes.get(i);
            txt.append((Object)metadata.getDescriptorLine(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < elements.size()) {
            ElementMetadata metadata = elements.get(i2);
            txt.append((Object)metadata.getDescriptorLine(i2));
            ++i2;
        }
        txt.append("staticDescriptor").append(" = ").append("descriptor");
        txt.append(CodingSegments.END_LINE);
        return txt.toString();
    }

    abstract String getClassName();

    void setAbapName(String abapName) {
        this.abapName = abapName;
    }

    void setBytelength1(int bytelength1) {
        this.bytelength1 = bytelength1;
    }

    void setBytelength2(int bytelength2) {
        this.bytelength2 = bytelength2;
    }

    void setBytelength4(int bytelength4) {
        this.bytelength4 = bytelength4;
    }

    void setXml(String xml) {
        this.xml = xml;
    }

    abstract GenericClass newClass(String var1);

    GenericClass getGenericClass(Map types) {
        LOG.finest("get Class");
        this.typeClass = this.newClass(this.javaName);
        this.typeClass.setAccessLevel(this.accessLevel);
        ProxyTypeClass baseType = null;
        if (this.base == null) {
            this.typeClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractType");
        } else {
            baseType = this.getBaseType(types);
            if (baseType == null) {
                LOG.error("base type " + baseType + "is missing.");
            } else {
                this.typeClass.setSuperClass(baseType.getJavaName());
            }
        }
        this.typeClass.setAccessLevel(this.accessLevel);
        this.addStaticTypeAttributes();
        this.addConstructors();
        this.typeClass.setStaticBlock(this.getStaticBlock(types));
        this.addMethods(this.typeClass, types);
        if (!this.innerTypes.isEmpty() && !this.isRestricted) {
            this.addInnerClasses(types);
        }
        this.addMetadataClass(this.typeClass, types);
        LOG.finest("return class");
        return this.typeClass;
    }

    private void addMethods(GenericClass type, Map types) {
        int start = this.getAllAttributes(types).size() - this.attributes.size();
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeMetadata metadata = this.attributes.get(i);
            metadata.addAccessMethods(type, start + i);
            ++i;
        }
        start = this.getAllElements(types).size() - this.elements.size();
        int i2 = 0;
        while (i2 < this.elements.size()) {
            ElementMetadata metadata = this.elements.get(i2);
            metadata.addAccessMethods(type, start + i2);
            ++i2;
        }
    }

    private void addStaticTypeAttributes() {
        this.typeClass.addAttribute(new GenericAttribute("staticDescriptor", "com.sap.aii.proxy.framework.core.BaseTypeDescriptor", ProxyCodingSegments.PRIVATE, true, true, null));
        this.typeClass.addAttribute(new GenericAttribute("staticGenerationInfo", "com.sap.aii.proxy.framework.core.GenerationInfo", ProxyCodingSegments.PRIVATE, true, true, ProxyHelper.getGenerationInfoInit()));
    }

    private final void addConstructors() {
        GenericConstructor constructor1 = new GenericConstructor(this.typeClass.getName());
        constructor1.addImport("descriptor", "com.sap.aii.proxy.framework.core.BaseTypeDescriptor");
        constructor1.addImport("staticGenerationInfo", "com.sap.aii.proxy.framework.core.GenerationInfo");
        constructor1.addImport("connectionType", "int");
        constructor1.setAccessLevel(ProxyCodingSegments.PROTECTED);
        constructor1.addImplementation("super(descriptor, staticGenerationInfo, connectionType);");
        this.typeClass.addConstructor(constructor1);
        GenericConstructor constructor2 = new GenericConstructor(this.typeClass.getName());
        constructor2.addImplementation("super(staticDescriptor, staticGenerationInfo, " + this.connectionType + ")" + CodingSegments.END_LINE);
        this.typeClass.addConstructor(constructor2);
    }

    void addMetadataClass(boolean addMetadataClass) {
        this.addMetadataClass = addMetadataClass;
    }

    void addInnerType(GenericInnerClass innerClass) {
        this.innerTypes.add(innerClass);
    }

    private void addInnerClasses(Map types) {
        LOG.info("add inner classes " + this.innerTypes.size());
        Iterator i = this.innerTypes.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof GenericInnerClass) {
                LOG.info("add inner classes ");
                this.typeClass.addInnerClass((GenericInnerClass)o);
            }
            if (!(o instanceof InnerProxyTypeClass)) continue;
            LOG.info("add inner proxy classes ");
            this.typeClass.addInnerClass((GenericInnerClass)((InnerProxyTypeClass)o).getGenericClass(types));
        }
    }

    final void setAccessLevel(AccessLevel accessLevel) {
        this.accessLevel = accessLevel;
    }

    void addMetadataClass(GenericClass typcClass, Map types) {
        String initMetaData = "new MetaData(this)";
        typcClass.addAttribute(new GenericAttribute("metadata", typcClass.getName() + "." + "MetaData", ProxyCodingSegments.PRIVATE, false, false, initMetaData));
        String base = this.typeClass.getSuperClass();
        GenericInnerClass metadataClass = ProxyTypeClass.getMetadataClass(typcClass, typcClass.getName(), base, this.isRfc);
        metadataClass.addInterface("java.io.Serializable");
        metadataClass.addAttribute(ProxyHelper.getSerId("MetaData"));
        this.addMetaDataMethods(metadataClass, types);
        this.typeClass.addInnerClass(metadataClass);
    }

    private void addMetaDataMethods(GenericInnerClass metadataClass, Map types) {
        int start = this.getAllAttributes(types).size() - this.attributes.size();
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeMetadata metadata = this.attributes.get(i);
            metadata.addMetadataMehod(metadataClass, start + i);
            ++i;
        }
        start = this.getAllElements(types).size() - this.elements.size();
        int i2 = 0;
        while (i2 < this.elements.size()) {
            ElementMetadata metadata = this.elements.get(i2);
            metadata.addMetadataMehod(metadataClass, start + i2);
            ++i2;
        }
    }

    String getJavaName() {
        return this.javaName;
    }

    final void setBase(XsdQName base) {
        this.base = base;
    }

    private static GenericInnerClass getMetadataClass(GenericClass outerClass, String typeName, String base, boolean isRfc) {
        GenericInnerClass metaDataClass = new GenericInnerClass("MetaData");
        if (base != null && !base.equals("com.sap.aii.proxy.framework.core.AbstractType")) {
            metaDataClass.setSuperClass(base + "." + "MetaData");
        }
        GenericMethod getMetadata = !isRfc ? new GenericMethod("metadata" + typeName) : new GenericMethod("metadata");
        getMetadata.setExport("MetaData");
        getMetadata.addImplementation("return metadata" + CodingSegments.END_LINE);
        outerClass.addMethod(getMetadata);
        metaDataClass.setStatic(true);
        metaDataClass.addAttribute(new GenericAttribute("parent", typeName, ProxyCodingSegments.PRIVATE, false, false, null));
        GenericConstructor metadataConstructor = new GenericConstructor("MetaData");
        metadataConstructor.addImport("parent", typeName);
        metadataConstructor.setAccessLevel(ProxyCodingSegments.PROTECTED);
        if (base != null && !base.equals("com.sap.aii.proxy.framework.core.AbstractType")) {
            metadataConstructor.setImplementation("super(parent)" + CodingSegments.END_LINE + "this." + "parent" + " = " + "parent" + CodingSegments.END_LINE);
        } else {
            metadataConstructor.setImplementation("this.parent = parent" + CodingSegments.END_LINE);
        }
        metaDataClass.addConstructor(metadataConstructor);
        GenericMethod typeMetadata = new GenericMethod("typeMetadata");
        typeMetadata.setExport("com.sap.aii.proxy.framework.core.TypeMetaData");
        typeMetadata.setImplementation("return (com.sap.aii.proxy.framework.core.TypeMetaData)parent.baseTypeMetaData();");
        metaDataClass.addMethod(typeMetadata);
        outerClass.addInnerClass(metaDataClass);
        return metaDataClass;
    }

    final void setIsRestricted(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ElementList {
        private List list = new ArrayList();

        private ElementList() {
        }

        void add(ElementMetadata element) {
            this.list.add(element);
        }

        int size() {
            return this.list.size();
        }

        ElementMetadata get(int i) {
            return (ElementMetadata)this.list.get(i);
        }

        void addAll(ElementList elements) {
            this.list.addAll(elements.list);
        }
    }

    private class AttributeList {
        private List list = new ArrayList();

        private AttributeList() {
        }

        void add(AttributeMetadata attribute) {
            this.list.add(attribute);
        }

        int size() {
            return this.list.size();
        }

        AttributeMetadata get(int i) {
            return (AttributeMetadata)this.list.get(i);
        }

        void addAll(AttributeList attributes) {
            this.list.addAll(attributes.list);
        }
    }
}

