/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.Comments;
import com.sap.aii.proxy.generation.core.GenericAttribute;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GenericConstructor;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericMethod;
import com.sap.aii.proxy.generation.core.GenericOuterClass;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.RfcHelper;
import com.sap.aii.proxy.generation.core.binding.sap.SapType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdRestriction;

final class ProxyTableClass
implements ProxyCodingSegments,
JavaTypes {
    private GenericClass tableClass;
    private String name;
    private String lineType;
    private String itemJavaType;
    private String itemTypeClass;
    private String elementProperties;
    private String comment;
    private boolean isGlobal;
    private boolean isRfc;
    private String connectionType;
    private String fullName;
    private String packageName;

    ProxyTableClass(String itemJavaType, String itemTypeClass, String elementTypeName, String name, XsdElement element, boolean isGlobal, String connectionType, boolean isEnum) {
        this(itemJavaType, itemTypeClass, elementTypeName, name, Comments.getComment(element), isGlobal, false, connectionType, null);
        this.elementProperties = ProxyTableClass.getElementProperties(element.getName(), name, itemJavaType, element.getDefault(), element.getFixed(), element.getForm(), ProxyHelper.getXsdlType(element), element.getNamespace().getURI(), element.isAbstract(), element.getMinOccurs(), element.getMaxOccurs(), ProxyHelper.isNillable(element), ProxyHelper.getSubstitutionGroup(element), ProxyHelper.getRestriction(element), null, isEnum);
        this.addContent();
    }

    ProxyTableClass(String itemJavaType, String itemTypeClass, String elementTypeName, String name, String elementProperties, String comment, boolean isGlobal, boolean isRfc, String connectionType, String pkg) {
        this(itemJavaType, itemTypeClass, elementTypeName, name, comment, isGlobal, isRfc, connectionType, pkg);
        this.elementProperties = elementProperties;
        String itemClassName = itemTypeClass.substring(itemTypeClass.lastIndexOf(".") + 1);
        this.addContent();
    }

    ProxyTableClass() {
    }

    private ProxyTableClass(String itemJavaType, String itemTypeClass, String elementTypeName, String name, String comment, boolean isGlobal, boolean isRfc, String connectionType, String pkg) {
        String itemClassName;
        this.itemJavaType = itemJavaType;
        this.itemTypeClass = itemTypeClass;
        this.comment = comment;
        this.isGlobal = isGlobal;
        this.isRfc = isRfc;
        this.connectionType = connectionType;
        this.name = isGlobal && isRfc ? (itemClassName = itemTypeClass.substring(itemTypeClass.lastIndexOf(".") + 1)) : ProxyHelper.getUpName(name);
        this.packageName = ProxyTableClass.getTablePackage(isGlobal, elementTypeName, itemTypeClass, pkg);
        this.fullName = this.packageName != null ? this.packageName + "." + this.name + "_List" : this.name + "_List";
    }

    private static String getTablePackage(boolean isGlobal, String fullJavaElementType, String fullJavaLineType, String pkg) {
        String packageBase = null;
        packageBase = isGlobal ? fullJavaLineType : fullJavaElementType;
        int index = packageBase.lastIndexOf(46);
        if (index == -1) {
            if (ProxyHelper.isBuildInType(fullJavaLineType)) {
                return pkg + ".util";
            }
            return null;
        }
        if (isGlobal) {
            return packageBase.substring(0, index) + ".util";
        }
        return packageBase.substring(0, index);
    }

    static String getElementProperties(String wsdlName, String javaName, String javaType, String defaultValue, String fixedValue, String form, String xsdlType, String namespace, boolean isAbstract, int min, int max, boolean isNillable, String substitutionGroup, XsdRestriction facets, SapType sapElement, boolean isEnum) {
        StringBuffer text = new StringBuffer();
        text.append("createElementProperties(");
        text.append(ProxyHelper.getString(wsdlName)).append(", ");
        text.append(ProxyHelper.getString(defaultValue)).append(", ");
        text.append(ProxyHelper.getString(fixedValue)).append(", ");
        text.append(ProxyHelper.getString(form)).append(", ");
        text.append(ProxyHelper.getString(xsdlType)).append(", ");
        text.append(ProxyHelper.getString(namespace)).append(", ");
        text.append(isAbstract).append(", ").append(min);
        text.append(", ").append(max);
        text.append(", ").append(isNillable).append(", ");
        text.append(ProxyHelper.getString(substitutionGroup)).append(", ");
        text.append(ProxyHelper.getString(javaName)).append(", ");
        text.append(ProxyHelper.writeType(javaType)).append(", ");
        if (isEnum) {
            text.append("null").append(", ");
        } else {
            text.append(ProxyHelper.getNewInstance(javaType)).append(", ");
        }
        text.append(ProxyHelper.getRestrictions(facets)).append(", ");
        text.append(RfcHelper.getLength1(sapElement)).append(", ");
        text.append(RfcHelper.getLength2(sapElement)).append(", ");
        text.append(RfcHelper.getLength4(sapElement)).append(", ");
        text.append(RfcHelper.getInternalType(sapElement)).append(", ");
        text.append(ProxyHelper.getXmlString(RfcHelper.getXml(sapElement)));
        text.append(")");
        return text.toString();
    }

    private void addContent() {
        String itemClassName = this.itemTypeClass.substring(this.itemTypeClass.lastIndexOf(".") + 1);
        if (this.isGlobal && this.isRfc) {
            this.tableClass = new GenericOuterClass(itemClassName + "_List", this.packageName);
            this.addTableMethods(itemClassName);
        } else {
            GenericInnerClass table = new GenericInnerClass(this.name + "_List");
            table.setStatic(true);
            this.tableClass = table;
            if (this.isRfc) {
                this.addTableMethods(itemClassName);
            } else {
                this.addTableMethods(ProxyHelper.getUpName(this.name));
            }
        }
        this.tableClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractList");
        this.tableClass.addInterface("java.util.List");
        this.tableClass.addInterface("java.io.Serializable");
        this.tableClass.addAttribute(ProxyHelper.getSerId(this.name));
        this.tableClass.addAttribute(new GenericAttribute("staticElementProperties", "com.sap.aii.proxy.framework.core.XsdlElementProperties", ProxyCodingSegments.PRIVATE, true, true, this.elementProperties));
        this.lineType = this.itemTypeClass;
        this.name = this.isGlobal && this.isRfc ? ((GenericOuterClass)this.tableClass).getPackage() + "." + this.tableClass.getName() : this.tableClass.getName();
    }

    String getLineType() {
        return this.lineType;
    }

    String getName() {
        return this.name;
    }

    GenericClass getTableClass() {
        return this.tableClass;
    }

    private void addTableMethods(String itemName) {
        GenericConstructor constructor = new GenericConstructor(this.tableClass.getName());
        constructor.setImplementation("super(staticElementProperties, " + this.connectionType + ")" + CodingSegments.END_LINE);
        this.tableClass.addConstructor(constructor);
        GenericMethod add = new GenericMethod(ProxyTableClass.getMethodName("add", itemName));
        add.addImport("item", this.itemTypeClass);
        add.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("add", this.itemTypeClass), new String[]{"item"}, null, false, false));
        this.tableClass.addMethod(add);
        GenericMethod addIndex = new GenericMethod(ProxyTableClass.getMethodName("add", itemName));
        addIndex.addImport("index", "int");
        addIndex.addImport("item", this.itemTypeClass);
        addIndex.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("add", this.itemTypeClass), new String[]{"index", "item"}, null, false, false));
        this.tableClass.addMethod(addIndex);
        GenericMethod addAll = new GenericMethod(ProxyTableClass.getMethodName("addAll", itemName));
        addAll.addImport("item", this.tableClass.getName());
        addAll.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("addAll", this.tableClass.getName()), new String[]{"item"}, null, false, false));
        this.tableClass.addMethod(addAll);
        GenericMethod addAllIndex = new GenericMethod(ProxyTableClass.getMethodName("addAll", itemName));
        addAllIndex.addImport("index", "int");
        addAllIndex.addImport("item", this.tableClass.getName());
        addAllIndex.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("addAll", this.tableClass.getName()), new String[]{"index", "item"}, null, false, false));
        this.tableClass.addMethod(addAllIndex);
        GenericMethod contains = new GenericMethod(ProxyTableClass.getMethodName("contains", itemName));
        contains.addImport("item", this.itemTypeClass);
        contains.setExport("boolean");
        contains.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("contains", this.itemTypeClass), new String[]{"item"}, "boolean", false, false));
        this.tableClass.addMethod(contains);
        GenericMethod containsAll = new GenericMethod(ProxyTableClass.getMethodName("containsAll", itemName));
        containsAll.addImport("item", this.tableClass.getName());
        containsAll.setExport("boolean");
        containsAll.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("containsAll", this.tableClass.getName()), new String[]{"item"}, "boolean", false, false));
        this.tableClass.addMethod(containsAll);
        GenericMethod get = new GenericMethod(ProxyTableClass.getMethodName("get", itemName));
        get.setExport(this.itemTypeClass);
        get.addImport("index", "int");
        get.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("get", this.itemTypeClass), new String[]{"index"}, this.itemTypeClass, true, false));
        this.tableClass.addMethod(get);
        GenericMethod indexOf = new GenericMethod(ProxyTableClass.getMethodName("indexOf", itemName));
        indexOf.addImport("item", this.itemTypeClass);
        indexOf.setExport("int");
        indexOf.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("indexOf", this.itemTypeClass), new String[]{"item"}, "int", false, false));
        this.tableClass.addMethod(indexOf);
        GenericMethod lastIndexOf = new GenericMethod(ProxyTableClass.getMethodName("lastIndexOf", itemName));
        lastIndexOf.addImport("item", this.itemTypeClass);
        lastIndexOf.setExport("int");
        lastIndexOf.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("lastIndexOf", this.itemTypeClass), new String[]{"item"}, "int", false, false));
        this.tableClass.addMethod(lastIndexOf);
        GenericMethod remove = new GenericMethod(ProxyTableClass.getMethodName("remove", itemName));
        remove.setExport(this.itemTypeClass);
        remove.addImport("index", "int");
        remove.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("remove", this.itemTypeClass, true), new String[]{"index"}, this.itemTypeClass, true, false));
        this.tableClass.addMethod(remove);
        GenericMethod removeItem = new GenericMethod(ProxyTableClass.getMethodName("remove", itemName));
        removeItem.setExport("boolean");
        removeItem.addImport("item", this.itemTypeClass);
        removeItem.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("remove", this.itemTypeClass), new String[]{"item"}, "boolean", false, false));
        this.tableClass.addMethod(removeItem);
        GenericMethod set = new GenericMethod(ProxyTableClass.getMethodName("set", itemName));
        set.setExport(this.itemTypeClass);
        set.addImport("index", "int");
        set.addImport("item", this.itemTypeClass);
        set.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("set", this.itemTypeClass), new String[]{"index", "item"}, this.itemTypeClass, true, false));
        this.tableClass.addMethod(set);
        GenericMethod subList = new GenericMethod(ProxyTableClass.getMethodName("subList", itemName));
        subList.setExport(this.tableClass.getName());
        subList.addImport("fromIndex", "int");
        subList.addImport("toIndex", "int");
        subList.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("subList", this.tableClass.getName()), new String[]{"fromIndex", "toIndex"}, this.tableClass.getName(), true, false));
        this.tableClass.addMethod(subList);
        GenericMethod toArray = new GenericMethod(ProxyTableClass.getMethodName("toArray", itemName));
        toArray.setExport(this.itemTypeClass + "[]");
        toArray.setImplementation(ProxyTableClass.addTableMethodImpl(ProxyTableClass.getMethod("toArray", this.itemTypeClass), new String[0], this.itemTypeClass, true, true));
        this.tableClass.addMethod(toArray);
    }

    private static String getMethodType(String type) {
        if (type.equals("byte[]")) {
            return "byteArray";
        }
        if ("java.lang.String[]".endsWith(type)) {
            return "java.lang.StringArray";
        }
        return type;
    }

    private static String getMethod(String name, String type) {
        return ProxyTableClass.getMethod(name, type, false);
    }

    private static String getMethodName(String name, String type) {
        return ProxyTableClass.getMethodName(name, type, false);
    }

    private static String getMethodName(String name, String type, boolean removeAt) {
        StringBuffer text = new StringBuffer(name);
        if (type.equals("int")) {
            text.append("AsInt");
            if (removeAt) {
                text.append("At");
            }
        } else if (type.equals("boolean")) {
            text.append("AsBoolean");
        } else if (type.equals("short")) {
            text.append("AsShort");
        } else if (type.equals("byte")) {
            text.append("AsByte");
        } else if (type.equals("float")) {
            text.append("AsFloat");
        } else if (type.equals("double")) {
            text.append("AsDouble");
        } else {
            type = ProxyTableClass.getMethodType(type);
            text.append(type);
        }
        return text.toString();
    }

    private static String getMethod(String name, String type, boolean removeAt) {
        StringBuffer text = new StringBuffer(name);
        if (type.equals("int")) {
            text.append(ProxyTableClass.getMethod("AsInt", removeAt));
        } else if (type.equals("boolean")) {
            text.append(ProxyTableClass.getMethod("AsBoolean", removeAt));
        } else if (type.equals("short")) {
            text.append(ProxyTableClass.getMethod("AsShort", removeAt));
        } else if (type.equals("byte")) {
            text.append(ProxyTableClass.getMethod("AsByte", removeAt));
        } else if (type.equals("float")) {
            text.append(ProxyTableClass.getMethod("AsFloat", removeAt));
        } else if (type.equals("double")) {
            text.append(ProxyTableClass.getMethod("AsDouble", removeAt));
        }
        return text.toString();
    }

    private static String getMethod(String name, boolean removeAt) {
        if (removeAt) {
            return name + "At";
        }
        return name;
    }

    private static String addTableMethodImpl(String methodName, String[] inParameter, String returnType, boolean _cast, boolean isArray) {
        StringBuffer text = new StringBuffer();
        if (returnType != null) {
            text.append("return ");
        }
        if (_cast && !ProxyHelper.isPrimitive(returnType)) {
            text.append("(");
            text.append(returnType);
            if (isArray) {
                text.append("[]");
            }
            text.append(")");
        }
        text.append("baseList()");
        text.append(".");
        text.append(methodName);
        text.append("(");
        int i = 0;
        while (i < inParameter.length) {
            if (i > 0) {
                text.append(", ");
            }
            text.append(inParameter[i]);
            ++i;
        }
        if (_cast && !ProxyHelper.isPrimitive(returnType) && isArray) {
            text.append("new ");
            text.append(returnType);
            text.append("[]");
            text.append(" ");
            text.append("{");
            text.append("}");
        }
        text.append(")");
        text.append(CodingSegments.END_LINE);
        return text.toString();
    }

    public String getFullName() {
        return this.fullName;
    }
}

