/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.GenericAttribute;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.util.Util;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdAll;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdFacet;
import com.sap.aii.util.xsd.api.XsdGroup;
import com.sap.aii.util.xsd.api.XsdNode;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSchema;
import com.sap.aii.util.xsd.api.XsdSequence;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public final class ProxyHelper
implements ProxyCodingSegments,
JavaTypes {
    private static final Logger sLogger = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$RfcHelper == null ? (class$com$sap$aii$proxy$generation$core$RfcHelper = ProxyHelper.class$("com.sap.aii.proxy.generation.core.RfcHelper")) : class$com$sap$aii$proxy$generation$core$RfcHelper).getName());
    private static final String VERSION = "2.0";
    private static final String JAVA_ENDING = ".java";
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$RfcHelper;

    private ProxyHelper() {
    }

    static final String getSubstitutionGroup(XsdElement element) {
        XsdQName subGroup = element.getSubstitutionGroup();
        if (subGroup == null) {
            return null;
        }
        return subGroup.toString();
    }

    static final boolean isNillable(XsdElement element) {
        return element.isNillable();
    }

    static final boolean isBuildInType(String typeName) {
        if (typeName == null) {
            return false;
        }
        return typeName.equals("java.lang.String") || typeName.equals("int") || typeName.equals("long") || typeName.equals("float") || typeName.equals("byte") || typeName.equals("short") || typeName.equals("boolean") || typeName.equals("double") || typeName.equals("java.sql.Date") || typeName.equals("java.math.BigInteger") || typeName.equals("java.math.BigDecimal") || typeName.equals("java.sql.Time") || typeName.equals("byte[]") || typeName.equals("java.lang.String[]") || typeName.equals("java.util.Calendar");
    }

    static final boolean isPrimitive(String typeName) {
        if (typeName == null) {
            return false;
        }
        return typeName.equals("int") || typeName.equals("float") || typeName.equals("byte") || typeName.equals("short") || typeName.equals("boolean") || typeName.equals("double");
    }

    static final String getXmlString(String xml) {
        String value = ProxyHelper.getString(xml);
        return value;
    }

    static final String getString(String value) {
        if (value == null) {
            return "null";
        }
        StringBuffer text = new StringBuffer("\"");
        int i = 0;
        while (i < value.length()) {
            char letter = value.charAt(i);
            if (letter == '\"' || letter == '\\') {
                text.append("\\");
                text.append(letter);
            } else if (letter == '\n') {
                text.append('\\');
                text.append('n');
            } else {
                text.append(letter);
            }
            ++i;
        }
        text.append("\"");
        return text.toString();
    }

    static final XsdQName getXsdlTypeQName(XsdElement element) {
        XsdQName type = element.getGlobalTypeName();
        if (type == null) {
            XsdTypeDef def = element.getLocalTypeDef();
            if (def instanceof XsdSimpleType) {
                XsdSimpleType sType = (XsdSimpleType)def;
                return sType.getRestrictionBaseTypeRef();
            }
            return null;
        }
        return type;
    }

    static final XsdRestriction getRestriction(XsdElement element) {
        XsdQName name = element.getGlobalTypeName();
        if (name != null) {
            return null;
        }
        XsdTypeDef type = element.getLocalTypeDef();
        if (type instanceof XsdSimpleType) {
            return ((XsdSimpleType)type).getRestriction();
        }
        if (type instanceof XsdComplexType) {
            return null;
        }
        return null;
    }

    static final XsdRestriction getRestriction(XsdAttribute attribute) {
        XsdQName name = attribute.getGlobalTypeName();
        if (name != null) {
            return null;
        }
        XsdTypeDef type = attribute.getLocalTypeDef();
        return ((XsdSimpleType)type).getRestriction();
    }

    static final String writeType(String type) {
        if (type.equals("int")) {
            return "java.lang.Integer.class";
        }
        if (type.equals("float")) {
            return "java.lang.Float.class";
        }
        if (type.equals("byte")) {
            return "java.lang.Byte.class";
        }
        if (type.equals("short")) {
            return "java.lang.Short.class";
        }
        if (type.equals("boolean")) {
            return "java.lang.Boolean.class";
        }
        if (type.equals("double")) {
            return "java.lang.Double.class";
        }
        if (type.equals("long")) {
            return "java.lang.Long.class";
        }
        return type + ".class";
    }

    static final String getNewInstance(String type) {
        StringBuffer text = new StringBuffer();
        if (type == null || ProxyHelper.isBuildInType(type) || type.endsWith("_List")) {
            text.append("null");
        } else {
            text.append("new ");
            text.append(type);
            text.append("()");
        }
        return text.toString();
    }

    static final String getRestrictions(XsdRestriction restriction) {
        StringBuffer text = new StringBuffer();
        text.append("new ");
        text.append("java.lang.String");
        text.append("[]");
        text.append("[]");
        text.append("{");
        if (restriction != null) {
            List facets = restriction.getFacets();
            int i = 0;
            while (i < facets.size()) {
                if (i != 0) {
                    text.append(", ");
                }
                XsdFacet facet = (XsdFacet)facets.get(i);
                text.append("{");
                text.append(ProxyHelper.getString(facet.getFacetName()));
                text.append(", ");
                text.append(ProxyHelper.getString(facet.getFacetValue()));
                text.append("}");
                ++i;
            }
        }
        text.append("}");
        return text.toString();
    }

    static final String getXsdlType(XsdElement element) {
        XsdQName type = ProxyHelper.getXsdlTypeQName(element);
        if (type == null) {
            return null;
        }
        return type.toString();
    }

    static final String getMethodParameterName(String parameterName) {
        if (Util.isJavaKeyWord(parameterName)) {
            return "_" + parameterName;
        }
        return parameterName;
    }

    static final String getGenerationInfoInit() {
        Date date = new Date();
        StringBuffer init = new StringBuffer();
        init.append("new ");
        init.append("com.sap.aii.proxy.framework.core.GenerationInfo");
        init.append("(");
        init.append(ProxyHelper.getString(VERSION));
        init.append(", ");
        init.append(date.getTime());
        init.append("L");
        init.append(")");
        return init.toString();
    }

    static final String getUpName(String name) {
        StringBuffer upName = new StringBuffer(name);
        upName.setCharAt(0, Character.toUpperCase(upName.charAt(0)));
        return upName.toString();
    }

    public static final boolean hasLocalComplexType(XsdElement element) {
        XsdTypeDef type = element.getLocalTypeDef();
        if (type == null) {
            return false;
        }
        return type instanceof XsdComplexType;
    }

    static final GenericAttribute getSerId(String name) {
        GenericAttribute serId = new GenericAttribute("serialVersionUID", "long", ProxyCodingSegments.PRIVATE, true, true, null);
        serId.setDefaultValue(name.hashCode() + "L");
        return serId;
    }

    static String getPath(XsdNode node) {
        if (node == null) {
            return null;
        }
        List list = ProxyHelper.getPathList(node);
        StringBuffer txt = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            XsdNode n = (XsdNode)i.next();
            txt.append((Object)ProxyHelper.getText(n)).append(" ");
        }
        return txt.toString();
    }

    private static List getPathList(XsdNode node) {
        XsdNode parent = node.getParent();
        if (parent == null) {
            ArrayList<XsdSchema> l = new ArrayList<XsdSchema>();
            XsdSchema s = node.getSchema();
            if (s != null) {
                l.add(s);
            }
            return l;
        }
        List list = ProxyHelper.getPathList(parent);
        list.add(node);
        return list;
    }

    private static StringBuffer getText(XsdNode node) {
        StringBuffer txt = new StringBuffer();
        if (node instanceof XsdComplexType) {
            XsdComplexType n = (XsdComplexType)node;
            txt.append("<complexType");
            String name = n.getName();
            if (name != null && !name.trim().equals("")) {
                txt.append(" name =\"").append(name).append("\"");
            }
            txt.append(">");
        } else if (node instanceof XsdSimpleType) {
            XsdSimpleType n = (XsdSimpleType)node;
            txt.append("<simpleType");
            String name = n.getName();
            if (name != null && !name.trim().equals("")) {
                txt.append(" name =\"").append(name).append("\"");
            }
            txt.append(">");
        } else if (node instanceof XsdSequence) {
            txt.append("<sequence");
            txt.append(">");
        } else if (node instanceof XsdSchema) {
            txt.append("<schema>");
        } else if (node instanceof XsdElement) {
            XsdElement e = (XsdElement)node;
            txt.append("<element");
            String name = e.getName();
            if (name != null || !name.trim().equals("")) {
                txt.append(" name =\"").append(name).append("\"");
            } else {
                XsdQName ref = e.getRef();
                txt.append(" ref =\"").append(ref.getLocalName()).append("\"");
            }
            txt.append(">");
        } else if (node instanceof XsdAttribute) {
            XsdAttribute a = (XsdAttribute)node;
            txt.append("<attribute");
            String name = a.getName();
            if (name != null || !name.trim().equals("")) {
                txt.append(" name =\"").append(name).append("\"");
            } else {
                XsdQName ref = a.getRef();
                txt.append(" ref =\"").append(ref.getLocalName()).append("\"");
            }
            txt.append(">");
        } else if (node instanceof XsdRestriction) {
            XsdRestriction res = (XsdRestriction)node;
            XsdQName base = res.getBaseType();
            txt.append("<resrtiction");
            if (base != null) {
                txt.append(" base  =\"").append(base.getLocalName()).append("\"");
            }
            txt.append(">");
        } else if (node instanceof XsdFacet) {
            XsdFacet f = (XsdFacet)node;
            String name = f.getFacetName();
            String value = f.getFacetValue();
            txt.append("<").append(name).append("value = \"").append(value).append("\">");
        } else if (node instanceof XsdAll) {
            txt.append("<all>");
        } else if (node instanceof XsdGroup) {
            XsdGroup g = (XsdGroup)node;
            String name = g.getName();
            txt.append("<group");
            if (name != null) {
                txt.append(" name =\"").append(name).append("\"");
            } else {
                XsdQName ref = g.getRef();
                txt.append(" ref =\"").append(ref.getLocalName()).append("\"");
            }
            txt.append(">");
        } else if (node instanceof XsdAttributeGroup) {
            XsdAttributeGroup g = (XsdAttributeGroup)node;
            String name = g.getName();
            txt.append("<attributeGroup");
            if (name != null) {
                txt.append(" name =\"").append(name).append("\"");
            } else {
                XsdQName ref = g.getRef();
                txt.append(" ref =\"").append(ref.getLocalName()).append("\"");
            }
            txt.append(">");
        } else {
            txt.append(node.toString());
        }
        return txt;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

