/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.GenericAttribute;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GenericConstructor;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericMethod;
import com.sap.aii.proxy.generation.core.GenericOuterClass;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.nameMapping.EnumerationMapping;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMappingFactory;
import java.util.Iterator;
import java.util.Set;

class ProxyEnumerationClass
implements ProxyCodingSegments,
JavaTypes {
    private GenericClass enumClass;
    private String itemJavaType;
    private Set values;
    private boolean isRfc;
    private String oldContent;
    private String fullName;

    private ProxyEnumerationClass(String itemJavaType, Set values, boolean isRfc, String oldContent) {
        this.itemJavaType = itemJavaType;
        this.values = values;
        this.isRfc = isRfc;
        this.oldContent = oldContent;
    }

    ProxyEnumerationClass(String name, String packageName, String itemJavaType, Set values, boolean isRfc, String oldContent) {
        this(itemJavaType, values, isRfc, oldContent);
        this.enumClass = new GenericOuterClass(name, packageName);
        this.enumClass.addInterface("java.io.Serializable");
        this.enumClass.addAttribute(ProxyHelper.getSerId(name));
        if (packageName != null && !"".equals(packageName.trim())) {
            this.fullName = packageName + "." + name;
        }
        this.addEnumParts();
    }

    ProxyEnumerationClass(String fullName, String itemJavaType, Set values, boolean isRfc, String oldContent) {
        this(itemJavaType, values, isRfc, oldContent);
        this.fullName = fullName;
        String name = fullName;
        int index = fullName.lastIndexOf(".");
        if (index != -1) {
            name = fullName.substring(index + 1);
        }
        GenericInnerClass enumClass = new GenericInnerClass(name);
        enumClass.addInterface("java.io.Serializable");
        enumClass.addAttribute(ProxyHelper.getSerId(name));
        enumClass.setStatic(true);
        this.enumClass = enumClass;
        this.addEnumParts();
    }

    private void addEnumParts() {
        String name = this.enumClass.getName();
        this.enumClass.setSuperClass("com.sap.aii.proxy.framework.core.EnumerationType");
        EnumerationMapping enumMap = GlobalNameMappingFactory.getEnumerationMapping(name, this.oldContent);
        GenericAttribute nameAttribute = new GenericAttribute("name", this.itemJavaType, ProxyCodingSegments.PRIVATE, false, true, null);
        this.enumClass.addAttribute(nameAttribute);
        GenericConstructor constr = new GenericConstructor(name);
        constr.setAccessLevel(ProxyCodingSegments.PRIVATE);
        constr.addImport("name", this.itemJavaType);
        constr.addImplementation("this.name = name;");
        this.enumClass.addConstructor(constr);
        GenericMethod toString = new GenericMethod("toString");
        toString.setExport("java.lang.String");
        toString.setImplementation("return java.lang.String.valueOf(name);");
        this.enumClass.addMethod(toString);
        GenericMethod getValue = new GenericMethod("getValue");
        getValue.setExport(this.itemJavaType);
        getValue.setImplementation("return name;");
        this.enumClass.addMethod(getValue);
        if (!this.values.isEmpty()) {
            GenericMethod fromString = new GenericMethod("fromString");
            fromString.setStatic(true);
            fromString.addImport("name", "java.lang.String");
            fromString.setExport(name);
            GenericMethod fromValue = new GenericMethod("fromValue");
            fromValue.setStatic(true);
            fromValue.addImport("name", this.itemJavaType);
            fromValue.setExport(name);
            Iterator iter = this.values.iterator();
            while (iter.hasNext()) {
                String value = (String)iter.next();
                String instanceName = enumMap.addLabel(value);
                String valueName = enumMap.getStringLabel(value);
                GenericAttribute constant = new GenericAttribute(valueName, this.itemJavaType, ProxyCodingSegments.PUBLIC, true, true, value);
                if (this.itemJavaType.equals("java.lang.String")) {
                    constant.setDefaultValue(ProxyHelper.getString(value));
                }
                this.enumClass.addAttribute(constant);
                GenericAttribute instance = new GenericAttribute(instanceName, name, ProxyCodingSegments.PUBLIC, true, true, "new " + name + "(" + valueName + ")");
                instance.addComment("instance for value " + value);
                this.enumClass.addAttribute(instance);
                fromString.addImplementation("if (name.equals(" + ProxyHelper.getString(value) + ")" + ")" + "{" + "return " + instanceName + ";" + "}" + CodingSegments.END_LINE);
                fromValue.addImplementation(ProxyEnumerationClass.getFromValueLine(value, valueName, instanceName, this.itemJavaType));
            }
            fromString.addImplementation(" throw createIllegalArgumentException(name);");
            fromValue.addImplementation(" throw createIllegalArgumentException(name);");
            this.enumClass.addMethod(fromString);
            this.enumClass.addMethod(fromValue);
        }
    }

    GenericClass getEnumClass() {
        return this.enumClass;
    }

    String getFullName() {
        return this.fullName;
    }

    private static String getFromValueLine(String value, String label, String instance, String type) {
        StringBuffer line = new StringBuffer();
        line.append("if (");
        line.append("name");
        if (ProxyHelper.isPrimitive(type)) {
            line.append(" == ").append(label).append(")");
        } else {
            line.append(".equals(").append(label).append(")").append(")");
        }
        line.append("{").append("return ").append(instance).append(";");
        line.append("}").append(CodingSegments.END_LINE);
        return line.toString();
    }
}

