/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.GenerationType;
import com.sap.aii.proxy.generation.api.Info;
import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.AccessLevel;
import com.sap.aii.proxy.generation.core.AnonymMessageGenerator;
import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.GenericAttribute;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GenericConstructor;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericMethod;
import com.sap.aii.proxy.generation.core.GenericOuterClass;
import com.sap.aii.proxy.generation.core.GenericOuterInterface;
import com.sap.aii.proxy.generation.core.GlobalSimpleGenerator;
import com.sap.aii.proxy.generation.core.PathException;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.ProxyTypes;
import com.sap.aii.proxy.generation.core.SimpleClassGenerator;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlOperation;
import com.sap.aii.proxy.generation.core.WsdlParameter;
import com.sap.aii.proxy.generation.core.WsdlPart;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.binding.sap.TypeMapping;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalOperationMapping;
import com.sap.aii.proxy.generation.core.nameMapping.ParameterMapping;
import com.sap.aii.proxy.generation.core.util.Pair;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdQName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class PortTypeGenerator
extends SimpleClassGenerator
implements GlobalSimpleGenerator {
    private static final Logger sLogger = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$PortTypeGenerator == null ? (class$com$sap$aii$proxy$generation$core$PortTypeGenerator = PortTypeGenerator.class$("com.sap.aii.proxy.generation.core.PortTypeGenerator")) : class$com$sap$aii$proxy$generation$core$PortTypeGenerator).getName());
    private static final char DOT_CHAR = '.';
    private static final boolean TEST = false;
    private final GenerationType type;
    private StringBuffer initProxyDescriptor = new StringBuffer();
    private GenericOuterClass typeClass;
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$PortTypeGenerator;

    PortTypeGenerator(WsdlPortType portType, GlobalNameMapping globalNames, Info.ClassMap oldFiles, Wsdl wsdl, SapBinding binding, boolean isRfc, GenerationType type) throws ProxyGenerationException {
        super(globalNames, wsdl, binding, isRfc);
        this.type = type;
        XsdQName qName = portType.getQName();
        sLogger.info("generate portType: " + qName.toString());
        try {
            String fullPortTypeName = globalNames.getFullNamePortType(qName);
            String localPortTypeName = globalNames.getLocalNamePortType(qName);
            String portTypePackageName = globalNames.getPackageName(qName);
            boolean isInbound = portType.isInbound();
            this.typeClass = this.initClass(localPortTypeName, portTypePackageName, ProxyTypes.OUTBOUND_PROXY);
            this.initProxyDescriptor.append("com.sap.aii.proxy.framework.core.BaseProxyDescriptorFactory.createNewBaseProxyDescriptor");
            this.initProxyDescriptor.append("(");
            this.initProxyDescriptor.append(ProxyHelper.getString(qName.toString()));
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append("new ");
            this.initProxyDescriptor.append("java.lang.Object");
            this.initProxyDescriptor.append("[]");
            this.initProxyDescriptor.append("[]");
            this.initProxyDescriptor.append("[]");
            this.initProxyDescriptor.append("{");
            GenericOuterInterface remoteClass = new GenericOuterInterface(localPortTypeName + "Remote", portTypePackageName);
            GenericOuterInterface localClass = new GenericOuterInterface(localPortTypeName + "Local", portTypePackageName);
            GenericOuterClass beanClass = new GenericOuterClass(localPortTypeName + "Bean", portTypePackageName);
            if (type.isEJB()) {
                this.addAdditionalClass(beanClass);
            }
            if (isInbound) {
                beanClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInboundBean");
                GenericAttribute beanProxyAttr = new GenericAttribute("proxy$", fullPortTypeName + "Impl", ProxyCodingSegments.PRIVATE, false, false, "new " + fullPortTypeName + "Impl" + "()");
                beanClass.addAttribute(beanProxyAttr);
                remoteClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInboundRemote");
                if (type.isEJB()) {
                    this.addAdditionalClass(this.getHomeInterface(localPortTypeName, fullPortTypeName, portTypePackageName, true));
                    this.addAdditionalClass(remoteClass);
                    if (type.isEJB_2_0()) {
                        this.addAdditionalClass(this.getLocalHomeInterface(localPortTypeName, fullPortTypeName, portTypePackageName, true));
                        this.addAdditionalClass(localClass);
                    }
                }
                this.typeClass = new GenericOuterInterface(localPortTypeName, portTypePackageName);
                this.typeClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInbound");
                this.addOperationsIn(portType.getOperations(), globalNames.getLocalMappingPortType(qName), fullPortTypeName, beanClass);
            } else {
                beanClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyBean");
                remoteClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyRemote");
                if (type.isEJB()) {
                    this.addAdditionalClass(remoteClass);
                    this.addAdditionalClass(this.getHomeInterface(localPortTypeName, fullPortTypeName, portTypePackageName, false));
                    if (type.isEJB_2_0()) {
                        this.addAdditionalClass(this.getLocalHomeInterface(localPortTypeName, fullPortTypeName, portTypePackageName, false));
                        this.addAdditionalClass(localClass);
                    }
                }
                GenericAttribute beanProxyAttr = new GenericAttribute("proxy$", fullPortTypeName, ProxyCodingSegments.PRIVATE, false, false, "new " + fullPortTypeName + "()");
                beanClass.addAttribute(beanProxyAttr);
                this.typeClass.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxy");
                this.addConstructor();
                this.addOperationsOut(portType.getOperations(), portType.wsdl.getTargetNamespace(), qName.getLocalName(), globalNames.getLocalMappingPortType(qName), fullPortTypeName, remoteClass, localClass, beanClass);
            }
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append(this.getConnectionType());
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append(globalNames.getFullNamePortType(qName));
            this.initProxyDescriptor.append(".class");
            this.initProxyDescriptor.append(")");
            this.addStaticPortTypeAttributes(this.initProxyDescriptor.toString(), portType.isInbound());
            if (isInbound) {
                this.getImpl(this.typeClass);
            }
        }
        catch (PathException e) {
            e.addPathPart("<portType " + qName.toString() + ">");
            throw e;
        }
    }

    private GenericOuterInterface getHomeInterface(String name, String fullName, String packageName, boolean isInbound) {
        GenericOuterInterface home = new GenericOuterInterface(name + "Home", packageName);
        if (isInbound) {
            home.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInboundHome");
        } else {
            home.setSuperClass("javax.ejb.EJBHome");
            GenericMethod create = new GenericMethod("create");
            create.setExport(fullName + "Remote");
            create.addException("java.rmi.RemoteException");
            create.addException("javax.ejb.CreateException");
            home.addMethod(create);
        }
        return home;
    }

    private final void addOperationsOut(List operations, String namespace, String interfaceName, LocalOperationMapping opMapping, String fullPortTypeName, GenericOuterInterface remote, GenericOuterInterface local, GenericClass bean) throws ProxyGenerationException, PathException {
        int i = 0;
        while (i < operations.size()) {
            if (i > 0) {
                this.initProxyDescriptor.append(", ");
            }
            WsdlOperation operation = (WsdlOperation)operations.get(i);
            if (this.isRfc()) {
                this.addRfcOperationOut(operation, namespace, interfaceName, opMapping, remote, bean);
            } else {
                this.addOperationOut(operation, namespace, interfaceName, opMapping, fullPortTypeName, remote, local, bean);
            }
            ++i;
        }
        this.initProxyDescriptor.append("}");
        PortTypeGenerator.addProxyBeanMethodsOut(bean);
        PortTypeGenerator.addProxyBeanMethodsOut(remote);
    }

    private final void addOperationsIn(List operations, LocalOperationMapping opMapping, String fullPortTypeName, GenericClass bean) throws ProxyGenerationException, PathException {
        GenericMethod invoke = new GenericMethod("invokeMethod");
        invoke.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
        invoke.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
        bean.addMethod(invoke);
        GenericMethod getType = new GenericMethod("requestType");
        getType.addImport("methodName$", "java.lang.String");
        getType.setExport("com.sap.aii.proxy.framework.core.AbstractType");
        getType.addException("java.rmi.RemoteException");
        bean.addMethod(getType);
        GenericMethod exists = new GenericMethod("methodExists");
        exists.setExport("boolean");
        exists.addImport("methodName$", "java.lang.String");
        exists.addException("java.rmi.RemoteException");
        bean.addMethod(exists);
        GenericInnerClass inHelp = new GenericInnerClass("InHelp");
        inHelp.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInbound.Helper");
        GenericMethod methodInHelp = new GenericMethod("invokeMethod");
        methodInHelp.addImport("methodName$", "java.lang.String");
        methodInHelp.addImport("in$", "com.sap.aii.proxy.framework.core.AbstractProxyInbound");
        methodInHelp.addImport("abstractType$", "com.sap.aii.proxy.framework.core.AbstractType");
        methodInHelp.setExport("com.sap.aii.proxy.framework.core.AbstractType");
        methodInHelp.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
        methodInHelp.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
        inHelp.addMethod(methodInHelp);
        GenericMethod existsHelp = new GenericMethod("methodExists");
        existsHelp.setExport("boolean");
        existsHelp.addImport("methodName$", "java.lang.String");
        inHelp.addMethod(existsHelp);
        GenericConstructor cons = new GenericConstructor("InHelp");
        cons.setAccessLevel(ProxyCodingSegments.PRIVATE);
        inHelp.addConstructor(cons);
        GenericMethod getHelp = new GenericMethod("requestType");
        getHelp.addImport("methodName$", "java.lang.String");
        getHelp.setExport("com.sap.aii.proxy.framework.core.AbstractType");
        inHelp.addMethod(getHelp);
        this.typeClass.addInnerClass(inHelp);
        GenericAttribute help = new GenericAttribute("helper$", "com.sap.aii.proxy.framework.core.AbstractProxyInbound.Helper", ProxyCodingSegments.PUBLIC, true, true, "new InHelp()");
        this.typeClass.addAttribute(help);
        int i = 0;
        while (i < operations.size()) {
            if (i > 0) {
                this.initProxyDescriptor.append(", ");
            }
            WsdlOperation operation = (WsdlOperation)operations.get(i);
            if (!this.isRfc()) {
                invoke.setExport("com.sap.aii.proxy.framework.core.BeanMessage");
                invoke.addImport("methodName$", "java.lang.String");
                invoke.addImport("beanMessage$", "com.sap.aii.proxy.framework.core.BeanMessage");
                invoke.addException("java.rmi.RemoteException");
                this.addOperationIn(operation, opMapping, fullPortTypeName, invoke, getType, exists, methodInHelp, getHelp, bean, inHelp);
            }
            ++i;
        }
        invoke.addImplementation("return createException(methodName$)" + CodingSegments.END_LINE);
        methodInHelp.addImplementation(" throw createException(methodName$)" + CodingSegments.END_LINE);
        getType.addImplementation("return null" + CodingSegments.END_LINE);
        getHelp.addImplementation("return null" + CodingSegments.END_LINE);
        exists.addImplementation("return false" + CodingSegments.END_LINE);
        existsHelp.addImplementation(exists.implementation);
        this.initProxyDescriptor.append("}");
        PortTypeGenerator.addProxyBeanMethodsIn(bean);
    }

    private final void addRfcOperationOut(WsdlOperation operation, String namespace, String interfaceName, LocalOperationMapping opMapping, GenericOuterInterface remote, GenericClass bean) throws ProxyGenerationException {
        String className;
        XsdQName name;
        String methodName = PortTypeGenerator.addOperationToMapping(operation, opMapping, true);
        GenericMethod op = new GenericMethod(methodName);
        GenericMethod opRemote = new GenericMethod(methodName);
        opRemote.addException("java.rmi.RemoteException");
        GenericMethod opBean = new GenericMethod(methodName);
        StringBuffer implementation = new StringBuffer();
        implementation.append("com.sap.aii.proxy.framework.core.BaseType").append(" ");
        implementation.append("$result").append(" = ").append("null").append(CodingSegments.END_LINE);
        implementation.append("try {").append(CodingSegments.NEW_LINE);
        this.initProxyDescriptor.append("{").append("{");
        this.initProxyDescriptor.append(ProxyHelper.getString(operation.getName())).append(", ");
        this.initProxyDescriptor.append(ProxyHelper.getString(methodName)).append(", ");
        this.initProxyDescriptor.append(ProxyHelper.getString(TypeMapping.getAbapName(operation.getName())));
        this.initProxyDescriptor.append("}");
        WsdlParameter out = operation.getOutput();
        WsdlParameter in = operation.getInput();
        if (in != null) {
            name = in.getMessage();
            className = this.getGlobalNames().getFullNameMessage(name);
            this.initProxyDescriptor.append(", ").append("{");
            this.initProxyDescriptor.append(ProxyHelper.getString(name.toString())).append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className)).append("}");
        }
        if (out != null) {
            op.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            op.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            opRemote.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            opRemote.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            name = out.getMessage();
            className = this.getGlobalNames().getFullNameMessage(name);
            op.setExport(className);
            opRemote.setExport(className);
            opBean.setExport(className);
            this.initProxyDescriptor.append(", ").append("{");
            this.initProxyDescriptor.append(ProxyHelper.getString(name.toString())).append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className)).append("}");
            implementation.append("$result").append(" = ");
        }
        if (in != null) {
            op.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            op.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            opRemote.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            opRemote.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            name = in.getMessage();
            String attributeName = this.getGlobalNames().getLocalNameMessage(name);
            op.addImport(attributeName, this.getGlobalNames().getFullNameMessage(name));
            opRemote.addImport(attributeName, this.getGlobalNames().getFullNameMessage(name));
            opBean.addImport(attributeName, this.getGlobalNames().getFullNameMessage(name));
            implementation.append("send$(").append(attributeName).append(", ");
            implementation.append(ProxyHelper.getString(namespace)).append(", ");
            implementation.append(ProxyHelper.getString(interfaceName)).append(", ");
            implementation.append(ProxyHelper.getString(operation.getName())).append(", ");
            if (out == null) {
                implementation.append("null");
            } else {
                implementation.append("new ");
                implementation.append(this.getGlobalNames().getFullNameMessage(out.getMessage()));
                implementation.append("()");
            }
            implementation.append(")").append(CodingSegments.END_LINE);
        }
        implementation.append("}catch (").append("com.sap.aii.proxy.framework.core.ApplicationFaultException").append(" ");
        implementation.append("e").append(")").append("{").append(CodingSegments.NEW_LINE);
        List faults = operation.getFaults();
        int i = 0;
        while (i < faults.size()) {
            this.initProxyDescriptor.append(", ");
            WsdlParameter fault = (WsdlParameter)faults.get(i);
            XsdQName name2 = fault.getMessage();
            String className2 = this.getGlobalNames().getFullNameMessage(name2) + "_Exception";
            op.addException(className2);
            opRemote.addException(className2);
            opBean.addException(className2);
            this.initProxyDescriptor.append("{").append(ProxyHelper.getString(name2.toString())).append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className2)).append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(this.getGlobalNames().getFullNameMessage(name2))).append("}");
            implementation.append("if (").append("e").append(" instanceof ").append(className2);
            implementation.append(")").append(" ").append("{");
            implementation.append(" throw ").append("(").append(className2);
            implementation.append(")").append("e").append(";");
            implementation.append("}").append(CodingSegments.NEW_LINE);
            ++i;
        }
        implementation.append(" throw createExceptionWrongExceptionType$(").append("e");
        implementation.append(")").append(";");
        implementation.append("}").append(CodingSegments.NEW_LINE);
        if (out != null) {
            XsdQName name3 = out.getMessage();
            String className3 = this.getGlobalNames().getFullNameMessage(name3);
            implementation.append("if (").append("(").append("$result");
            implementation.append(" == ").append("null").append(")");
            implementation.append(" || ").append("(");
            implementation.append("$result").append(" instanceof ").append(className3);
            implementation.append(")").append(")");
            implementation.append("{").append(CodingSegments.NEW_LINE);
            implementation.append("return ").append("(");
            implementation.append(className3).append(")");
            implementation.append("$result").append(CodingSegments.END_LINE);
            implementation.append("}").append(" else ");
            implementation.append("{").append(" throw createExceptionWrongType$(");
            implementation.append("$result").append(")");
            implementation.append(";").append("}").append(CodingSegments.NEW_LINE);
        }
        this.initProxyDescriptor.append("}");
        op.addImplementation(implementation.toString());
        this.typeClass.addMethod(op);
        PortTypeGenerator.addBeanImpl(opBean);
        remote.addMethod(opRemote);
        bean.addMethod(opBean);
    }

    private final void addOperationOut(WsdlOperation operation, String namespace, String interfaceName, LocalOperationMapping opMapping, String fullPortTypeName, GenericOuterInterface remote, GenericClass local, GenericClass bean) throws ProxyGenerationException, PathException {
        String className;
        AnonymMessageGenerator messageGenerator;
        XsdQName name;
        String methodName = opMapping.addOperation(operation);
        ParameterMapping partMapping = opMapping.getParameterMapping(operation);
        GenericMethod op = new GenericMethod(methodName);
        GenericMethod opBean = new GenericMethod(methodName);
        StringBuffer implementation = new StringBuffer();
        StringBuffer send = new StringBuffer();
        String returnPart = null;
        String returnType = null;
        String returnPartJava = null;
        String[] parameterOrder = operation.getParameterOrder();
        Hashtable<String, String> typeMap = new Hashtable<String, String>();
        List inParts = new ArrayList();
        List outParts = new ArrayList();
        implementation.append("com.sap.aii.proxy.framework.core.BaseType").append(" ");
        implementation.append("$result").append(" = ").append("null");
        implementation.append(CodingSegments.END_LINE);
        implementation.append("try {").append(CodingSegments.NEW_LINE);
        this.initProxyDescriptor.append("{").append("{");
        this.initProxyDescriptor.append(ProxyHelper.getString(operation.getName())).append(", ");
        this.initProxyDescriptor.append(ProxyHelper.getString(methodName)).append(", ");
        this.initProxyDescriptor.append(ProxyHelper.getString(TypeMapping.getAbapName(operation.getName()))).append("}");
        WsdlParameter out = operation.getOutput();
        WsdlParameter in = operation.getInput();
        if (in != null) {
            name = in.getMessage();
            opMapping.getFullMessageName(name);
            String messageName = this.getGlobalNames().getLocalNameMessage(name);
            WsdlMessage message = this.getWsdl().getMessage(name);
            messageGenerator = new AnonymMessageGenerator(message, messageName, this.getGlobalNames(), this.getOldFile(), this.getWsdl(), this.getBinding(), this.isRfc());
            this.typeClass.addInnerClass(messageGenerator.getGenericInnerClass());
            inParts = PortTypeGenerator.getPartNameList(message);
            className = fullPortTypeName + "." + messageName;
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append("{");
            this.initProxyDescriptor.append(ProxyHelper.getString(name.toString()));
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className));
            this.initProxyDescriptor.append("}");
            implementation.append(className).append(" ").append("request$").append(" = ");
            implementation.append("new ").append(className).append("()");
            implementation.append(CodingSegments.END_LINE);
            List parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                WsdlPart part = (WsdlPart)parts.get(i);
                String partName = this.getPartName(part);
                String partJavaName = partMapping.addParameter(partName);
                String partType = this.getFullJavaType(part);
                typeMap.put(partName, partType);
                implementation.append("request$").append(".set").append(ProxyHelper.getUpName(partJavaName));
                implementation.append("(").append(ProxyHelper.getMethodParameterName(partJavaName));
                if (outParts.contains(partName)) {
                    implementation.append(".value");
                } else {
                    typeMap.put(partName, partType);
                }
                implementation.append(")").append(CodingSegments.END_LINE);
                ++i;
            }
        }
        if (out != null) {
            op.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            op.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            name = out.getMessage();
            WsdlMessage message = this.getWsdl().getMessage(name);
            String messageName = this.getGlobalNames().getLocalNameMessage(name);
            messageGenerator = new AnonymMessageGenerator(message, messageName, this.getGlobalNames(), this.getOldFile(), this.getWsdl(), this.getBinding(), this.isRfc());
            this.typeClass.addInnerClass(messageGenerator.getGenericInnerClass());
            outParts = PortTypeGenerator.getPartNameList(this.getWsdl().getMessage(name));
            className = this.getGlobalNames().getFullNameMessage(name);
            this.initProxyDescriptor.append(", ").append("{");
            this.initProxyDescriptor.append(ProxyHelper.getString(name.toString())).append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className)).append("}");
            send.append("$result").append(" = ");
        }
        if (in != null) {
            op.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            op.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            opBean.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            send.append("send$(").append("request$").append(", ");
            send.append(ProxyHelper.getString(namespace)).append(", ");
            send.append(ProxyHelper.getString(interfaceName)).append(", ");
            send.append(ProxyHelper.getString(operation.getName())).append(", ");
            if (out == null) {
                send.append("null");
            } else {
                send.append("new ").append(fullPortTypeName + "." + this.getGlobalNames().getLocalNameMessage(out.getMessage()));
                send.append("()");
            }
            send.append(")").append(CodingSegments.END_LINE);
        }
        send.append("}catch (").append("com.sap.aii.proxy.framework.core.ApplicationFaultException");
        send.append(" ").append("e").append(")");
        send.append("{").append(CodingSegments.NEW_LINE);
        List faults = operation.getFaults();
        int i = 0;
        while (i < faults.size()) {
            this.initProxyDescriptor.append(", ");
            WsdlParameter fault = (WsdlParameter)faults.get(i);
            XsdQName name2 = fault.getMessage();
            className = this.getGlobalNames().getFullNameMessage(name2) + "_Exception";
            op.addException(className);
            opBean.addException(className);
            this.initProxyDescriptor.append("{").append(ProxyHelper.getString(name2.toString()));
            this.initProxyDescriptor.append(", ").append(className).append(".class");
            this.initProxyDescriptor.append(", ").append(this.getGlobalNames().getFullNameMessage(name2)).append(".class");
            this.initProxyDescriptor.append("}");
            send.append("if (").append("e").append(" instanceof ").append(className);
            send.append(")").append(" ").append("{");
            send.append(" throw ").append("(").append(className).append(")");
            send.append("e").append(";").append("}").append(CodingSegments.NEW_LINE);
            ++i;
        }
        send.append(" throw createExceptionWrongExceptionType$(").append("e");
        send.append(")").append(";");
        send.append("}").append(CodingSegments.NEW_LINE);
        if (out != null) {
            XsdQName name3 = out.getMessage();
            String className2 = fullPortTypeName + "." + this.getGlobalNames().getLocalNameMessage(name3);
            send.append("if (").append("(");
            send.append("$result").append(" == ").append("null").append(")");
            send.append(" || ").append("(").append("$result");
            send.append(" instanceof ").append(className2).append(")");
            send.append(")").append("{").append(CodingSegments.NEW_LINE);
            send.append(className2).append(" ").append("response$");
            send.append(" = ").append("(").append(className2);
            send.append(")").append("$result");
            send.append(CodingSegments.END_LINE);
            List parts = this.getWsdl().getMessage(name3).getParts();
            returnPart = PortTypeGenerator.getReturn(parameterOrder, this.getWsdl().getMessage(name3));
            int i2 = 0;
            while (i2 < parts.size()) {
                WsdlPart part = (WsdlPart)parts.get(i2);
                String partName = this.getPartName(part);
                String partJavaName = partMapping.addParameter(partName);
                String partType = this.getFullJavaType(part);
                if (partName.equals(returnPart)) {
                    returnType = partType;
                    returnPartJava = partJavaName;
                } else {
                    String holder = PortTypeGenerator.getFullName(PortTypeGenerator.getHolderNameAndPackage(partType));
                    GenericOuterClass holderCl = PortTypeGenerator.getHolderClass(partType);
                    if (holderCl != null) {
                        this.addAdditionalClass(holderCl);
                    }
                    typeMap.put(partName, holder);
                    send.append(ProxyHelper.getMethodParameterName(partJavaName));
                    send.append(".value = ");
                    send.append("response$").append(".get").append(ProxyHelper.getUpName(partJavaName));
                    send.append("()").append(CodingSegments.END_LINE);
                }
                ++i2;
            }
            if (returnPart != null) {
                send.append("return ").append("response$").append(".get");
                send.append(ProxyHelper.getUpName(returnPartJava));
                send.append("()").append(CodingSegments.END_LINE);
            }
            send.append("}").append(" else ").append("{");
            send.append(" throw createExceptionWrongType$(").append("$result").append(")");
            send.append(";").append("}").append(CodingSegments.NEW_LINE);
        }
        this.initProxyDescriptor.append("}");
        implementation.append(send.toString());
        op.addImplementation(implementation.toString());
        PortTypeGenerator.addMethodParameters(op, parameterOrder, inParts, outParts, typeMap, returnPart, returnType, partMapping);
        PortTypeGenerator.addMethodParameters(opBean, parameterOrder, inParts, outParts, typeMap, returnPart, returnType, partMapping);
        PortTypeGenerator.addBeanImpl(opBean);
        this.typeClass.addMethod(op);
        remote.addMethod(PortTypeGenerator.getRemoteMethod(opBean));
        local.addMethod(PortTypeGenerator.getRemoteMethod(opBean));
        bean.addMethod(opBean);
    }

    private final void addOperationIn(WsdlOperation operation, LocalOperationMapping opMapping, String fullPortTypeName, GenericMethod invoke, GenericMethod getType, GenericMethod exists, GenericMethod help, GenericMethod getHelp, GenericClass beanClass, GenericClass helpClass) throws ProxyGenerationException, PathException {
        String className;
        String partType;
        GenericInnerClass beanMessageClass;
        AnonymMessageGenerator messageGenerator;
        XsdQName name;
        String methodName = opMapping.addOperation(operation);
        ParameterMapping partMapping = opMapping.getParameterMapping(operation);
        GenericMethod op = new GenericMethod(methodName);
        StringBuffer impl = new StringBuffer();
        StringBuffer getImpl = new StringBuffer();
        StringBuffer existsImpl = new StringBuffer();
        StringBuffer getHelpImpl = new StringBuffer();
        StringBuffer helpImpl = new StringBuffer();
        helpImpl.append("if (").append(ProxyHelper.getString(methodName)).append(".equals(");
        helpImpl.append("methodName$").append(")");
        helpImpl.append(")").append("{").append(CodingSegments.NEW_LINE);
        helpImpl.append(fullPortTypeName).append(" ").append("proxy$").append(" = ");
        helpImpl.append("(").append(fullPortTypeName).append(")");
        helpImpl.append("in$").append(CodingSegments.END_LINE);
        existsImpl.append("if (").append(ProxyHelper.getString(methodName)).append(".equals(");
        existsImpl.append("methodName$").append(")");
        existsImpl.append(")").append("{").append(CodingSegments.NEW_LINE);
        existsImpl.append("return ").append("true").append(";").append("}").append(CodingSegments.NEW_LINE);
        exists.addImplementation(existsImpl.toString());
        impl.append("if (").append(ProxyHelper.getString(methodName)).append(".equals(");
        impl.append("methodName$").append(")");
        impl.append(")").append("{").append(CodingSegments.NEW_LINE);
        impl.append("proxy$").append(".setMessageSpecifier$(").append("beanMessage$");
        impl.append(".getMessageSpecifier()").append(")").append(CodingSegments.END_LINE);
        String returnPart = null;
        String returnType = null;
        String[] parameterOrder = operation.getParameterOrder();
        Hashtable<String, String> typeMap = new Hashtable<String, String>();
        List inParts = new ArrayList();
        List outParts = new ArrayList();
        this.initProxyDescriptor.append("{").append("{");
        this.initProxyDescriptor.append(ProxyHelper.getString(operation.getName())).append(", ");
        this.initProxyDescriptor.append(ProxyHelper.getString(methodName)).append(", ");
        this.initProxyDescriptor.append(ProxyHelper.getString(TypeMapping.getAbapName(operation.getName()))).append("}");
        WsdlParameter out = operation.getOutput();
        WsdlParameter in = operation.getInput();
        if (in != null) {
            String classNameHelp;
            name = in.getMessage();
            String messageName = this.getGlobalNames().getLocalNameMessage(name);
            WsdlMessage message = this.getWsdl().getMessage(name);
            messageGenerator = new AnonymMessageGenerator(message, messageName, this.getGlobalNames(), this.getOldFile(), this.getWsdl(), this.getBinding(), this.isRfc());
            beanMessageClass = messageGenerator.getGenericInnerClass();
            beanClass.addInnerClass(beanMessageClass);
            helpClass.addInnerClass(beanMessageClass);
            inParts = PortTypeGenerator.getPartNameList(message);
            String className2 = classNameHelp = fullPortTypeName + "$" + "InHelp" + "$" + messageName;
            if (this.isEJB()) {
                className2 = fullPortTypeName + "Bean" + "." + messageName;
            }
            classNameHelp = classNameHelp.replace('$', '.');
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append("{");
            this.initProxyDescriptor.append(ProxyHelper.getString(name.toString()));
            this.initProxyDescriptor.append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className2));
            this.initProxyDescriptor.append("}");
            helpImpl.append(classNameHelp).append(" ").append("request$").append(" = ").append("(");
            helpImpl.append(classNameHelp).append(")").append("abstractType$");
            helpImpl.append(CodingSegments.END_LINE);
            getImpl.append("if (").append(ProxyHelper.getString(methodName)).append(".equals(");
            getImpl.append("methodName$").append(")");
            getImpl.append(")").append("{").append(CodingSegments.NEW_LINE);
            getImpl.append("return ").append("new ").append(className2).append("()");
            getImpl.append(";").append("}").append(CodingSegments.NEW_LINE);
            getHelpImpl.append("if (").append(ProxyHelper.getString(methodName)).append(".equals(");
            getHelpImpl.append("methodName$").append(")");
            getHelpImpl.append(")").append("{").append(CodingSegments.NEW_LINE);
            getHelpImpl.append("return ").append("new ").append(classNameHelp).append("()");
            getHelpImpl.append(";").append("}").append(CodingSegments.NEW_LINE);
            impl.append(className2).append(" ").append("request$").append(" = ");
            impl.append("(").append(className2).append(")");
            impl.append("beanMessage$").append(".getMessageType()").append(CodingSegments.END_LINE);
            List parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                WsdlPart part = (WsdlPart)parts.get(i);
                String partName = this.getPartName(part);
                String partJavaName = partMapping.addParameter(partName);
                partType = this.getFullJavaType(part);
                typeMap.put(partName, partType);
                if (!outParts.contains(partName)) {
                    typeMap.put(partName, partType);
                }
                ++i;
            }
        }
        impl.append("try {").append(CodingSegments.NEW_LINE);
        invoke.addImplementation(impl.toString());
        help.addImplementation(helpImpl.toString());
        helpImpl = new StringBuffer();
        impl = new StringBuffer();
        if (out != null) {
            op.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            op.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
            name = out.getMessage();
            WsdlMessage message = this.getWsdl().getMessage(name);
            String messageName = this.getGlobalNames().getLocalNameMessage(name);
            messageGenerator = new AnonymMessageGenerator(message, messageName, this.getGlobalNames(), this.getOldFile(), this.getWsdl(), this.getBinding(), this.isRfc());
            beanMessageClass = messageGenerator.getGenericInnerClass();
            beanClass.addInnerClass(beanMessageClass);
            helpClass.addInnerClass(beanMessageClass);
            outParts = PortTypeGenerator.getPartNameList(this.getWsdl().getMessage(name));
            className = fullPortTypeName + "$" + "InHelp" + "$" + messageName;
            if (this.isEJB()) {
                className = fullPortTypeName + "Bean" + "." + messageName;
            }
            this.initProxyDescriptor.append(", ").append("{");
            this.initProxyDescriptor.append(ProxyHelper.getString(name.toString())).append(", ");
            this.initProxyDescriptor.append(ProxyHelper.getString(className)).append("}");
        }
        if (in != null) {
            op.addException("com.sap.aii.proxy.framework.core.ApplicationFaultException");
            op.addException("com.sap.aii.proxy.framework.core.SystemFaultException");
        }
        List faults = operation.getFaults();
        int i = 0;
        while (i < faults.size()) {
            this.initProxyDescriptor.append(", ");
            WsdlParameter fault = (WsdlParameter)faults.get(i);
            XsdQName name2 = fault.getMessage();
            String className3 = this.getGlobalNames().getFullNameMessage(name2) + "_Exception";
            op.addException(className3);
            this.initProxyDescriptor.append("{").append(ProxyHelper.getString(name2.toString()));
            this.initProxyDescriptor.append(", ").append(className3).append(".class");
            this.initProxyDescriptor.append(", ").append(this.getGlobalNames().getFullNameMessage(name2)).append(".class");
            this.initProxyDescriptor.append("}");
            ++i;
        }
        if (out != null) {
            String classNameHelp;
            XsdQName name3 = out.getMessage();
            String messageName = this.getGlobalNames().getLocalNameMessage(name3);
            className = classNameHelp = fullPortTypeName + "$" + "InHelp" + "$" + messageName;
            if (this.isEJB()) {
                className = fullPortTypeName + "Bean" + "." + messageName;
            }
            classNameHelp = classNameHelp.replace('$', '.');
            impl.append(className).append(" ").append("response$").append(" = ");
            impl.append("new ").append(className).append("()").append(CodingSegments.END_LINE);
            helpImpl.append(classNameHelp).append(" ").append("response$").append(" = ");
            helpImpl.append("new ").append(classNameHelp).append("()").append(CodingSegments.END_LINE);
            List parts = this.getWsdl().getMessage(name3).getParts();
            returnPart = PortTypeGenerator.getReturn(parameterOrder, this.getWsdl().getMessage(name3));
            int i2 = 0;
            while (i2 < parts.size()) {
                WsdlPart part = (WsdlPart)parts.get(i2);
                String partName = this.getPartName(part);
                String partJavaName = partMapping.addParameter(partName);
                String javaParam = "$response_" + partJavaName;
                partType = this.getFullJavaType(part);
                if (partName.equals(returnPart)) {
                    returnType = partType;
                    impl.append("response$").append(".").append("set");
                    impl.append(ProxyHelper.getUpName(partJavaName)).append("(");
                    impl.append(javaParam).append(")").append(CodingSegments.END_LINE);
                    helpImpl.append("response$").append(".").append("set");
                    helpImpl.append(ProxyHelper.getUpName(partJavaName)).append("(");
                    helpImpl.append(javaParam).append(")").append(CodingSegments.END_LINE);
                } else {
                    String holder = PortTypeGenerator.getFullName(PortTypeGenerator.getHolderNameAndPackage(partType));
                    GenericOuterClass holderCl = PortTypeGenerator.getHolderClass(partType);
                    if (holderCl != null) {
                        this.addAdditionalClass(holderCl);
                    }
                    typeMap.put(partName, holder);
                    impl.append("response$").append(".").append("set");
                    impl.append(ProxyHelper.getUpName(partJavaName)).append("(");
                    impl.append(javaParam).append(".value").append(")");
                    impl.append(CodingSegments.END_LINE);
                    helpImpl.append("response$").append(".").append("set");
                    helpImpl.append(ProxyHelper.getUpName(partJavaName)).append("(");
                    helpImpl.append(javaParam).append(".value").append(")");
                    helpImpl.append(CodingSegments.END_LINE);
                }
                ++i2;
            }
            helpImpl.append("return ").append("response$").append(CodingSegments.END_LINE).append("}");
        } else {
            helpImpl.append("return ").append("null").append(CodingSegments.END_LINE).append("}");
        }
        this.initProxyDescriptor.append("}");
        PortTypeGenerator.addMethodParameters(op, parameterOrder, inParts, outParts, typeMap, returnPart, returnType, partMapping);
        this.typeClass.addMethod(op);
        impl.append("return ").append("new ").append("com.sap.aii.proxy.framework.core.BeanMessage").append("(");
        if (out != null) {
            impl.append("response$").append(", ");
        }
        impl.append("proxy$");
        impl.append(".").append("messageSpecifier").append(")");
        impl.append(CodingSegments.END_LINE);
        impl.append(ProxyCodingSegments.CATCH_FAULT);
        getType.addImplementation(getImpl.toString());
        getHelp.addImplementation(getHelpImpl.toString());
        help.addImplementation(PortTypeGenerator.getCallPart(parameterOrder, inParts, outParts, typeMap, returnPart, returnType, partMapping, methodName));
        help.addImplementation(helpImpl.toString());
        invoke.addImplementation(PortTypeGenerator.getCallPart(parameterOrder, inParts, outParts, typeMap, returnPart, returnType, partMapping, methodName));
        invoke.addImplementation(impl.toString());
    }

    private final void getImpl(GenericOuterClass inbound) {
    }

    private final void addStaticPortTypeAttributes(String initDescriptor, boolean isInbound) {
        AccessLevel accessLevel = ProxyCodingSegments.PRIVATE;
        if (isInbound) {
            accessLevel = ProxyCodingSegments.PUBLIC;
        }
        this.typeClass.addAttribute(new GenericAttribute("staticDescriptor", "com.sap.aii.proxy.framework.core.BaseProxyDescriptor", accessLevel, true, true, initDescriptor));
        this.typeClass.addAttribute(new GenericAttribute("staticGenerationInfo", "com.sap.aii.proxy.framework.core.GenerationInfo", accessLevel, true, true, ProxyHelper.getGenerationInfoInit()));
    }

    public final GenericOuterClass getGenericClass() {
        return this.typeClass;
    }

    private static void addBeanImpl(GenericMethod beanMethod) {
        String export = beanMethod.getExport();
        StringBuffer impl = new StringBuffer();
        if (export != null) {
            impl.append("return ");
        }
        impl.append("proxy$.").append(beanMethod.getName()).append("(");
        Vector imports = beanMethod.getImporting();
        int i = 0;
        while (i < imports.size()) {
            if (i > 0) {
                impl.append(", ");
            }
            Pair pair = (Pair)imports.get(i);
            impl.append(pair.getKey());
            ++i;
        }
        impl.append(")").append(CodingSegments.END_LINE);
        beanMethod.setImplementation(impl.toString());
    }

    private static void addProxyBeanMethodsOut(GenericClass bean) {
        PortTypeGenerator.addProxyBeanMethodsIn(bean);
        GenericMethod genInfo = new GenericMethod("$generationInfo");
        genInfo.setExport("com.sap.aii.proxy.framework.core.GenerationInfo");
        genInfo.addImplementation("return proxy$.generationInfo" + CodingSegments.END_LINE);
        genInfo.addException("java.rmi.RemoteException");
        bean.addMethod(genInfo);
        GenericMethod metadata = new GenericMethod("$jcoRuntimeMetaData");
        metadata.setExport("com.sap.aii.proxy.framework.core.JcoRuntimeMetaData");
        metadata.addImplementation("return proxy$.jcoRuntimeMetaData" + CodingSegments.END_LINE);
        metadata.addException("java.rmi.RemoteException");
        bean.addMethod(metadata);
        GenericMethod descriptor = new GenericMethod("$descriptor");
        descriptor.setExport("com.sap.aii.proxy.framework.core.Descriptor");
        descriptor.addImplementation("return proxy$.descriptor" + CodingSegments.END_LINE);
        descriptor.addException("java.rmi.RemoteException");
        bean.addMethod(descriptor);
    }

    private static void addProxyBeanMethodsIn(GenericClass bean) {
        GenericMethod specifier = new GenericMethod("$messageSpecifier");
        specifier.setExport("com.sap.aii.proxy.framework.core.MessageSpecifier");
        specifier.addImplementation("proxy$.messageSpecifier.clear()" + CodingSegments.END_LINE);
        specifier.addImplementation("return proxy$.messageSpecifier" + CodingSegments.END_LINE);
        specifier.addException("java.rmi.RemoteException");
        bean.addMethod(specifier);
        GenericMethod setSpecifier = new GenericMethod("$messageSpecifier");
        setSpecifier.addImport("messageSpecifier", "com.sap.aii.proxy.framework.core.MessageSpecifier");
        setSpecifier.addImplementation("proxy$.setMessageSpecifier$(messageSpecifier)" + CodingSegments.END_LINE);
        setSpecifier.addException("java.rmi.RemoteException");
        bean.addMethod(setSpecifier);
        GenericMethod runtime = new GenericMethod("$runtime");
        runtime.setExport("java.lang.Object");
        runtime.addImport("selector", "int");
        runtime.addImport("args", "Object[]");
        runtime.addImplementation("return proxy$.runtime$(selector, args);");
        runtime.addException("java.rmi.RemoteException");
        bean.addMethod(runtime);
    }

    private static String addOperationToMapping(WsdlOperation operation, LocalOperationMapping mapping, boolean isRfc) {
        WsdlParameter in = operation.getInput();
        XsdQName inputMessage = null;
        if (in != null) {
            inputMessage = in.getMessage();
        }
        WsdlParameter out = operation.getOutput();
        XsdQName outputMessage = null;
        if (out != null) {
            outputMessage = out.getMessage();
        }
        return mapping.addOperation(operation.getName(), inputMessage, outputMessage, isRfc);
    }

    private static GenericOuterClass getHolderClass(String javaType) {
        String[] names = PortTypeGenerator.getHolderNameAndPackage(javaType);
        String packageName = names[1];
        String className = names[0];
        GenericOuterClass holder = new GenericOuterClass(className, packageName);
        holder.addInterface("javax.xml.rpc.holders.Holder");
        GenericAttribute value = new GenericAttribute("value", javaType, ProxyCodingSegments.PUBLIC, false, false, null);
        holder.addAttribute(value);
        GenericConstructor cons = new GenericConstructor(className);
        holder.addConstructor(cons);
        GenericConstructor consValue = new GenericConstructor(className);
        consValue.addImport("value", javaType);
        consValue.setImplementation("this.value = value;");
        holder.addConstructor(consValue);
        return holder;
    }

    private static String[] getHolderNameAndPackage(String javaType) {
        if (ProxyHelper.isBuildInType(javaType)) {
            String className = PortTypeGenerator.getHolderName(javaType);
            return new String[]{className, "javax.mxl.rpc.holders"};
        }
        int index = javaType.lastIndexOf(46);
        String packageName = "holders";
        String className = javaType + "Holder";
        if (index != -1) {
            packageName = javaType.substring(0, index) + "." + packageName;
            className = javaType.substring(index + 1) + "Holder";
        }
        return new String[]{className, packageName};
    }

    private static String getHolderName(String javaType) {
        if ("int".equals(javaType)) {
            return "IntHolder";
        }
        int index = javaType.lastIndexOf(46);
        if (index != -1) {
            return javaType.substring(index + 1) + "Holder";
        }
        return javaType + "Holder";
    }

    static void addMethodParameters(GenericMethod method, String[] parameterOrder, List inParts, List outParts, Map typeMap, String returnName, String returnType, ParameterMapping partMapping) {
        String name;
        ArrayList in = new ArrayList(inParts);
        ArrayList out = new ArrayList(outParts);
        if (returnName != null) {
            out.remove(returnName);
            method.setExport(returnType);
        }
        int i = 0;
        while (i < parameterOrder.length) {
            name = parameterOrder[i];
            method.addImport(partMapping.getParameterName(name), (String)typeMap.get(name));
            in.remove(name);
            out.remove(name);
            ++i;
        }
        while (0 != in.size()) {
            name = (String)inParts.get(0);
            method.addImport(partMapping.getParameterName(name), (String)typeMap.get(name));
            in.remove(0);
            out.remove(name);
        }
        while (0 != out.size()) {
            name = (String)outParts.get(0);
            method.addImport(partMapping.getParameterName(name), (String)typeMap.get(name));
            out.remove(0);
        }
    }

    private static String getCallPart(String[] parameterOrder, List inParts, List outParts, Map typeMap, String returnName, String returnType, ParameterMapping partMapping, String methodName) {
        String javaParam;
        String javaName;
        String type;
        String name;
        ArrayList in = new ArrayList(inParts);
        ArrayList out = new ArrayList(outParts);
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer call = new StringBuffer();
        StringBuffer impl = new StringBuffer();
        if (returnName != null) {
            call.append(returnType).append(" ").append("$response_" + partMapping.getParameterName(returnName)).append(" = ");
            out.remove(returnName);
        }
        call.append("proxy$").append(".").append(methodName).append("(");
        int i = 0;
        while (i < parameterOrder.length) {
            name = parameterOrder[i];
            type = (String)typeMap.get(name);
            javaName = partMapping.getParameterName(name);
            javaParam = "$response_" + javaName;
            impl.append(type).append(" ").append(javaParam).append(" = ");
            if (type.endsWith("Holder")) {
                impl.append("new ").append(type).append("(");
                impl.append("request$").append(".").append("get").append(ProxyHelper.getUpName(javaName));
                impl.append("()").append(")");
            } else {
                impl.append("request$").append(".").append("get").append(ProxyHelper.getUpName(javaName));
                impl.append("()");
            }
            impl.append(CodingSegments.END_LINE);
            params.add(javaName);
            in.remove(name);
            out.remove(name);
            ++i;
        }
        while (0 != in.size()) {
            name = (String)inParts.get(0);
            type = (String)typeMap.get(name);
            javaName = partMapping.getParameterName(name);
            javaParam = "$request_" + javaName;
            impl.append(type).append(" ").append(javaParam).append(" = ");
            if (type.endsWith("Holder")) {
                impl.append("new ").append(type).append("(");
                impl.append("request$").append(".").append("get").append(ProxyHelper.getUpName(javaName));
                impl.append("()").append(")");
            } else {
                impl.append("request$").append(".").append("get").append(ProxyHelper.getUpName(javaName));
                impl.append("()");
            }
            impl.append(CodingSegments.END_LINE);
            params.add(javaParam);
            in.remove(name);
            out.remove(name);
        }
        while (0 != out.size()) {
            name = (String)outParts.get(0);
            type = (String)typeMap.get(name);
            javaName = partMapping.getParameterName(name);
            javaParam = "$response_" + javaName;
            impl.append(type).append(" ").append(javaParam).append(" = ");
            if (type.endsWith("Holder")) {
                impl.append("new ").append(type).append("(");
                impl.append("request$").append(".").append("get").append(ProxyHelper.getUpName(javaName));
                impl.append("()").append(")");
            } else {
                impl.append("request$").append(".").append("get").append(ProxyHelper.getUpName(javaName));
                impl.append("()");
            }
            impl.append(CodingSegments.END_LINE);
            params.add(javaName);
            out.remove(name);
        }
        impl.append(call.toString());
        int i2 = 0;
        while (i2 < params.size()) {
            if (i2 > 0) {
                impl.append(", ");
            }
            impl.append((String)params.get(i2));
            ++i2;
        }
        impl.append(")").append(CodingSegments.END_LINE);
        return impl.toString();
    }

    private static String getReturn(String[] parameterOrder, WsdlMessage message) {
        List parts = PortTypeGenerator.getPartNameList(message);
        List<String> parameter = Arrays.asList(parameterOrder);
        parts.removeAll(parameter);
        if (parts.size() == 1) {
            return (String)parts.get(0);
        }
        return null;
    }

    private static List getPartNameList(WsdlMessage message) {
        ArrayList<String> partNames = new ArrayList<String>();
        if (message != null) {
            List parts = message.getParts();
            int i = 0;
            while (i < parts.size()) {
                WsdlPart part = (WsdlPart)parts.get(i);
                partNames.add(part.getName());
                ++i;
            }
        }
        return partNames;
    }

    private static String getFullName(String[] holderName) {
        return holderName[1] + "." + holderName[0];
    }

    GenericClass getTypeClass() {
        return this.getGenericClass();
    }

    private boolean isEJB() {
        return this.type.isEJB();
    }

    private static final GenericMethod getRemoteMethod(GenericMethod beanMethod) {
        GenericMethod remoteMethod = new GenericMethod();
        remoteMethod.setName(beanMethod.getName());
        remoteMethod.setAccessLevel(beanMethod.getAccessLevel());
        remoteMethod.setExport(beanMethod.getExport());
        Set exceptions = beanMethod.getExceptions();
        Iterator i = exceptions.iterator();
        while (i.hasNext()) {
            String exception = (String)i.next();
            remoteMethod.addException(exception);
        }
        remoteMethod.addException("java.rmi.RemoteException");
        Vector importing = beanMethod.getImporting();
        int length = importing.size();
        int i2 = 0;
        while (i2 < length) {
            Pair in = (Pair)importing.get(i2);
            remoteMethod.addImport((String)in.getKey(), (String)in.getValue());
            ++i2;
        }
        return remoteMethod;
    }

    private GenericOuterInterface getLocalHomeInterface(String name, String fullName, String packageName, boolean isInbound) {
        GenericOuterInterface home = new GenericOuterInterface(name + "LocalHome", packageName);
        if (isInbound) {
            home.setSuperClass("com.sap.aii.proxy.framework.core.AbstractProxyInboundLocalHome");
        } else {
            home.setSuperClass("javax.ejb.EJBLocalHome");
            GenericMethod create = new GenericMethod("create");
            create.setExport(fullName + "Remote");
            create.addException("java.rmi.RemoteException");
            create.addException("javax.ejb.CreateException");
            home.addMethod(create);
        }
        return home;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

