/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.AnonymComplexTypeGenerator;
import com.sap.aii.proxy.generation.core.Comments;
import com.sap.aii.proxy.generation.core.ComplexTypeGenerator;
import com.sap.aii.proxy.generation.core.ElementMetadata;
import com.sap.aii.proxy.generation.core.GeneratorBasics;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericOuterClass;
import com.sap.aii.proxy.generation.core.InnerProxyTypeClass;
import com.sap.aii.proxy.generation.core.MessageId;
import com.sap.aii.proxy.generation.core.PathException;
import com.sap.aii.proxy.generation.core.ProxyEnumerationClass;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.ProxyTableClass;
import com.sap.aii.proxy.generation.core.ProxyTypeClass;
import com.sap.aii.proxy.generation.core.RfcHelper;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.binding.sap.RfcElementProperties;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.binding.sap.SapType;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdAll;
import com.sap.aii.util.xsd.api.XsdChoice;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdGroup;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSequence;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class MetaProxyGenerator
extends GeneratorBasics {
    private static final Logger LOG = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$MetaProxyGenerator == null ? (class$com$sap$aii$proxy$generation$core$MetaProxyGenerator = MetaProxyGenerator.class$("com.sap.aii.proxy.generation.core.MetaProxyGenerator")) : class$com$sap$aii$proxy$generation$core$MetaProxyGenerator).getName());
    LocalNameMapping localNames;
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$MetaProxyGenerator;

    MetaProxyGenerator(GlobalNameMapping globalNames, Wsdl wsdl, SapBinding binding, boolean isRfc) {
        super(globalNames, wsdl, binding, isRfc);
    }

    MetaProxyGenerator(GlobalNameMapping globalNames, Wsdl wsdl, boolean isRfc, LocalNameMapping localNames, String connectionType, String oldFile) {
        super(globalNames, wsdl, isRfc);
        this.localNames = localNames;
        this.setConnectionType(connectionType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void addParticle(XsdParticle particle, Map elementProperties) throws ProxyGenerationException, PathException {
        if (particle == null) return;
        if (particle instanceof XsdSequence) {
            if (particle.getMaxOccurs() != 1) throw new PathException((ProxyGenerationException.MessageId)MessageId.NOT_SUPPROTED, new Object[]{"<sequence maxOccurs > 1>"});
            try {
                this.addElements(particle.getElements(), elementProperties);
                return;
            }
            catch (PathException e) {
                throw e.addPathPart("<" + particle.getKind() + ">");
            }
        } else {
            if (particle instanceof XsdChoice) {
                throw new PathException((ProxyGenerationException.MessageId)MessageId.NOT_SUPPROTED, new Object[]{"<choice>"});
            }
            if (particle instanceof XsdAll) {
                this.addElements(RfcHelper.getSortedJcoList(particle, this.isRfc()), elementProperties);
                return;
            } else {
                if (!(particle instanceof XsdGroup)) return;
                this.addGroup((XsdGroup)particle, elementProperties);
            }
        }
    }

    private void addGroup(XsdGroup group, Map elementProperties) throws PathException, ProxyGenerationException {
        if (group.getMaxOccurs() == 1) {
            try {
                XsdQName ref = group.getRef();
                XsdParticle refGroup = this.getWsdl().getGroup(ref);
                this.addElements(refGroup.getElements(), elementProperties);
            }
            catch (PathException e) {
                throw e.addPathPart("<group ref=\"" + group.getRef() + "\">");
            }
        } else {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.NOT_SUPPROTED, new Object[]{"<group ref = \"...\" maxOccurs > 1>"});
        }
    }

    private void addElements(List elements, Map elementProperties) throws ProxyGenerationException, PathException {
        LOG.finest("adding " + elements.size() + " elements");
        if (elements.size() > 0) {
            // empty if block
        }
        int i = 0;
        while (i < elements.size()) {
            Object part = elements.get(i);
            if (part instanceof XsdElement) {
                XsdElement element = (XsdElement)part;
                RfcElementProperties newElementProperties = RfcHelper.getElementProperties(element.getName(), elementProperties);
                this.addElement(element, newElementProperties);
            } else if (part instanceof XsdParticle) {
                XsdParticle particle = (XsdParticle)part;
                this.addParticle(particle, elementProperties);
            } else {
                throw new PathException((ProxyGenerationException.MessageId)MessageId.UNEXPECTED_ELEMENT, new Object[0]);
            }
            ++i;
        }
    }

    final void addElement(XsdElement element, RfcElementProperties sapElement) throws ProxyGenerationException, PathException {
        XsdQName ref = element.getRef();
        if (ref != null) {
            XsdElement refElement = this.getWsdl().getElement(ref);
            throw new PathException((ProxyGenerationException.MessageId)MessageId.NOT_SUPPROTED, new Object[]{"<element ref \"...\">"});
        }
        String javaName = this.localNames.addElement(element.getName(), this.isRfc());
        LOG.finest("adding element " + javaName);
        String elementName = element.getName();
        String javaType = this.getJavaType(element);
        ElementMetadata elemMetadata = new ElementMetadata(element, javaName, javaType, sapElement);
        try {
            if (this.isRfc() && RfcHelper.isRfcTable(element)) {
                this.addRfcTable(element, sapElement, javaName, javaType);
                return;
            }
            XsdQName globalType = element.getGlobalTypeName();
            elemMetadata.setLineType(javaType);
            boolean isEnum = false;
            if (globalType != null) {
                XsdTypeDef t = this.getWsdl().getType(globalType);
                if (t instanceof XsdSimpleType && GeneratorBasics.isEnumType((XsdSimpleType)t)) {
                    LOG.finest("is Global Enumeration");
                    isEnum = true;
                    elemMetadata.setLineType(null);
                }
            } else {
                isEnum = this.addLocalType(element, elemMetadata);
            }
            if (element.getMaxOccurs() != 1) {
                this.addTable(element, javaName, javaType, isEnum);
            } else {
                this.getProxyTypeClass().addElement(elemMetadata);
            }
        }
        catch (PathException e) {
            throw e.addPathPart("<element name =\"" + elementName + "\">");
        }
    }

    void addTable(XsdElement element, String javaName, String javaType, boolean isEnum) throws ProxyGenerationException, PathException {
        LOG.finest("element is xi table");
        ProxyTableClass table = new ProxyTableClass(javaType, javaType, this.localNames.getFullElementType(element.getName()), javaName, element, false, this.getConnectionType(), isEnum);
        this.getProxyTypeClass().addInnerType((GenericInnerClass)table.getTableClass());
        javaType = table.getName();
        ElementMetadata elemMetadata = new ElementMetadata(element, javaName, javaType, null);
        elemMetadata.setLineType(table.getLineType());
        this.getProxyTypeClass().addElement(elemMetadata);
    }

    void addRfcTable(XsdElement element, RfcElementProperties sapElement, String javaName, String javaType) throws ProxyGenerationException, PathException {
        LOG.finest("is RFC table");
        ElementMetadata elemMetadata = new ElementMetadata(element, javaName, javaType, sapElement);
        ProxyTableClass table = this.addRfcTableClass(element, RfcHelper.getLineType(sapElement, this.getBinding()));
        XsdTypeDef typeDef = element.getLocalTypeDef();
        XsdComplexType cType = (XsdComplexType)typeDef;
        XsdParticle particle = cType.getParticle();
        List elements = particle.getElements();
        Object o = elements.get(0);
        XsdElement item = (XsdElement)o;
        elemMetadata.setJavaType(table.getName());
        elemMetadata.setLineType(table.getLineType());
        elemMetadata.setMinOccurs(item.getMinOccurs());
        elemMetadata.setMaxOccurs(item.getMaxOccurs());
        elemMetadata.setInternalType("com.sap.mw.jco.JCO.TYPE_TABLE");
        this.getProxyTypeClass().addElement(elemMetadata);
    }

    private final ProxyTableClass addRfcTableClass(XsdElement element, SapType sapType) throws ProxyGenerationException, PathException {
        ProxyTableClass table;
        XsdTypeDef typeDef = element.getLocalTypeDef();
        XsdComplexType type = (XsdComplexType)typeDef;
        XsdParticle particle = type.getParticle();
        List elements = particle.getElements();
        Object o = elements.get(0);
        XsdElement item = (XsdElement)o;
        XsdTypeDef typedef = item.getLocalTypeDef();
        String itemType = null;
        XsdQName typeName = null;
        String fullName = null;
        String localName = null;
        boolean global = true;
        String itemName = "Item";
        String name = this.localNames.getLocalElementType(element.getName());
        if (typedef != null) {
            global = false;
            if (typedef instanceof XsdSimpleType) {
                XsdSimpleType sType = (XsdSimpleType)typedef;
                XsdQName baseType = sType.getRestrictionBaseTypeRef();
                itemType = this.getGlobalNames().getFullNameType(baseType);
            } else if (typedef instanceof XsdComplexType && RfcHelper.isRfcTable(item)) {
                LocalNameMapping oldLocalNames = this.localNames;
                this.localNames = oldLocalNames.getLocalMappingElement(element.getName());
                itemName = this.localNames.addElement(item.getName(), true);
                table = this.addRfcTableClass(item, RfcHelper.getLineType(sapType, this.getBinding()));
                this.localNames = oldLocalNames;
                itemType = table.getName();
            }
            localName = itemType;
            fullName = itemType;
        } else {
            itemType = this.getJavaType(item);
            typeName = ProxyHelper.getXsdlTypeQName(item);
            localName = this.getGlobalNames().getLocalNameType(typeName);
            fullName = this.getGlobalNames().getFullNameType(typeName);
        }
        String properties = ProxyTableClass.getElementProperties(item.getName(), itemName, itemType, item.getDefault(), item.getFixed(), item.getForm(), ProxyHelper.getXsdlType(item), item.getNamespace().getURI(), item.isAbstract(), item.getMinOccurs(), item.getMaxOccurs(), ProxyHelper.isNillable(item), ProxyHelper.getSubstitutionGroup(item), ProxyHelper.getRestriction(item), sapType, false);
        table = new ProxyTableClass(localName, fullName, this.localNames.getFullElementType(element.getName()), name, properties, Comments.getComment(item), global, true, this.getConnectionType(), this.getGlobalNames().getPackageName(null));
        if (global) {
            this.addAdditionalClass((GenericOuterClass)table.getTableClass());
        } else {
            this.getProxyTypeClass().addInnerType((GenericInnerClass)table.getTableClass());
        }
        return table;
    }

    final String getJavaType(XsdElement element) throws ProxyGenerationException, PathException {
        LOG.finer("getting java type");
        XsdQName type = element.getGlobalTypeName();
        if (type == null) {
            XsdTypeDef typeDef = element.getLocalTypeDef();
            if (typeDef instanceof XsdComplexType || GeneratorBasics.isEnumType((XsdSimpleType)typeDef)) {
                return this.localNames.getLocalElementType(element.getName());
            }
            return this.getSimpleBaseType(element);
        }
        XsdTypeDef typeDef = this.getWsdl().getType(type);
        if (typeDef instanceof XsdComplexType) {
            return this.getGlobalNames().getFullNameType(type);
        }
        return this.getSimpleBaseType(type);
    }

    abstract ProxyTypeClass getProxyTypeClass();

    private void addClasses(Set classes) {
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            Object cl = iter.next();
            this.addAdditionalClass((GenericOuterClass)cl);
        }
    }

    private boolean addLocalType(XsdElement element, ElementMetadata elemMetadata) throws ProxyGenerationException, PathException {
        LOG.finest("add local inner class for element " + elemMetadata.getQName());
        boolean isEnum = false;
        XsdTypeDef def = element.getLocalTypeDef();
        if (def instanceof XsdComplexType) {
            LOG.finest("is local anonym complex type");
            AnonymComplexTypeGenerator cType = new AnonymComplexTypeGenerator((XsdComplexType)def, this.getGlobalNames(), this.getOldFile(), this.getWsdl(), this.isRfc(), this.localNames.getLocalMappingElement(element.getName()), this.localNames.getLocalElementType(element.getName()), this.getConnectionType());
            this.addClasses(cType.getAdditionalClasses());
            this.getProxyTypeClass().addInnerType((InnerProxyTypeClass)((ComplexTypeGenerator)cType).getProxyTypeClass());
            this.addClasses(cType.getAdditionalClasses());
        } else {
            LOG.finest("is local simple type");
            XsdSimpleType sType = (XsdSimpleType)def;
            if (GeneratorBasics.isEnumType(sType)) {
                LOG.finest("is simple Enum");
                isEnum = true;
                String enumType = this.getSimpleBaseType(element);
                Set set = GeneratorBasics.getEnumValues(sType);
                String fullEnumName = this.localNames.getFullElementType(element.getName());
                ProxyEnumerationClass enumClass = new ProxyEnumerationClass(fullEnumName, enumType, set, this.isRfc(), this.getOldFile());
                this.getProxyTypeClass().addInnerType((GenericInnerClass)enumClass.getEnumClass());
                elemMetadata.setJavaType(enumClass.getFullName());
                elemMetadata.setLineType(null);
            } else {
                LOG.finest("no local Type needed (simpleType no Enum");
            }
        }
        return isEnum;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

