/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.GenerationType;
import com.sap.aii.proxy.generation.api.Info;
import com.sap.aii.proxy.generation.api.JavaSource;
import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.api.ProxyGenerator;
import com.sap.aii.proxy.generation.core.ElementGenerator;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GlobalComplexTypeGenerator;
import com.sap.aii.proxy.generation.core.GlobalItemGenerator;
import com.sap.aii.proxy.generation.core.GlobalMessageGenerator;
import com.sap.aii.proxy.generation.core.GlobalSimpleGenerator;
import com.sap.aii.proxy.generation.core.MessageId;
import com.sap.aii.proxy.generation.core.ParameterGenerator;
import com.sap.aii.proxy.generation.core.PortTypeGenerator;
import com.sap.aii.proxy.generation.core.ProxyTypeClass;
import com.sap.aii.proxy.generation.core.SimpleTypeGenerator;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlBinding;
import com.sap.aii.proxy.generation.core.WsdlMessage;
import com.sap.aii.proxy.generation.core.WsdlParameter;
import com.sap.aii.proxy.generation.core.WsdlParser;
import com.sap.aii.proxy.generation.core.WsdlPortType;
import com.sap.aii.proxy.generation.core.WsdlTags;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMappingFactory;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.jdom.Attribute;
import com.sap.aii.util.xml.jdom.Document;
import com.sap.aii.util.xml.jdom.Element;
import com.sap.aii.util.xml.jdom.Namespace;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaGenerator
implements ProxyGenerator,
WsdlTags {
    private static final Logger LOG = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$JavaGenerator == null ? (class$com$sap$aii$proxy$generation$core$JavaGenerator = JavaGenerator.class$("com.sap.aii.proxy.generation.core.JavaGenerator")) : class$com$sap$aii$proxy$generation$core$JavaGenerator).getName());
    private GlobalNameMapping globalNames;
    private LocalNameMapping localNames;
    private Info.ClassMap oldFiles;
    private Set classes = new HashSet();
    private boolean isRfc;
    private GenerationType type;
    private Wsdl wsdl;
    private SapBinding binding;
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$JavaGenerator;

    public JavaGenerator(Info.ClassMap oldFiles, GenerationType type) {
        this.oldFiles = oldFiles;
        this.type = type;
        this.globalNames = GlobalNameMappingFactory.getMapping();
    }

    public JavaGenerator(Info.ClassMap oldFiles, String packageName, GenerationType type) throws ProxyGenerationException {
        if (packageName == null || packageName.trim().equals("")) {
            throw new ProxyGenerationException(MessageId.NO_PACKAGE_NAME);
        }
        this.isRfc = true;
        this.oldFiles = oldFiles;
        this.type = type;
        this.globalNames = GlobalNameMappingFactory.getMapping(packageName);
    }

    public void addProxies(XDocument wsdlDoc) throws ProxyGenerationException {
        SapBinding binding = null;
        Document doc = Document.wrap((XDocument)wsdlDoc);
        if (this.isRfc) {
            doc = this.getOutboundWsdl(doc);
        }
        WsdlParser parser = new WsdlParser();
        Wsdl wsdl = parser.parseWsdl(doc.unwrap());
        if (this.isRfc && (binding = JavaGenerator.getSapBinding(wsdl)) == null) {
            throw new ProxyGenerationException(MessageId.MISSING_BINDING);
        }
        this.toJava(wsdl, binding);
    }

    private void toJava(Wsdl wsdl, SapBinding binding) throws ProxyGenerationException {
        this.globalNames.addWsdl(wsdl);
        this.wsdl = wsdl;
        this.binding = binding;
        List portTypes = wsdl.getPortTypes();
        int i = 0;
        while (i < portTypes.size()) {
            WsdlPortType portType = (WsdlPortType)portTypes.get(i);
            PortTypeGenerator portTypeGenerator = new PortTypeGenerator(portType, this.globalNames, this.oldFiles, wsdl, binding, this.isRfc, this.type);
            this.addClasses(portTypeGenerator);
            ++i;
        }
        List messages = wsdl.getMessages();
        int i2 = 0;
        while (this.isRfc && i2 < messages.size()) {
            WsdlMessage message = (WsdlMessage)messages.get(i2);
            GlobalMessageGenerator messageGenerator = new GlobalMessageGenerator(message, this.globalNames, this.oldFiles, wsdl, binding, this.isRfc);
            this.addClasses(messageGenerator);
            ++i2;
        }
        Hashtable elementList = wsdl.getElements();
        Collection elements = elementList.values();
        Iterator iter = elements.iterator();
        while (!this.isRfc && iter.hasNext()) {
            XsdElement element = (XsdElement)iter.next();
            ElementGenerator elementGenerator = new ElementGenerator(element, this.globalNames, this.oldFiles, wsdl, binding, this.isRfc);
            this.addClasses(elementGenerator);
        }
        Set faults = wsdl.getFaults();
        Iterator iter2 = faults.iterator();
        while (iter2.hasNext()) {
            WsdlParameter fault = (WsdlParameter)iter2.next();
            ParameterGenerator parameterGenerator = new ParameterGenerator(fault, this.globalNames, this.oldFiles, wsdl, binding, this.isRfc);
            this.addClasses(parameterGenerator);
        }
        Hashtable cTypes = wsdl.getTypes();
        Collection types = cTypes.values();
        HashMap proxyTypeClasses = new HashMap();
        Iterator iter3 = types.iterator();
        while (iter3.hasNext()) {
            XsdSimpleType sType;
            Object type = iter3.next();
            if (type instanceof XsdComplexType) {
                XsdComplexType cType = (XsdComplexType)type;
                LOG.info("generating complexType " + cType.getQName().toString());
                GlobalComplexTypeGenerator complexTypeGenerator = new GlobalComplexTypeGenerator(cType, this.globalNames, this.oldFiles, wsdl, binding, this.isRfc);
                this.addClasses(complexTypeGenerator, cType.getQName(), proxyTypeClasses);
                continue;
            }
            if (!(type instanceof XsdSimpleType) || !Wsdl.isEnumType(sType = (XsdSimpleType)type)) continue;
            SimpleTypeGenerator tClass = new SimpleTypeGenerator(sType, this.globalNames, this.oldFiles, wsdl, binding, this.isRfc);
            this.addClasses(tClass);
        }
        this.resolveComplexProxyTypes(proxyTypeClasses);
    }

    private static SapBinding getSapBinding(Wsdl wsdl) throws ProxyGenerationException {
        List bindings = wsdl.getBindings();
        SapBinding sap = null;
        int i = 0;
        while (i < bindings.size() && sap == null) {
            sap = JavaGenerator.getSapBinding((WsdlBinding)bindings.get(i), wsdl);
            ++i;
        }
        return sap;
    }

    private static SapBinding getSapBinding(WsdlBinding binding, Wsdl wsdl) throws ProxyGenerationException {
        List extentions = binding.getExtentions();
        SapBinding sap = null;
        int i = 0;
        while (i < extentions.size() && sap == null) {
            Element element = Element.wrap((XElement)((XElement)extentions.get(i)));
            if (element.getName().equals("binding") && element.getNamespace().getURI().equals("urn:sap-com:document:sap:rfc:functions")) {
                sap = new SapBinding(binding, wsdl);
            }
            ++i;
        }
        return sap;
    }

    private void addClasses(Set classes) {
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            Object cl = iter.next();
            if (cl == null) continue;
            this.add((GenericClass)cl);
        }
    }

    private void addClasses(GlobalSimpleGenerator generator) {
        this.addClasses(generator.getAdditionalClasses());
        this.add(generator.getGenericClass());
    }

    private void addClasses(GlobalItemGenerator generator, XsdQName qName, Map proxyTypeClasses) {
        this.addClasses(generator.getAdditionalClasses());
        proxyTypeClasses.put(qName, generator.getOuterProxyTypeClass());
    }

    private void addClasses(ElementGenerator generator, XsdQName qName, Map proxyTypeClasses) {
        this.add(generator.getGenericClass());
        this.addClasses(generator.getAdditionalClasses());
        ProxyTypeClass proxyType = generator.getProxyTypeClass();
        if (proxyType != null) {
            proxyTypeClasses.put(qName, generator.getProxyTypeClass());
        }
    }

    private void addClasses(GlobalMessageGenerator generator) {
        this.addClasses(generator.getAdditionalClasses());
        this.add(generator.getGenericOuterClass());
    }

    private Document getOutboundWsdl(Document inWsdl) {
        Document wsdl = inWsdl;
        Namespace wsdlNamespace = this.getWsdlNameSpace(wsdl);
        Element def = wsdl.getRootElement();
        if (!def.getName().equals("definitions") || !def.getNamespace().equals((Object)wsdlNamespace)) {
            return null;
        }
        Element portType = def.getChild("portType", wsdlNamespace);
        if (portType == null) {
            return null;
        }
        List elements = portType.getChildren("operation", wsdlNamespace);
        int i = 0;
        while (i < elements.size()) {
            Element operation = (Element)elements.get(i);
            Element in = operation.getChild("input", wsdlNamespace);
            Element out = operation.getChild("output", wsdlNamespace);
            List faults = operation.getChildren("fault", wsdlNamespace);
            if (in != null) {
                in.setName("output");
            }
            if (out != null) {
                out.setName("input");
            }
            ++i;
        }
        this.replaceTimeDate(wsdl);
        return wsdl;
    }

    private Element getElement(Element e) {
        Element element = e.getName().equals("input") ? new Element("output", e.getNamespace()) : new Element("input", e.getNamespace());
        List atts = e.getAttributes();
        int i = 0;
        while (i < atts.size()) {
            Attribute att = (Attribute)atts.get(i);
            e.removeAttribute(att.getName());
            element.addAttribute(att);
            ++i;
        }
        List elems = e.getChildren();
        e.removeChildren();
        int i2 = 0;
        while (i2 < elems.size()) {
            Object o = elems.get(i2);
            if (o instanceof Element) {
                element.addContent((Element)o);
            } else if (o instanceof String) {
                element.addContent((String)o);
            }
            ++i2;
        }
        List n = e.getAdditionalNamespaces();
        int i3 = 0;
        while (i3 < n.size()) {
            element.addNamespaceDeclaration((Namespace)n.get(i3));
            ++i3;
        }
        return element;
    }

    private Namespace getWsdlNameSpace(Document doc) {
        return doc.getRootElement().getNamespace();
    }

    private void replaceTimeDate(Document wsdl) {
        Namespace wsdlNamespace = this.getWsdlNameSpace(wsdl);
        Element def = wsdl.getRootElement();
        Element types = def.getChild("types", wsdlNamespace);
        Namespace xmlNamespace = Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema");
        Element date = new Element("restriction", xmlNamespace);
        date.addAttribute("base", "xsd:string");
        Element maxLength = new Element("maxLength", xmlNamespace);
        maxLength.addAttribute("value", "20");
        date.addContent(maxLength);
        Element time = (Element)date.clone();
        Element schema = types.getChild("schema", xmlNamespace);
        List simpleTypes = schema.getChildren("simpleType", xmlNamespace);
        int i = 0;
        while (i < simpleTypes.size()) {
            Element simpleType = (Element)simpleTypes.get(i);
            String name = simpleType.getAttribute("name").getValue();
            if (name.equals("time")) {
                schema.removeContent(simpleType);
            } else if (name.equals("date")) {
                schema.removeContent(simpleType);
            } else if (name.equals("genericDate")) {
                schema.removeContent(simpleType);
            } else if (name.equals("genericTime")) {
                schema.removeContent(simpleType);
            }
            ++i;
        }
    }

    public Info getGenInfo() {
        return new Info();
    }

    public JavaSource[] getSources() {
        return this.classes.toArray(new JavaSource[this.classes.size()]);
    }

    public void generateProxy(XDocument wsdl) throws ProxyGenerationException {
        this.addProxies(wsdl);
    }

    private void add(GenericClass cl) {
        if (cl != null) {
            this.classes.add(cl);
        }
    }

    private void resolveComplexProxyTypes(Map map) {
        Collection entries = map.values();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            ProxyTypeClass cl = (ProxyTypeClass)o;
            this.add(cl.getGenericClass(map));
        }
    }

    private void addGenericClasses(Set cl) {
        this.classes.addAll(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

