/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.GenericClass;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericMethod;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.ProxyTableClass;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;

abstract class ItemMetadata
implements ProxyCodingSegments,
JavaTypes {
    private XsdQName qName;
    private String javaName;
    private String javaType;
    private String documentation;
    private XsdQName xsdType;
    private String form;
    private String defaultValue;
    private String fixedValue;
    private XsdRestriction facets;

    ItemMetadata(XsdQName qName, String javaName, String javaType, XsdQName xsdType) {
        this.qName = qName;
        this.javaName = javaName;
        this.javaType = javaType;
        this.xsdType = xsdType;
    }

    final String getJavaName() {
        return this.javaName;
    }

    final String getJavaType() {
        return this.javaType;
    }

    final String getDefaultValue() {
        return this.defaultValue;
    }

    final XsdRestriction getFacets() {
        return this.facets;
    }

    final String getFixedValue() {
        return this.fixedValue;
    }

    final String getForm() {
        return this.form;
    }

    final String getXsdType() {
        if (this.xsdType == null) {
            return null;
        }
        return this.xsdType.toString();
    }

    final void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    final void setFacets(XsdRestriction facets) {
        this.facets = facets;
    }

    final void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    final void setForm(String form) {
        this.form = form;
    }

    final String getQName() {
        return this.qName.toString();
    }

    final String getLocalName() {
        if (this.qName == null) {
            return null;
        }
        return this.qName.getLocalName();
    }

    final String getNamespace() {
        if (this.qName == null) {
            return null;
        }
        return this.qName.getNamespaceUri();
    }

    final boolean isFixed() {
        return this.fixedValue != null;
    }

    final void addAccessMethods(GenericClass type, int index) {
        this.addGetMethod(type, index);
        this.addHasMethod(type, index);
        this.addSetMethod(type, index);
        this.addDeleteMethod(type, index);
        if (this.isTable()) {
            this.addSetAndGetElementMethodsForList(type, index, null);
        }
    }

    abstract StringBuffer getDescriptorLine(int var1);

    abstract boolean isTable();

    abstract String getType();

    abstract String getGetType();

    abstract boolean isNillable();

    abstract boolean isRfc();

    private void addDeleteMethod(GenericClass type, int index) {
        String methodName = ProxyHelper.getUpName(this.javaName);
        if (this.isNillable()) {
            GenericMethod delete = new GenericMethod();
            delete.setName("unset" + methodName);
            StringBuffer impl = new StringBuffer();
            impl.append("baseTypeData()").append(".delete");
            impl.append(this.getType());
            impl.append("Value(").append(index).append(")");
            impl.append(CodingSegments.END_LINE);
            delete.setImplementation(impl.toString());
            type.addMethod(delete);
        }
    }

    private void addGetMethod(GenericClass type, int index) {
        GenericMethod get = new GenericMethod();
        String methodName = ProxyHelper.getUpName(this.javaName);
        if (this.isTable()) {
            get.setName("get_as_list" + methodName);
        } else {
            get.setName("get" + methodName);
        }
        get.setExport(this.getJavaType());
        StringBuffer impl = new StringBuffer();
        impl.append("return ");
        if (!ProxyHelper.isPrimitive(this.javaType)) {
            impl.append("(").append(this.javaType).append(")");
        }
        impl.append("baseTypeData()");
        impl.append(ItemMetadata.getGetValue(this.javaType, this.getGetType()));
        impl.append(index).append(")");
        impl.append(CodingSegments.END_LINE);
        get.setImplementation(impl.toString());
        type.addMethod(get);
    }

    private void addHasMethod(GenericClass type, int index) {
        if (this.isNillable()) {
            String methodName = ProxyHelper.getUpName(this.javaName);
            GenericMethod has = new GenericMethod();
            has.setName("isSet" + methodName);
            has.setExport("boolean");
            StringBuffer impl = new StringBuffer();
            impl.append("return ").append("baseTypeData()").append(".has");
            impl.append(this.getType());
            impl.append("Value(").append(index).append(")");
            impl.append(CodingSegments.END_LINE);
            has.setImplementation(impl.toString());
            type.addMethod(has);
        }
    }

    private void addSetMethod(GenericClass type, int index) {
        String paramName = ProxyHelper.getMethodParameterName(this.javaName);
        String methodName = ProxyHelper.getUpName(this.javaName);
        if (!this.isFixed()) {
            GenericMethod set = new GenericMethod();
            set.setName("set" + methodName);
            set.addImport(paramName, this.javaType);
            StringBuffer impl = new StringBuffer();
            impl.append("baseTypeData()").append(".set");
            impl.append(this.getType());
            impl.append("Value(").append(index).append(", ");
            impl.append(paramName).append(")");
            impl.append(CodingSegments.END_LINE);
            set.setImplementation(impl.toString());
            type.addMethod(set);
        }
    }

    private void addSetAndGetElementMethodsForList(GenericClass type, int index, ProxyTableClass table) {
        this.addGetArrayMethod(type, this.javaType, this.getLineType(), index);
        this.addSetArrayMethod(type, this.javaType, this.getLineType(), index);
    }

    private void addSetArrayMethod(GenericClass type, String listType, String lineType, int index) {
        String arrayType = lineType + "[]";
        String paramName = ProxyHelper.getMethodParameterName(this.javaName);
        String methodName = ProxyHelper.getUpName(this.javaName);
        String innerMethodName = null;
        innerMethodName = this.isRfc() ? ItemMetadata.getTableMethodName("add", lineType) : "add" + ProxyHelper.getUpName(paramName);
        if (!this.isFixed()) {
            GenericMethod set = new GenericMethod();
            set.setName("set" + methodName);
            set.addImport(paramName, arrayType);
            StringBuffer impl = new StringBuffer();
            impl.append("baseTypeData()").append(".set");
            impl.append(this.getType());
            impl.append("Value(").append(index).append(", ");
            impl.append("new ").append(listType).append("()");
            impl.append(")").append(CodingSegments.END_LINE);
            impl.append(listType).append(" list$").append(" = ").append("get_as_list");
            impl.append(methodName).append("()").append(CodingSegments.END_LINE);
            impl.append("for (").append("int").append(" ").append(" i$").append(" = ");
            impl.append("0").append(";").append(" i$").append(" < ");
            impl.append(paramName).append(".length").append(";");
            impl.append(" i$").append("++").append(")");
            impl.append("{").append(CodingSegments.NEW_LINE).append(" list$");
            impl.append(".").append(innerMethodName).append("(");
            impl.append(paramName).append("[").append(" i$");
            impl.append("]").append(")");
            impl.append(CodingSegments.END_LINE).append("}");
            set.setImplementation(impl.toString());
            type.addMethod(set);
        }
    }

    private void addGetArrayMethod(GenericClass type, String listType, String lineType, int index) {
        String arrayType = lineType + "[]";
        GenericMethod get = new GenericMethod();
        String attributeName = ProxyHelper.getMethodParameterName(this.javaName);
        String methodName = ProxyHelper.getUpName(attributeName);
        String innerMethodName = this.isRfc() ? ItemMetadata.getTableMethodName("toArray", lineType) : "toArray" + ProxyHelper.getUpName(attributeName);
        get.setName("get" + methodName);
        get.setExport(arrayType);
        StringBuffer impl = new StringBuffer();
        impl.append(listType).append(" i$").append(" = ").append("(");
        impl.append(listType).append(")").append("baseTypeData()");
        impl.append(ItemMetadata.getGetValue(listType, this.getGetType()));
        impl.append(index).append(")");
        impl.append(CodingSegments.END_LINE);
        impl.append("if (").append(" i$").append(" == ").append("null");
        impl.append(")").append("{").append("return ");
        impl.append("null").append(";").append("}").append(CodingSegments.NEW_LINE);
        impl.append("return ").append(" i$").append(".");
        impl.append(innerMethodName).append("()");
        impl.append(CodingSegments.END_LINE);
        get.setImplementation(impl.toString());
        type.addMethod(get);
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    void addMetadataMehod(GenericInnerClass metadataClass, int index) {
        if (metadataClass != null) {
            String name = ProxyHelper.getUpName(this.javaName);
            GenericMethod method = new GenericMethod("get" + name);
            StringBuffer impl = new StringBuffer("return ");
            method.setExport(this.getMetadataType());
            impl.append(this.getMetadataCast());
            impl.append("parent.baseTypeMetaData()");
            impl.append(this.getGetType());
            impl.append("(");
            impl.append(index);
            impl.append(")");
            impl.append(";");
            method.setImplementation(impl.toString());
            metadataClass.addMethod(method);
        }
    }

    abstract String getMetadataCast();

    abstract String getMetadataType();

    private static String getTableMethodName(String name, String type) {
        return ItemMetadata.getTableMethodName(name, type, false);
    }

    private static String getTableMethodName(String name, String type, boolean removeAt) {
        StringBuffer text = new StringBuffer(name);
        if (type.equals("int")) {
            text.append("AsInt");
            if (removeAt) {
                text.append("At");
            }
        } else if (type.equals("boolean")) {
            text.append("AsBoolean");
        } else if (type.equals("short")) {
            text.append("AsShort");
        } else if (type.equals("byte")) {
            text.append("AsByte");
        } else if (type.equals("float")) {
            text.append("AsFloat");
        } else if (type.equals("double")) {
            text.append("AsDouble");
        } else {
            type = ItemMetadata.getMethodType(type);
            type = type.substring(type.lastIndexOf(46) + 1);
            text.append(type);
        }
        return text.toString();
    }

    private static String getMethod(String name, String type, boolean removeAt) {
        StringBuffer text = new StringBuffer(name);
        if (type.equals("int")) {
            text.append("AsInt");
            if (removeAt) {
                text.append("At");
            }
        } else if (type.equals("boolean")) {
            text.append("AsBoolean");
        } else if (type.equals("short")) {
            text.append("AsShort");
        } else if (type.equals("byte")) {
            text.append("AsByte");
        } else if (type.equals("float")) {
            text.append("AsFloat");
        } else if (type.equals("double")) {
            text.append("AsDouble");
        }
        return text.toString();
    }

    private static String getMethod(String name, String type) {
        return ItemMetadata.getMethod(name, type, false);
    }

    private static String getMethodName(String name, String type) {
        return ItemMetadata.getMethodName(name, type, false);
    }

    private static String getMethodName(String name, String type, boolean removeAt) {
        StringBuffer text = new StringBuffer(name);
        if (type.equals("int")) {
            text.append("AsInt");
            if (removeAt) {
                text.append("At");
            }
        } else if (type.equals("boolean")) {
            text.append("AsBoolean");
        } else if (type.equals("short")) {
            text.append("AsShort");
        } else if (type.equals("byte")) {
            text.append("AsByte");
        } else if (type.equals("float")) {
            text.append("AsFloat");
        } else if (type.equals("double")) {
            text.append("AsDouble");
        } else {
            type = ItemMetadata.getMethodType(type);
            text.append(type);
        }
        return text.toString();
    }

    private static String getMethodType(String type) {
        if (type.equals("byte[]")) {
            return "byteArray";
        }
        if ("java.lang.String[]".endsWith(type)) {
            return "java.lang.StringArray";
        }
        return type;
    }

    private static String getGetValue(String type, String implType) {
        StringBuffer text = new StringBuffer();
        text.append(implType);
        text.append("Value");
        if (type.equals("java.lang.String")) {
            text.append("AsString");
        } else if (type.equals("java.sql.Date")) {
            text.append("AsDate");
        } else if (type.equals("java.math.BigDecimal")) {
            text.append("AsBigDecimal");
        } else if (type.equals("java.math.BigInteger")) {
            text.append("AsBigInteger");
        } else if (type.equals("boolean")) {
            text.append("AsBoolean");
        } else if (type.equals("java.sql.Time")) {
            text.append("AsTime");
        } else if (type.equals("int")) {
            text.append("AsInt");
        } else if (type.equals("byte")) {
            text.append("AsByte");
        } else if (type.equals("long")) {
            text.append("AsLong");
        } else if (type.equals("short")) {
            text.append("AsShort");
        } else if (type.equals("float")) {
            text.append("AsFloat");
        } else if (type.equals("double")) {
            text.append("AsDouble");
        } else if (type.equals("java.lang.String[]")) {
            text.append("AsStringArray");
        } else if (type.equals("byte[]")) {
            text.append("AsByteArray");
        }
        text.append("(");
        return text.toString();
    }

    abstract String getLineType();
}

