/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.GenericItem;
import com.sap.aii.proxy.generation.core.util.Pair;
import com.sap.aii.proxy.generation.core.util.Text;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

class GenericMethod
extends GenericItem
implements Serializable {
    private static final long serialVersionUID = 3622948951L;
    String exporting;
    Vector importing;
    private boolean isStatic;
    private boolean isAbstract;
    private boolean isFinal;
    String implementation = new String();
    HashSet exceptions;

    GenericMethod() {
        this.importing = new Vector();
        this.exceptions = new HashSet();
    }

    GenericMethod(String name) {
        this();
        this.setName(name);
    }

    void addImport(String name, String type) {
        this.importing.add(new Pair(name, type));
    }

    void deleteImports() {
        this.importing = new Vector();
    }

    Vector getImporting() {
        return this.importing;
    }

    void setExport(String exp) {
        this.exporting = exp;
    }

    String getExport() {
        return this.exporting;
    }

    void addException(String ex) {
        this.exceptions.add(ex);
    }

    void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    String toSignatureString() {
        Iterator iter;
        StringBuffer buffer = new StringBuffer("");
        String comment = this.getComment();
        if (comment != null && !comment.equals("")) {
            buffer.append("/** " + comment + " */\n");
        }
        buffer.append("public ");
        if (this.isAbstract) {
            buffer.append("abstract ");
        }
        if (this.isStatic) {
            buffer.append("static ");
        }
        if (this.exporting != null) {
            buffer.append(this.exporting + " ");
        } else {
            buffer.append("void ");
        }
        if (this.getName() != null) {
            buffer.append(this.getName() + "(");
        } else {
            buffer.append("!MISSING! ( ");
        }
        if (!this.importing.isEmpty()) {
            iter = ((AbstractList)this.importing).iterator();
            while (iter.hasNext()) {
                Pair parameter = (Pair)iter.next();
                Object name = parameter.getKey();
                Object type = parameter.getValue();
                buffer.append((String)type + " " + (String)name);
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append(") ");
        if (!this.exceptions.isEmpty()) {
            buffer.append("throws ");
            iter = this.exceptions.iterator();
            while (iter.hasNext()) {
                buffer.append((String)iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append(";");
        return buffer.toString();
    }

    public String toString() {
        Iterator iter;
        StringBuffer buffer = new StringBuffer("");
        String comment = this.getComment();
        if (comment != null && !comment.equals("")) {
            buffer.append("/** " + comment + " */\n");
        }
        buffer.append("public ");
        if (this.isAbstract) {
            buffer.append("abstract ");
        }
        if (this.isStatic) {
            buffer.append("static ");
        }
        if (this.exporting != null) {
            buffer.append(this.exporting + " ");
        } else {
            buffer.append("void ");
        }
        if (this.getName() != null) {
            buffer.append(this.getName() + "(");
        } else {
            buffer.append("!MISSING! ( ");
        }
        if (!this.importing.isEmpty()) {
            iter = ((AbstractList)this.importing).iterator();
            while (iter.hasNext()) {
                Pair parameter = (Pair)iter.next();
                Object name = parameter.getKey();
                Object type = parameter.getValue();
                buffer.append((String)type + " " + (String)name);
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
        }
        buffer.append(") ");
        if (!this.exceptions.isEmpty()) {
            buffer.append("throws ");
            iter = this.exceptions.iterator();
            while (iter.hasNext()) {
                buffer.append((String)iter.next());
                if (!iter.hasNext()) continue;
                buffer.append(", ");
            }
        }
        if (!this.isAbstract) {
            buffer.append("{\n");
            if (this.implementation != null) {
                buffer.append(Text.pp(this.implementation, 4));
            }
            buffer.append("}\n");
        } else {
            buffer.append(";");
        }
        return buffer.toString();
    }

    private String getID() {
        StringBuffer id = new StringBuffer();
        if (this.getName() != null) {
            id.append(this.getName() + ":");
        }
        if (!this.importing.isEmpty()) {
            Iterator iter = ((AbstractList)this.importing).iterator();
            while (iter.hasNext()) {
                Pair parameter = (Pair)iter.next();
                Object type = parameter.getValue();
                id.append((String)type + ",");
            }
            id = id.deleteCharAt(id.length() - 1);
        }
        return id.toString();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof GenericMethod && ((GenericMethod)o).getID().equals(this.getID());
    }

    void addImplementation(String text) {
        this.implementation = this.implementation + text;
    }

    void setStatic(boolean _isStatic) {
        this.isStatic = _isStatic;
    }

    void setAbstract(boolean _isAbstract) {
        this.isAbstract = _isAbstract;
    }

    void setFinal(boolean _isFinal) {
        this.isFinal = _isFinal;
    }

    boolean isAbstract() {
        return this.isAbstract;
    }

    public Set getExceptions() {
        return this.exceptions;
    }
}

