/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.GenericItem;
import com.sap.aii.proxy.generation.core.util.Pair;
import com.sap.aii.proxy.generation.core.util.Text;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class GenericConstructor
extends GenericItem
implements Serializable {
    private static final long serialVersionUID = -26258728965L;
    public Vector importing = new Vector();
    public String implementation = new String();

    public GenericConstructor() {
    }

    public GenericConstructor(String name) {
        this();
        this.setName(name);
    }

    public void addImport(String parameterName, String parameterType) {
        this.importing.add(new Pair(parameterName, parameterType));
    }

    public void addImplementation(String sourcecode) {
        this.implementation = this.implementation + sourcecode;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("");
        String comment = this.getComment();
        if (comment != null) {
            buffer.append("/** " + comment + " */\n");
        }
        buffer.append(this.getAccessLevel() + " ");
        if (this.getName() != null) {
            buffer.append(this.getName() + " (");
        } else {
            buffer.append("!MISSING! (");
        }
        if (this.importing.size() > 0) {
            buffer.append((String)((Pair)this.importing.elementAt(0)).getValue() + " ");
            buffer.append((String)((Pair)this.importing.elementAt(0)).getKey());
            int i = 1;
            while (i < this.importing.size()) {
                buffer.append(", " + (String)((Pair)this.importing.elementAt(i)).getValue());
                buffer.append(" " + (String)((Pair)this.importing.elementAt(i)).getKey());
                ++i;
            }
        }
        buffer.append(") {\n");
        if (this.implementation != null) {
            buffer.append(Text.pp(this.implementation + "\n", 4));
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    private String getID() {
        StringBuffer id = new StringBuffer();
        if (this.getName() != null) {
            id.append(this.getName() + ":");
        }
        if (!this.importing.isEmpty()) {
            Iterator iter = ((AbstractList)this.importing).iterator();
            while (iter.hasNext()) {
                id.append(((Pair)iter.next()).getKey() + ",");
            }
            id = id.deleteCharAt(id.length() - 1);
        }
        return id.toString();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof GenericConstructor && ((GenericConstructor)o).getID().equals(this.getID());
    }

    public void setImplementation(String implementation) {
        String oldImplementation = this.getImplementation();
        this.implementation = implementation;
    }
}

