/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.GenericAttribute;
import com.sap.aii.proxy.generation.core.GenericConstructor;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.GenericItem;
import com.sap.aii.proxy.generation.core.GenericMethod;
import com.sap.aii.proxy.generation.core.util.Text;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

abstract class GenericClass
extends GenericItem
implements CodingSegments,
Serializable {
    static final String STATIC = "static ";
    private static final String FINAL = "final ";
    private static final String ABSTRACT = "abstract";
    private static final String CLASS = "class ";
    private static final String IMPLEMENTS = " implements ";
    private static final String EXTENDS = " extends ";
    private static final long serialVersionUID = 84315490361L;
    private StringBuffer headComment;
    private String superclass;
    private HashSet interfaces;
    private List attributes = new ArrayList();
    private String staticBlock;
    private HashSet constructors = new HashSet();
    private HashSet methods = new HashSet();
    private boolean isAbstract;
    private HashSet innerClasses;

    GenericClass() {
        this.interfaces = new HashSet();
        this.innerClasses = new HashSet();
    }

    GenericClass(String name) {
        this();
        this.setName(name);
    }

    final String getHeadComment() {
        if (this.headComment == null) {
            return null;
        }
        return this.headComment.toString();
    }

    final void addHeadComment(String headComment) {
        if (this.headComment == null) {
            if (headComment != null) {
                this.headComment = new StringBuffer(headComment);
            }
        } else {
            this.headComment.append(" ");
            this.headComment.append(headComment);
        }
    }

    final boolean isAbstract() {
        return this.isAbstract;
    }

    final void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    final void setSuperClass(String superclass) {
        this.superclass = superclass;
    }

    final void addInterface(String ifname) {
        this.interfaces.add(ifname);
    }

    final void addConstructor(GenericConstructor gc) {
        this.constructors.add(gc);
    }

    final void addMethod(GenericMethod gm) {
        this.methods.add(gm);
    }

    final void addAttribute(GenericAttribute ga) {
        this.attributes.add(ga);
    }

    final void setStaticBlock(String staticBlock) {
        this.staticBlock = staticBlock;
    }

    final GenericMethod[] getMethod() {
        return ((AbstractCollection)this.methods).toArray(new GenericMethod[0]);
    }

    final GenericAttribute[] getAttributes() {
        return this.attributes.toArray(new GenericAttribute[0]);
    }

    public final String toString() {
        Iterator iter;
        StringBuffer buffer = new StringBuffer();
        if (this.headComment != null) {
            buffer.append("/* ");
            buffer.append((Object)this.headComment);
            buffer.append(CodingSegments.NEW_LINE + " */" + CodingSegments.NEW_LINE + CodingSegments.NEW_LINE);
        }
        buffer.append((Object)this.getPackageLine());
        buffer.append((Object)this.getImportLines());
        String comment = this.getComment();
        if (comment != null && !comment.equals("")) {
            buffer.append("/** " + comment + "*/" + CodingSegments.NEW_LINE);
        }
        buffer.append(this.getAccessLevel());
        if (this.isAbstract) {
            buffer.append(ABSTRACT);
        }
        buffer.append(this.getStatic());
        buffer.append(this.getType());
        if (this.getName() != null) {
            buffer.append(this.getName());
        } else {
            buffer.append("!MISSING!");
        }
        if (this.superclass != null) {
            buffer.append(EXTENDS + this.superclass);
        }
        if (!this.interfaces.isEmpty()) {
            buffer.append(IMPLEMENTS);
            iter = this.interfaces.iterator();
            while (iter.hasNext()) {
                buffer.append((String)iter.next() + ", ");
            }
            buffer = buffer.delete(buffer.length() - 2, buffer.length() - 1);
        }
        buffer.append("{" + CodingSegments.NEW_LINE + CodingSegments.NEW_LINE);
        if (!this.attributes.isEmpty()) {
            iter = this.attributes.iterator();
            while (iter.hasNext()) {
                buffer.append(Text.pp(((GenericAttribute)iter.next()).toString(), 4) + CodingSegments.NEW_LINE);
            }
        }
        if (this.staticBlock != null && !this.staticBlock.equals("")) {
            buffer.append(Text.pp("static {" + CodingSegments.NEW_LINE, 4));
            buffer.append(Text.pp(this.staticBlock, 8));
            buffer.append(Text.pp("}", 4));
        }
        if (!this.constructors.isEmpty()) {
            iter = this.constructors.iterator();
            while (iter.hasNext()) {
                buffer.append(Text.pp(((GenericConstructor)iter.next()).toString(), 4) + CodingSegments.NEW_LINE);
            }
        }
        if (!this.methods.isEmpty()) {
            iter = this.methods.iterator();
            while (iter.hasNext()) {
                buffer.append(this.getMethod((GenericMethod)iter.next()));
            }
        }
        if (!this.innerClasses.isEmpty()) {
            iter = this.innerClasses.iterator();
            while (iter.hasNext()) {
                GenericInnerClass inner = (GenericInnerClass)iter.next();
                buffer.append(Text.pp(inner.toString(), 4) + CodingSegments.NEW_LINE);
            }
        }
        buffer.append("}" + CodingSegments.NEW_LINE);
        return buffer.toString();
    }

    private String getID() {
        return this.getJavaName();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof GenericClass && ((GenericClass)o).getID().equals(this.getID());
    }

    final void addInnerClass(GenericInnerClass innerClass) {
        this.innerClasses.add(innerClass);
    }

    abstract String getJavaName();

    abstract StringBuffer getPackageLine();

    abstract StringBuffer getImportLines();

    String getStatic() {
        return "";
    }

    String getType() {
        return CLASS;
    }

    String getMethod(GenericMethod method) {
        return Text.pp(method.toString(), 4) + "\n";
    }

    HashSet getConstructors() {
        return this.constructors;
    }

    public String getSuperClass() {
        return this.superclass;
    }
}

