/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.AccessLevel;
import com.sap.aii.proxy.generation.core.GenericItem;
import java.io.Serializable;

class GenericAttribute
extends GenericItem
implements Serializable {
    private static final long serialVersionUID = 653732513622948951L;
    private static int counter = 0;
    private String type;
    private boolean isnative = false;
    private String container;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private String defaultValue;

    GenericAttribute() {
    }

    GenericAttribute(String name) {
        this();
        this.setName(name);
    }

    GenericAttribute(String name, String type, AccessLevel accessLevel, boolean _isStatic, boolean _isFinal, String defaultValue) {
        this(name);
        this.setType(type, true);
        this.setAccessLevel(accessLevel);
        this.setDefaultValue(defaultValue);
        this.isStatic = _isStatic;
        this.isFinal = _isFinal;
    }

    String getType() {
        return this.type;
    }

    void setType(String type, boolean isnative) {
        this.type = type;
        this.isnative = isnative;
    }

    boolean isNative() {
        return this.isnative;
    }

    boolean isContainer() {
        return this.type.equals(this.container);
    }

    void setContainer(String container) {
        this.container = container;
    }

    String getContainer() {
        return this.container;
    }

    void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String comment = this.getComment();
        if (comment != null && !comment.equals("")) {
            buffer.append("/** " + comment);
            if (this.container != null) {
                buffer.append("\n * contains objects of type ");
                if (this.type != null) {
                    buffer.append(this.type);
                } else {
                    buffer.append("!MISSING!");
                }
            }
            buffer.append(" */\n");
        } else if (this.container != null) {
            buffer.append("/** contains objects of type ");
            if (this.type != null) {
                buffer.append(this.type);
            } else {
                buffer.append("!MISSING!");
            }
            buffer.append(" */\n");
        }
        buffer.append(this.getAccessLevel() + " ");
        if (this.isStatic) {
            buffer.append("static ");
        }
        if (this.isFinal) {
            buffer.append("final ");
        }
        if (this.container != null) {
            buffer.append(this.container + " ");
        } else if (this.type != null) {
            buffer.append(this.type + " ");
        } else {
            buffer.append("!MISSING! ");
        }
        if (this.getName() != null) {
            buffer.append(this.getName());
        } else {
            buffer.append("attribute" + counter++);
        }
        if (this.defaultValue != null) {
            buffer.append(" = ");
            buffer.append(this.defaultValue);
        }
        buffer.append(" ;\n");
        return buffer.toString();
    }

    private String getID() {
        StringBuffer id = new StringBuffer();
        if (this.getName() != null) {
            id.append(this.getName());
        }
        return id.toString();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof GenericAttribute && ((GenericAttribute)o).getID().equals(this.getID());
    }

    void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }
}

