/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.Info;
import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.Generator;
import com.sap.aii.proxy.generation.core.GenericOuterClass;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.MessageId;
import com.sap.aii.proxy.generation.core.PathException;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.WsdlPart;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdFacet;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import com.sap.aii.util.xsd.api.XsdUnion;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class GeneratorBasics
implements ProxyCodingSegments,
JavaTypes,
Generator {
    private static final Logger sLogger = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$GeneratorBasics == null ? (class$com$sap$aii$proxy$generation$core$GeneratorBasics = GeneratorBasics.class$("com.sap.aii.proxy.generation.core.GeneratorBasics")) : class$com$sap$aii$proxy$generation$core$GeneratorBasics).getName());
    private String connectionType = "com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_NONE";
    private GlobalNameMapping globalNames;
    private SapBinding binding;
    private Set genericClasses = new HashSet();
    private Set proxyTypeClasses = new HashSet();
    private Wsdl wsdl;
    private String oldFile;
    private boolean isRfc = false;
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$GeneratorBasics;

    GeneratorBasics(GlobalNameMapping globalNames, Wsdl wsdl, SapBinding binding, boolean isRfc) {
        this(globalNames, wsdl, isRfc);
        this.binding = binding;
        this.connectionType = GeneratorBasics.getConnectionType(binding);
    }

    GeneratorBasics(GlobalNameMapping globalNames, Wsdl wsdl, boolean isRfc) {
        this.globalNames = globalNames;
        this.wsdl = wsdl;
        this.isRfc = isRfc;
    }

    final void setOldFile(Info.ClassMap oldFiles, String name) {
        this.oldFile = oldFiles.get(name);
    }

    final String getFullJavaType(WsdlPart part) throws ProxyGenerationException, PathException {
        return this.getJavaType(part);
    }

    final String getJavaType(WsdlPart part) throws ProxyGenerationException, PathException {
        XsdQName xsdType = part.getType();
        if (xsdType == null) {
            xsdType = part.getElement();
            XsdElement element = this.wsdl.getElement(xsdType);
            if (!ProxyHelper.hasLocalComplexType(element)) {
                xsdType = element.getGlobalTypeName();
                return this.getJavaType(xsdType);
            }
            return this.globalNames.getFullNameType(element.getQName());
        }
        return this.getJavaType(xsdType);
    }

    final XsdQName getQNameOfType(WsdlPart part) throws ProxyGenerationException {
        XsdQName xsdType = part.getType();
        if (xsdType == null) {
            xsdType = part.getElement();
            XsdElement element = this.wsdl.getElement(xsdType);
            xsdType = !ProxyHelper.hasLocalComplexType(element) ? element.getGlobalTypeName() : element.getQName();
        }
        return xsdType;
    }

    final String getJavaType(XsdQName type) throws ProxyGenerationException, PathException {
        if (type == null) {
            return null;
        }
        XsdTypeDef def = this.wsdl.getType(type);
        if (def instanceof XsdSimpleType) {
            return this.getSimpleBaseType(type);
        }
        return this.globalNames.getFullNameType(type);
    }

    final String getSimpleBaseType(XsdQName name) throws PathException, ProxyGenerationException {
        if (name == null) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.NO_TYPE_DEF, new Object[0]);
        }
        if (name.isInSchemaNamespace()) {
            return this.globalNames.getFullNameType(name);
        }
        XsdTypeDef base = this.wsdl.getType(name);
        if (base instanceof XsdSimpleType) {
            XsdSimpleType sBase = (XsdSimpleType)base;
            if (GeneratorBasics.isEnumType(sBase)) {
                return this.globalNames.getFullNameType(name);
            }
            if (GeneratorBasics.isUnionType(sBase)) {
                return this.globalNames.getFullNameType(name);
            }
            return this.getSimpleBaseType(base.getBaseTypeName());
        }
        if (this.isRfc) {
            return this.globalNames.getFullNameType(name);
        }
        throw new PathException((ProxyGenerationException.MessageId)MessageId.STYPE_NOT_EXIST, new Object[]{name.toString()});
    }

    final String getSimpleBaseType(XsdAttribute attribute) throws ProxyGenerationException, PathException {
        sLogger.finest("get base type for attribute " + attribute.getName());
        XsdQName type = attribute.getGlobalTypeName();
        if (type == null) {
            type = attribute.getLocalTypeDef().getBaseTypeName();
        }
        if (type == null) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.NO_TYPE_FOR_ATTRIBUTE, new Object[]{attribute.getName()});
        }
        return this.getSimpleBaseType(type);
    }

    final String getSimpleBaseType(XsdElement element) throws PathException, ProxyGenerationException {
        sLogger.finest("get base type for element " + element.getName());
        XsdQName type = element.getGlobalTypeName();
        if (type == null) {
            type = element.getLocalTypeDef().getBaseTypeName();
        }
        return this.getSimpleBaseType(type);
    }

    final String getPartName(WsdlPart part) throws ProxyGenerationException {
        String name = part.getName();
        XsdQName xsdType = this.getQNameOfType(part);
        if (name == null) {
            name = xsdType.getLocalName();
        }
        return name;
    }

    final boolean isRfc() {
        return this.isRfc;
    }

    final String getOldFile() {
        return this.oldFile;
    }

    final Wsdl getWsdl() {
        return this.wsdl;
    }

    final void setOldFile(String oldFile) {
        this.oldFile = oldFile;
    }

    final void setJ2ee(boolean j2ee) {
    }

    final void addAdditionalClasses(Set addClasses) {
        this.genericClasses.addAll(addClasses);
    }

    final void addAdditionalClass(GenericOuterClass addClass) {
        this.genericClasses.add(addClass);
    }

    public final Set getAdditionalClasses() {
        return this.genericClasses;
    }

    final Set getAdditionalProxyTypeClasses() {
        return this.proxyTypeClasses;
    }

    final SapBinding getBinding() {
        return this.binding;
    }

    final String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    final GlobalNameMapping getGlobalNames() {
        return this.globalNames;
    }

    static final String getConnectionType(SapBinding binding) {
        if (binding == null) {
            return "com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_XML";
        }
        return "com.sap.aii.proxy.framework.core.FactoryConstants.CONNECTION_TYPE_JCO";
    }

    static final boolean isEnumType(XsdSimpleType sType) {
        sLogger.finest("prove for EnumType");
        return Wsdl.isEnumType(sType);
    }

    static Set getEnumValues(XsdSimpleType sType) {
        HashSet<String> values = new HashSet<String>();
        XsdRestriction restriction = sType.getRestriction();
        if (restriction != null) {
            List facets = restriction.getFacets();
            int i = 0;
            while (i < facets.size()) {
                XsdFacet facet = (XsdFacet)facets.get(i);
                if ("enumeration".equals(facet.getFacetName())) {
                    values.add(facet.getFacetValue());
                }
                ++i;
            }
        }
        return values;
    }

    static final boolean isUnionType(XsdSimpleType sType) {
        sLogger.finest("prove for UnionType");
        return null != sType.getUnion();
    }

    static final String getUnionBase(XsdUnion union) {
        sLogger.warning("Union found return Object and not the first common type");
        return "java.lang.Object";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

