/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.core.CodingSegments;
import com.sap.aii.proxy.generation.core.ItemMetadata;
import com.sap.aii.proxy.generation.core.JavaTypes;
import com.sap.aii.proxy.generation.core.ProxyCodingSegments;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.WsdlPart;
import com.sap.aii.proxy.generation.core.binding.sap.RfcElementProperties;
import com.sap.aii.util.xsd.api.XsdElement;
import com.sap.aii.util.xsd.api.XsdQName;

class ElementMetadata
extends ItemMetadata
implements ProxyCodingSegments,
JavaTypes {
    private boolean isAbstract;
    private int minOccurs;
    private int maxOccurs;
    private boolean isNillable;
    private String substitutionGroup;
    private String lineType;
    private boolean isJco = false;
    private int offset1;
    private int offset2;
    private int offset4;
    private int bytelength1 = -1;
    private int bytelength2 = -1;
    private int bytelength4 = -1;
    private String internalType = "-1";
    private String direction = "0";
    private String abapName;
    private String xml;

    ElementMetadata(XsdElement element, String javaName, String javaType, RfcElementProperties properties) {
        super(element.getQName(), javaName, javaType, ElementMetadata.getXsdlType(element));
        this.init(element, element);
        this.setJco(properties);
    }

    ElementMetadata(XsdElement element, XsdElement referencedFrom, String javaName, String javaType, RfcElementProperties properties) {
        super(element.getQName(), javaName, javaType, ElementMetadata.getXsdlType(element));
        this.init(element, referencedFrom);
        this.setJco(properties);
    }

    ElementMetadata(WsdlPart part, String javaName, String javaType, XsdQName messageName, XsdQName xsdType, String structure) {
        super(messageName, javaName, javaType, xsdType);
        this.setForm("qualified");
        this.setMinOccurs(1);
        this.setMaxOccurs(1);
        this.offset1 = -1;
        this.offset2 = -1;
        this.offset4 = -1;
        this.bytelength1 = -1;
        this.bytelength2 = -1;
        this.bytelength4 = -1;
        this.direction = structure;
        this.lineType = javaType;
    }

    ElementMetadata(String javaName, String javaType) {
        super(null, javaName, javaType, null);
    }

    private void init(XsdElement element, XsdElement referencedFrom) {
        this.setDefaultValue(element.getDefault());
        this.setFixedValue(element.getFixed());
        this.setForm(element.getForm());
        this.setFacets(ProxyHelper.getRestriction(element));
        this.isAbstract = element.isAbstract();
        this.isNillable = element.isNillable();
        this.maxOccurs = referencedFrom.getMaxOccurs();
        this.minOccurs = referencedFrom.getMinOccurs();
        this.substitutionGroup = ProxyHelper.getSubstitutionGroup(element);
    }

    void setJco(RfcElementProperties properties) {
        if (properties != null) {
            this.isJco = true;
            this.abapName = properties.getAbapName();
            this.bytelength1 = properties.getByteLength1();
            this.bytelength2 = properties.getByteLength2();
            this.bytelength4 = properties.getByteLength4();
            this.offset1 = properties.getOffset1();
            this.offset2 = properties.getOffset2();
            this.offset4 = properties.getOffset4();
            this.direction = properties.getDirection();
            this.internalType = properties.getInternalType();
            this.xml = properties.getXml();
        }
    }

    protected final boolean isTable() {
        return this.maxOccurs != 1;
    }

    StringBuffer getDescriptorLine(int index) {
        StringBuffer txt = new StringBuffer();
        txt.append("descriptorSetElementProperties(");
        txt.append("descriptor").append(", ");
        txt.append(index).append(", ");
        txt.append(ProxyHelper.getString(this.getLocalName())).append(", ");
        txt.append(ProxyHelper.getString(this.getDefaultValue())).append(", ");
        txt.append(ProxyHelper.getString(this.getFixedValue())).append(", ");
        txt.append(ProxyHelper.getString(this.getForm())).append(", ");
        txt.append(ProxyHelper.getString(this.getXsdType())).append(", ");
        txt.append(ProxyHelper.getString(this.getNamespace())).append(", ");
        txt.append(this.isAbstract).append(", ");
        txt.append(this.minOccurs).append(", ");
        txt.append(this.maxOccurs).append(", ");
        txt.append(this.isNillable).append(", ");
        txt.append(ProxyHelper.getString(this.substitutionGroup)).append(", ");
        txt.append(ProxyHelper.getString(this.getJavaName())).append(", ");
        txt.append(ProxyHelper.writeType(this.getJavaType())).append(", ");
        txt.append(ProxyHelper.getNewInstance(this.lineType)).append(", ");
        txt.append(ProxyHelper.getRestrictions(this.getFacets())).append(", ");
        txt.append(ProxyHelper.getString(this.abapName)).append(", ");
        txt.append(this.offset1).append(", ");
        txt.append(this.offset2).append(", ");
        txt.append(this.offset4).append(", ");
        txt.append(this.bytelength1).append(", ");
        txt.append(this.bytelength2).append(", ");
        txt.append(this.bytelength4).append(", ");
        txt.append(this.internalType).append(", ");
        txt.append(this.direction).append(", ");
        txt.append(ProxyHelper.getXmlString(this.xml)).append(")");
        txt.append(CodingSegments.END_LINE);
        return txt;
    }

    String getGetType() {
        return ".getElement";
    }

    String getType() {
        return "Element";
    }

    boolean isNillable() {
        return this.isNillable;
    }

    private static XsdQName getXsdlType(XsdElement element) {
        XsdQName type = ProxyHelper.getXsdlTypeQName(element);
        if (type == null) {
            return null;
        }
        return type;
    }

    boolean isRfc() {
        return this.isJco;
    }

    void setLineType(String lineType) {
        this.lineType = lineType;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    String getMetadataCast() {
        if (this.isRfc()) {
            return "(com.sap.aii.proxy.framework.core.JcoMetaData)";
        }
        return "";
    }

    String getMetadataType() {
        if (this.isRfc()) {
            return "com.sap.aii.proxy.framework.core.JcoMetaData";
        }
        return "com.sap.aii.proxy.framework.core.ElementMetaData";
    }

    String getLineType() {
        return this.lineType;
    }

    void setInternalType(String internalType) {
        this.internalType = internalType;
    }
}

