/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.proxy.generation.core;

import com.sap.aii.proxy.generation.api.ProxyGenerationException;
import com.sap.aii.proxy.generation.core.AttributeMetadata;
import com.sap.aii.proxy.generation.core.ElementMetadata;
import com.sap.aii.proxy.generation.core.GeneratorBasics;
import com.sap.aii.proxy.generation.core.GenericInnerClass;
import com.sap.aii.proxy.generation.core.MessageId;
import com.sap.aii.proxy.generation.core.MetaProxyGenerator;
import com.sap.aii.proxy.generation.core.PathException;
import com.sap.aii.proxy.generation.core.ProxyEnumerationClass;
import com.sap.aii.proxy.generation.core.ProxyHelper;
import com.sap.aii.proxy.generation.core.ProxyTypeClass;
import com.sap.aii.proxy.generation.core.RfcHelper;
import com.sap.aii.proxy.generation.core.Wsdl;
import com.sap.aii.proxy.generation.core.binding.sap.SapBinding;
import com.sap.aii.proxy.generation.core.binding.sap.SapType;
import com.sap.aii.proxy.generation.core.nameMapping.GlobalNameMapping;
import com.sap.aii.proxy.generation.core.nameMapping.LocalNameMapping;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xsd.api.XsdAttribute;
import com.sap.aii.util.xsd.api.XsdAttributeGroup;
import com.sap.aii.util.xsd.api.XsdComplexType;
import com.sap.aii.util.xsd.api.XsdContent;
import com.sap.aii.util.xsd.api.XsdExtension;
import com.sap.aii.util.xsd.api.XsdParticle;
import com.sap.aii.util.xsd.api.XsdQName;
import com.sap.aii.util.xsd.api.XsdRestriction;
import com.sap.aii.util.xsd.api.XsdSimpleType;
import com.sap.aii.util.xsd.api.XsdTypeDef;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class ComplexTypeGenerator
extends MetaProxyGenerator {
    private static final Logger LOG = Logger.getLogger((String)(class$com$sap$aii$proxy$generation$core$ComplexTypeGenerator == null ? (class$com$sap$aii$proxy$generation$core$ComplexTypeGenerator = ComplexTypeGenerator.class$("com.sap.aii.proxy.generation.core.ComplexTypeGenerator")) : class$com$sap$aii$proxy$generation$core$ComplexTypeGenerator).getName());
    static /* synthetic */ Class class$com$sap$aii$proxy$generation$core$ComplexTypeGenerator;

    ComplexTypeGenerator(GlobalNameMapping globalNames, Wsdl wsdl, SapBinding binding, boolean isRfc) throws ProxyGenerationException {
        super(globalNames, wsdl, binding, isRfc);
    }

    ComplexTypeGenerator(GlobalNameMapping globalNames, Wsdl wsdl, boolean isRfc, LocalNameMapping localNames, String connectionType, String oldFile) throws ProxyGenerationException, PathException {
        super(globalNames, wsdl, isRfc, localNames, connectionType, oldFile);
    }

    private final void addAttribute(XsdAttribute attribute, XsdAttribute referencedFrom) throws ProxyGenerationException, PathException {
        String javaName = this.localNames.addAttribute(attribute.getName(), false);
        try {
            String javaType = this.getSimpleBaseType(attribute);
            XsdTypeDef localTypeDef = attribute.getLocalTypeDef();
            boolean isEnum = false;
            if (localTypeDef == null) {
                XsdQName globalType = attribute.getGlobalTypeName();
                XsdTypeDef globalTypeDef = this.getWsdl().getType(globalType);
                if (globalTypeDef != null) {
                    isEnum = GeneratorBasics.isEnumType((XsdSimpleType)globalTypeDef);
                }
            } else if (localTypeDef instanceof XsdSimpleType && GeneratorBasics.isEnumType((XsdSimpleType)localTypeDef)) {
                isEnum = true;
                String enumType = this.getSimpleBaseType(attribute);
                String fullEnumName = this.localNames.getFullAttributeType(attribute.getName());
                Set set = GeneratorBasics.getEnumValues((XsdSimpleType)localTypeDef);
                ProxyEnumerationClass enumClass = new ProxyEnumerationClass(fullEnumName, enumType, set, this.isRfc(), this.getOldFile());
                this.getProxyTypeClass().addInnerType((GenericInnerClass)enumClass.getEnumClass());
                javaType = fullEnumName;
            }
            if (referencedFrom == null) {
                this.getProxyTypeClass().addAttribute(new AttributeMetadata(attribute, javaName, javaType, isEnum));
            } else {
                this.getProxyTypeClass().addAttribute(new AttributeMetadata(attribute, referencedFrom, javaName, javaType, isEnum));
            }
        }
        catch (PathException e) {
            throw e.addPathPart("<attribute name =\"" + attribute.getName() + "\">");
        }
    }

    private final void addAttribute(XsdAttribute attribute) throws ProxyGenerationException, PathException {
        XsdQName ref = attribute.getRef();
        if (ref != null) {
            XsdAttribute refAttribute = this.getWsdl().getAttribute(ref);
            this.addAttribute(refAttribute, attribute);
        } else {
            this.addAttribute(attribute, null);
        }
    }

    final void addAttributes(List attributes) throws ProxyGenerationException, PathException {
        int i = 0;
        while (i < attributes.size()) {
            Object att = attributes.get(i);
            if (att instanceof XsdAttribute) {
                XsdAttribute attribute = (XsdAttribute)att;
                this.addAttribute(attribute);
            } else {
                this.addAttributeGroup((XsdAttributeGroup)att);
            }
            ++i;
        }
    }

    private void addAttributeGroup(XsdAttributeGroup attGroup) throws ProxyGenerationException, PathException {
        XsdAttributeGroup globalAttGr = this.getWsdl().getAttributeGroup(attGroup.getRef());
        try {
            this.addAttributes(globalAttGr.getAttributes());
        }
        catch (PathException e) {
            throw e.addPathPart("<attributeGroup ref =\"" + attGroup.getQName() + "\" >");
        }
    }

    final void addContent(XsdComplexType cType, SapType sapType) throws ProxyGenerationException, PathException {
        switch (cType.getContentType()) {
            case 0: {
                Map elementProperties = RfcHelper.getElementProperties(sapType);
                this.addParticle(cType.getParticle(), elementProperties);
                break;
            }
            case 1: {
                XsdContent content = cType.getContent();
                try {
                    this.addSimpleContent(content, cType);
                    break;
                }
                catch (PathException e) {
                    throw e.addPathPart("<simpleContent>");
                }
            }
            case 2: {
                XsdContent content = cType.getContent();
                try {
                    this.addComplexContent(content);
                    break;
                }
                catch (PathException e) {
                    throw e.addPathPart("<complexContent>");
                }
            }
        }
    }

    private final void addComplexContent(XsdContent content) throws ProxyGenerationException, PathException {
        XsdRestriction restriction = content.getRestriction();
        if (restriction != null) {
            this.addComplexRestriction(restriction);
        } else {
            XsdExtension extension = content.getExtension();
            if (extension != null) {
                this.addComplexExtension(extension);
            } else {
                throw new PathException((ProxyGenerationException.MessageId)MessageId.MISSING, new Object[]{"<restriction or extension>"});
            }
        }
    }

    private void addComplexExtension(XsdExtension extension) throws ProxyGenerationException, PathException {
        LOG.finest("add complexContent extension");
        XsdQName baseName = extension.getBaseType();
        if (baseName == null) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.MISSING_TYPEDERF_FOR_BASE, new Object[]{"<extension>"});
        }
        XsdTypeDef baseType = this.getWsdl().getType(baseName);
        if (!(baseType instanceof XsdComplexType)) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.MISSING, new Object[]{"<extension of simpleType>"});
        }
        this.getProxyTypeClass().setBase(baseName);
        XsdParticle particle = extension.getParticle();
        this.addParticle(particle, null);
        this.addAttributes(extension.getAttributes());
    }

    private void addComplexRestriction(XsdRestriction restriction) throws ProxyGenerationException, PathException {
        LOG.finest("add complexContent extension");
        this.getProxyTypeClass().setIsRestricted(true);
        XsdQName baseName = restriction.getBaseType();
        if (baseName == null) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.MISSING_TYPEDERF_FOR_BASE, new Object[]{"<extension>"});
        }
        XsdTypeDef baseType = this.getWsdl().getType(baseName);
        if (!(baseType instanceof XsdComplexType)) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.MISSING, new Object[]{"<restriction of complexType>"});
        }
        this.getProxyTypeClass().setBase(baseName);
        XsdParticle particle = restriction.getParticle();
        this.addParticle(particle, null);
        this.addAttributes(restriction.getAttributes());
    }

    private final void addSimpleContent(XsdContent content, XsdComplexType cType) throws ProxyGenerationException, PathException {
        XsdRestriction restriction = content.getRestriction();
        if (restriction != null) {
            this.addSimpleRestriction(restriction, cType);
        } else {
            XsdExtension extension = content.getExtension();
            if (extension != null) {
                this.addSimpleExtension(extension, cType);
            } else {
                throw new PathException((ProxyGenerationException.MessageId)MessageId.MISSING, new Object[]{"<restriction or extension>"});
            }
        }
    }

    void addSimpleExtension(XsdExtension extension, XsdComplexType cType) throws ProxyGenerationException, PathException {
        XsdQName baseName = extension.getBaseType();
        if (baseName == null) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.BASE_MISSING, new Object[0]);
        }
        XsdTypeDef typeDef = this.getWsdl().getType(baseName);
        String javaType = this.getGlobalNames().getFullNameType(baseName);
        if (!ProxyHelper.isBuildInType(javaType) && !(typeDef instanceof XsdSimpleType)) {
            throw new PathException((ProxyGenerationException.MessageId)MessageId.SIMPLE_TYPE_EXPECTED, new Object[0]);
        }
        String type = this.getSimpleBaseType(baseName);
        if (ProxyHelper.isBuildInType(type)) {
            this.addValueElement("content", type, type);
            LOG.finest("attributes already added");
        } else {
            this.addValueElement("content", type, type);
            LOG.finest("attributes already added");
        }
    }

    void addSimpleRestriction(XsdRestriction restriction, XsdComplexType cType) throws ProxyGenerationException, PathException {
        LOG.finest("add simpelContent restriction");
        throw new UnsupportedOperationException("restriction of simpleType");
    }

    private void addValueElement(String javaName, String javaType, String typeName) {
        ElementMetadata metadata = new ElementMetadata(javaName, javaType);
        metadata.setForm("unqualified");
        metadata.setMinOccurs(1);
        metadata.setMaxOccurs(1);
        this.getProxyTypeClass().addElement(metadata);
    }

    abstract ProxyTypeClass getProxyTypeClass();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

